/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.entity;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.pixelbank.burnt.init.BurntModEntities;
import net.pixelbank.burnt.init.BurntModItems;
import net.pixelbank.burnt.procedures.ExtinguishBlockProcedure;
import net.pixelbank.burnt.procedures.ExtinguishEntityProcedure;
import net.pixelbank.burnt.procedures.SprayProjectileHitsPlayerProcedure;
import net.pixelbank.burnt.procedures.SprayWhileProjectileFlyingTickProcedure;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class SprayEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)BurntModItems.EXTINGUISHER_SPRAY.get());

    public SprayEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)BurntModEntities.SPRAY.get(), world);
    }

    public SprayEntity(EntityType<? extends SprayEntity> type, Level world) {
        super(type, world);
    }

    public SprayEntity(EntityType<? extends SprayEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public SprayEntity(EntityType<? extends SprayEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_6123_(Player entity) {
        super.m_6123_(entity);
        SprayProjectileHitsPlayerProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)entity, this.m_19749_());
    }

    public void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        ExtinguishEntityProcedure.execute((LevelAccessor)this.m_9236_(), entityHitResult.m_82443_());
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        ExtinguishBlockProcedure.execute((LevelAccessor)this.m_9236_(), blockHitResult.m_82425_().m_123341_(), blockHitResult.m_82425_().m_123342_(), blockHitResult.m_82425_().m_123343_());
    }

    public void m_8119_() {
        super.m_8119_();
        SprayWhileProjectileFlyingTickProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        if (this.f_36703_) {
            this.m_146870_();
        }
    }

    public static SprayEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return SprayEntity.shoot(world, entity, source, 2.0f, 0.0, 0);
    }

    public static SprayEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return SprayEntity.shoot(world, entity, source, pullingPower * 2.0f, 0.0, 0);
    }

    public static SprayEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        SprayEntity entityarrow = new SprayEntity((EntityType<? extends SprayEntity>)((EntityType)BurntModEntities.SPRAY.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.water.ambient")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static SprayEntity shoot(LivingEntity entity, LivingEntity target) {
        SprayEntity entityarrow = new SprayEntity((EntityType<? extends SprayEntity>)((EntityType)BurntModEntities.SPRAY.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 4.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(0.0);
        entityarrow.m_36735_(0);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.water.ambient")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }
}

