/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.pixelbank.burnt.entity.BlazeArrowEntity;
import net.pixelbank.burnt.entity.BurntForestSpawnerEntity;
import net.pixelbank.burnt.entity.FallingSlabEntity;
import net.pixelbank.burnt.entity.FireDevilEntity;
import net.pixelbank.burnt.entity.FireballEntity;
import net.pixelbank.burnt.entity.FlintTrailEntity;
import net.pixelbank.burnt.entity.GeyserEntity;
import net.pixelbank.burnt.entity.GraveSpawnerEntity;
import net.pixelbank.burnt.entity.LitMatchEntity;
import net.pixelbank.burnt.entity.LitMolotovProjectileEntity;
import net.pixelbank.burnt.entity.MolotovProjectileEntity;
import net.pixelbank.burnt.entity.MolotovTarEntity;
import net.pixelbank.burnt.entity.SmokeEntity;
import net.pixelbank.burnt.entity.SoulArrowEntity;
import net.pixelbank.burnt.entity.SoulSparkEntity;
import net.pixelbank.burnt.entity.SoulSpawnerEntity;
import net.pixelbank.burnt.entity.SparkEntity;
import net.pixelbank.burnt.entity.SprayEntity;
import net.pixelbank.burnt.entity.TarSplashEntity;
import net.pixelbank.burnt.entity.TombSpawnerEntity;
import net.pixelbank.burnt.entity.VolcanoEntity;
import net.pixelbank.burnt.entity.WispEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BurntModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"burnt");
    public static final RegistryObject<EntityType<SparkEntity>> SPARK = BurntModEntities.register("spark", EntityType.Builder.m_20704_(SparkEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(0).setUpdateInterval(3).setCustomClientFactory(SparkEntity::new).m_20699_(0.1f, 0.1f));
    public static final RegistryObject<EntityType<SprayEntity>> SPRAY = BurntModEntities.register("spray", EntityType.Builder.m_20704_(SprayEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(SprayEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<SoulSparkEntity>> SOUL_SPARK = BurntModEntities.register("soul_spark", EntityType.Builder.m_20704_(SoulSparkEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(0).setUpdateInterval(3).setCustomClientFactory(SoulSparkEntity::new).m_20699_(0.1f, 0.1f));
    public static final RegistryObject<EntityType<BurntForestSpawnerEntity>> BURNT_FOREST_SPAWNER = BurntModEntities.register("burnt_forest_spawner", EntityType.Builder.m_20704_(BurntForestSpawnerEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(24).setUpdateInterval(3).setCustomClientFactory(BurntForestSpawnerEntity::new).m_20719_().m_20699_(0.4f, 0.7f));
    public static final RegistryObject<EntityType<GraveSpawnerEntity>> GRAVE_SPAWNER = BurntModEntities.register("grave_spawner", EntityType.Builder.m_20704_(GraveSpawnerEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(24).setUpdateInterval(3).setCustomClientFactory(GraveSpawnerEntity::new).m_20699_(0.4f, 0.7f));
    public static final RegistryObject<EntityType<TombSpawnerEntity>> TOMB_SPAWNER = BurntModEntities.register("tomb_spawner", EntityType.Builder.m_20704_(TombSpawnerEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(24).setUpdateInterval(3).setCustomClientFactory(TombSpawnerEntity::new).m_20699_(0.4f, 0.7f));
    public static final RegistryObject<EntityType<SoulSpawnerEntity>> SOUL_SPAWNER = BurntModEntities.register("soul_spawner", EntityType.Builder.m_20704_(SoulSpawnerEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(24).setUpdateInterval(3).setCustomClientFactory(SoulSpawnerEntity::new).m_20699_(0.4f, 0.7f));
    public static final RegistryObject<EntityType<WispEntity>> WISP = BurntModEntities.register("wisp", EntityType.Builder.m_20704_(WispEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(WispEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<FireDevilEntity>> FIRE_DEVIL = BurntModEntities.register("fire_devil", EntityType.Builder.m_20704_(FireDevilEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FireDevilEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<FlintTrailEntity>> FLINT_TRAIL = BurntModEntities.register("flint_trail", EntityType.Builder.m_20704_(FlintTrailEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(FlintTrailEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<SmokeEntity>> SMOKE = BurntModEntities.register("smoke", EntityType.Builder.m_20704_(SmokeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SmokeEntity::new).m_20719_().m_20699_(0.01f, 0.01f));
    public static final RegistryObject<EntityType<BlazeArrowEntity>> BLAZE_ARROW = BurntModEntities.register("blaze_arrow", EntityType.Builder.m_20704_(BlazeArrowEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(BlazeArrowEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.2f, 0.2f));
    public static final RegistryObject<EntityType<SoulArrowEntity>> SOUL_ARROW = BurntModEntities.register("soul_arrow", EntityType.Builder.m_20704_(SoulArrowEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(SoulArrowEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.2f, 0.2f));
    public static final RegistryObject<EntityType<GeyserEntity>> GEYSER = BurntModEntities.register("geyser", EntityType.Builder.m_20704_(GeyserEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(GeyserEntity::new).m_20719_().m_20699_(0.4f, 0.7f));
    public static final RegistryObject<EntityType<VolcanoEntity>> VOLCANO = BurntModEntities.register("volcano", EntityType.Builder.m_20704_(VolcanoEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(VolcanoEntity::new).m_20719_().m_20699_(0.0f, 0.0f));
    public static final RegistryObject<EntityType<FireballEntity>> FIREBALL = BurntModEntities.register("fireball", EntityType.Builder.m_20704_(FireballEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(FireballEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<LitMolotovProjectileEntity>> LIT_MOLOTOV_PROJECTILE = BurntModEntities.register("lit_molotov_projectile", EntityType.Builder.m_20704_(LitMolotovProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(LitMolotovProjectileEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.2f, 0.2f));
    public static final RegistryObject<EntityType<MolotovProjectileEntity>> MOLOTOV_PROJECTILE = BurntModEntities.register("molotov_projectile", EntityType.Builder.m_20704_(MolotovProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(MolotovProjectileEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.2f, 0.2f));
    public static final RegistryObject<EntityType<LitMatchEntity>> LIT_MATCH = BurntModEntities.register("lit_match", EntityType.Builder.m_20704_(LitMatchEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(LitMatchEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<MolotovTarEntity>> MOLOTOV_TAR = BurntModEntities.register("molotov_tar", EntityType.Builder.m_20704_(MolotovTarEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MolotovTarEntity::new).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<FallingSlabEntity>> FALLING_SLAB = BurntModEntities.register("falling_slab", EntityType.Builder.m_20704_(FallingSlabEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(FallingSlabEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<TarSplashEntity>> TAR_SPLASH = BurntModEntities.register("tar_splash", EntityType.Builder.m_20704_(TarSplashEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(TarSplashEntity::new).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SparkEntity.init();
            SoulSparkEntity.init();
            BurntForestSpawnerEntity.init();
            GraveSpawnerEntity.init();
            TombSpawnerEntity.init();
            SoulSpawnerEntity.init();
            WispEntity.init();
            FireDevilEntity.init();
            SmokeEntity.init();
            GeyserEntity.init();
            VolcanoEntity.init();
            MolotovTarEntity.init();
            FallingSlabEntity.init();
            TarSplashEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SPARK.get(), SparkEntity.createAttributes().m_22265_());
        event.put((EntityType)SOUL_SPARK.get(), SoulSparkEntity.createAttributes().m_22265_());
        event.put((EntityType)BURNT_FOREST_SPAWNER.get(), BurntForestSpawnerEntity.createAttributes().m_22265_());
        event.put((EntityType)GRAVE_SPAWNER.get(), GraveSpawnerEntity.createAttributes().m_22265_());
        event.put((EntityType)TOMB_SPAWNER.get(), TombSpawnerEntity.createAttributes().m_22265_());
        event.put((EntityType)SOUL_SPAWNER.get(), SoulSpawnerEntity.createAttributes().m_22265_());
        event.put((EntityType)WISP.get(), WispEntity.createAttributes().m_22265_());
        event.put((EntityType)FIRE_DEVIL.get(), FireDevilEntity.createAttributes().m_22265_());
        event.put((EntityType)SMOKE.get(), SmokeEntity.createAttributes().m_22265_());
        event.put((EntityType)GEYSER.get(), GeyserEntity.createAttributes().m_22265_());
        event.put((EntityType)VOLCANO.get(), VolcanoEntity.createAttributes().m_22265_());
        event.put((EntityType)MOLOTOV_TAR.get(), MolotovTarEntity.createAttributes().m_22265_());
        event.put((EntityType)FALLING_SLAB.get(), FallingSlabEntity.createAttributes().m_22265_());
        event.put((EntityType)TAR_SPLASH.get(), TarSplashEntity.createAttributes().m_22265_());
    }
}

