/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.integration;

import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.pixelbank.burnt.network.BurntModVariables;

@Mod.EventBusSubscriber(modid="burnt", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class Weather2Sampler {
    private static final int PERIOD = 10;
    private static boolean tried = false;
    private static Class<?> clsWindReader;
    private static Class<?> clsServerTickHandler;
    private static Class<?> clsWeatherManagerServer;
    private static Class<?> clsStormObject;
    private static Class<?> clsParticleStorm;
    private static Method mAngleLevel;
    private static Method mAngleLevelPos;
    private static Method mSpeedCached;
    private static Method mSpeed;
    private static Method mGetMgrByDim;
    private static Method mMgrPrecipAtVec3;
    private static Method mMgrClosestStormAny;
    private static Method mStormIsPrecipitating;
    private static Method mStormCanPrecip;
    private static double lastAngle;
    private static double lastSpeed;
    private static double lastPrecip;
    private static boolean hasSample;

    private static boolean apiReady() {
        if (!ModList.get().isLoaded("weather2")) {
            return false;
        }
        if (tried) {
            return clsWindReader != null;
        }
        tried = true;
        try {
            clsWindReader = Class.forName("weather2.util.WindReader");
            clsServerTickHandler = Class.forName("weather2.ServerTickHandler");
            clsWeatherManagerServer = Class.forName("weather2.weathersystem.WeatherManagerServer");
            clsStormObject = Class.forName("weather2.weathersystem.storm.StormObject");
            try {
                clsParticleStorm = Class.forName("weather2.weathersystem.storm.WeatherObjectParticleStorm");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                mAngleLevel = clsWindReader.getMethod("getWindAngle", Level.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                mAngleLevelPos = clsWindReader.getMethod("getWindAngle", Level.class, Vec3.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                mSpeedCached = clsWindReader.getMethod("getWindSpeedCached", Level.class, BlockPos.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                mSpeed = clsWindReader.getMethod("getWindSpeed", Level.class, BlockPos.class, Float.TYPE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (Method m : clsServerTickHandler.getMethods()) {
                if (m.getParameterCount() != 1 || !m.getParameterTypes()[0].getName().equals("net.minecraft.resources.ResourceKey") || !m.getReturnType().getName().equals("weather2.weathersystem.WeatherManagerServer")) continue;
                mGetMgrByDim = m;
                break;
            }
            for (Method m : clsWeatherManagerServer.getMethods()) {
                if (m.getReturnType() != Float.TYPE || m.getParameterCount() != 1 || !m.getParameterTypes()[0].getName().equals("net.minecraft.world.phys.Vec3")) continue;
                mMgrPrecipAtVec3 = m;
                break;
            }
            for (Method m : clsWeatherManagerServer.getMethods()) {
                if (m.getParameterCount() != 2 || !m.getParameterTypes()[0].getName().equals("net.minecraft.world.phys.Vec3") || m.getParameterTypes()[1] != Double.TYPE || !m.getReturnType().getName().equals("weather2.weathersystem.storm.StormObject")) continue;
                mMgrClosestStormAny = m;
                break;
            }
            try {
                mStormIsPrecipitating = clsStormObject.getMethod("isPrecipitating", new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (clsParticleStorm != null) {
                try {
                    mStormCanPrecip = clsParticleStorm.getMethod("canPrecip", new Class[0]);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ignored) {
            clsWindReader = null;
        }
        return clsWindReader != null;
    }

    private static Float getAngleDeg(Level level, Vec3 pos) {
        if (!Weather2Sampler.apiReady()) {
            return null;
        }
        try {
            if (mAngleLevelPos != null && pos != null) {
                return (Float)mAngleLevelPos.invoke(null, level, pos);
            }
            if (mAngleLevel != null) {
                return (Float)mAngleLevel.invoke(null, level);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Float getSpeed(Level level, BlockPos pos) {
        if (!Weather2Sampler.apiReady()) {
            return null;
        }
        try {
            if (mSpeedCached != null) {
                return (Float)mSpeedCached.invoke(null, level, pos);
            }
            if (mSpeed != null) {
                return (Float)mSpeed.invoke(null, level, pos, Float.valueOf(1.0f));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Object getManager(ServerLevel server) {
        if (!Weather2Sampler.apiReady() || mGetMgrByDim == null) {
            return null;
        }
        try {
            return mGetMgrByDim.invoke(null, server.m_46472_());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Float getPrecipStrength(Object mgr, Vec3 pos) {
        if (mgr == null) {
            return null;
        }
        try {
            Object storm;
            if (mMgrPrecipAtVec3 != null) {
                return (Float)mMgrPrecipAtVec3.invoke(mgr, pos);
            }
            if (mMgrClosestStormAny != null && (storm = mMgrClosestStormAny.invoke(mgr, pos, 300.0)) != null) {
                boolean precipNow;
                boolean canPrecip = true;
                if (mStormCanPrecip != null && clsParticleStorm != null && clsParticleStorm.isInstance(storm)) {
                    canPrecip = (Boolean)mStormCanPrecip.invoke(storm, new Object[0]);
                }
                boolean bl = precipNow = mStormIsPrecipitating != null && (Boolean)mStormIsPrecipitating.invoke(storm, new Object[0]) != false;
                if (canPrecip && precipNow) {
                    return Float.valueOf(1.0f);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Float.valueOf(0.0f);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public static void onLevelTick(TickEvent.LevelTickEvent e) {
        block14: {
            BlockPos samplePos;
            if (e.phase != TickEvent.Phase.END) {
                return;
            }
            Level lvl = e.level;
            if (!(lvl instanceof ServerLevel)) {
                return;
            }
            ServerLevel server = (ServerLevel)lvl;
            if (server.m_46472_() != Level.f_46428_) {
                return;
            }
            if (server.m_46467_() % 10L != 0L) {
                return;
            }
            BurntModVariables.MapVariables map = BurntModVariables.MapVariables.get((LevelAccessor)server);
            if (!Weather2Sampler.apiReady()) {
                if (map.w2_available) {
                    map.w2_available = false;
                    map.syncData((LevelAccessor)server);
                }
                return;
            }
            List players = server.m_6907_();
            if (!players.isEmpty()) {
                ServerPlayer p = (ServerPlayer)players.get(0);
                y = Math.min(server.m_151558_() - 2, Math.max(server.m_141937_() + 2, (int)p.m_20186_() + 8));
                samplePos = new BlockPos((int)p.m_20185_(), y, (int)p.m_20189_());
            } else {
                BlockPos spawn = server.m_220360_();
                y = Math.min(server.m_151558_() - 2, Math.max(server.m_141937_() + 2, server.m_5736_() + 16));
                samplePos = new BlockPos(spawn.m_123341_(), y, spawn.m_123343_());
            }
            try {
                boolean ok;
                Float angle = Weather2Sampler.getAngleDeg((Level)server, new Vec3((double)samplePos.m_123341_(), (double)samplePos.m_123342_(), (double)samplePos.m_123343_()));
                Float speed = Weather2Sampler.getSpeed((Level)server, samplePos);
                Float precip = Weather2Sampler.getPrecipStrength(Weather2Sampler.getManager(server), new Vec3((double)samplePos.m_123341_() + 0.5, (double)samplePos.m_123342_() + 0.5, (double)samplePos.m_123343_() + 0.5));
                boolean bl = ok = angle != null && speed != null && precip != null && !angle.isNaN() && !speed.isNaN() && !precip.isNaN() && Float.isFinite(angle.floatValue()) && Float.isFinite(speed.floatValue()) && Float.isFinite(precip.floatValue());
                if (ok) {
                    lastAngle = angle.doubleValue();
                    lastSpeed = speed.doubleValue();
                    lastPrecip = Math.max(0.0, Math.min(1.0, precip.doubleValue()));
                    hasSample = true;
                }
                if (hasSample) {
                    map.w2_available = true;
                    map.w2_angle_deg = lastAngle;
                    map.w2_speed = lastSpeed;
                    map.w2_precip_str = lastPrecip;
                    map.w2_precip = lastPrecip > 0.05;
                    map.syncData((LevelAccessor)server);
                } else if (map.w2_available) {
                    map.w2_available = false;
                    map.syncData((LevelAccessor)server);
                }
            }
            catch (Throwable ignored) {
                if (hasSample || !map.w2_available) break block14;
                map.w2_available = false;
                map.syncData((LevelAccessor)server);
            }
        }
    }

    private Weather2Sampler() {
    }

    static {
        lastAngle = 0.0;
        lastSpeed = 0.0;
        lastPrecip = 0.0;
        hasSample = false;
    }
}

