/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.item;

import com.google.common.collect.Iterables;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.pixelbank.burnt.init.BurntModBlocks;
import net.pixelbank.burnt.procedures.FireProofArmorBootsTickEventProcedure;
import net.pixelbank.burnt.procedures.FireProofArmorChestplateTickEventProcedure;
import net.pixelbank.burnt.procedures.FireProofArmorHelmetTickEventProcedure;
import net.pixelbank.burnt.procedures.FireProofArmorLeggingsTickEventProcedure;

public abstract class NetherWeaveArmorItem
extends ArmorItem {
    public NetherWeaveArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 5;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{1, 2, 3, 1})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 9;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wool.place"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BurntModBlocks.NETHER_WEAVE.get())});
            }

            public String m_6082_() {
                return "nether_weave_armor";
            }

            public float m_6651_() {
                return 0.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends NetherWeaveArmorItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().m_41486_());
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237115_((String)"item.burnt.nether_weave_armor_boots.description_0"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "burnt:textures/models/armor/fire_proof_suit_layer_1.png";
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                FireProofArmorBootsTickEventProcedure.execute(entity, itemstack);
            }
        }
    }

    public static class Leggings
    extends NetherWeaveArmorItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().m_41486_());
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237115_((String)"item.burnt.nether_weave_armor_leggings.description_0"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "burnt:textures/models/armor/fire_proof_suit_layer_2.png";
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                FireProofArmorLeggingsTickEventProcedure.execute(entity, itemstack);
            }
        }
    }

    public static class Chestplate
    extends NetherWeaveArmorItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41486_());
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237115_((String)"item.burnt.nether_weave_armor_chestplate.description_0"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "burnt:textures/models/armor/fire_proof_suit_layer_1.png";
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                FireProofArmorChestplateTickEventProcedure.execute(entity, itemstack);
            }
        }
    }

    public static class Helmet
    extends NetherWeaveArmorItem {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties().m_41486_());
        }

        public void m_7373_(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
            super.m_7373_(itemstack, level, list, flag);
            list.add((Component)Component.m_237115_((String)"item.burnt.nether_weave_armor_helmet.description_0"));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "burnt:textures/models/armor/fire_proof_suit_layer_1.png";
        }

        public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.m_6883_(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).m_6168_(), (Object)itemstack)) {
                FireProofArmorHelmetTickEventProcedure.execute(entity, itemstack);
            }
        }
    }
}

