/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.network;

import com.google.gson.JsonArray;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.pixelbank.burnt.BurntMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BurntModVariables {
    public static JsonArray bf_points = new JsonArray();
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BurntMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        BurntMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.arrowFired = message.data.arrowFired;
                    variables.extinguisherOn = message.data.extinguisherOn;
                    variables.flintDrawn = message.data.flintDrawn;
                    variables.playerSoul = message.data.playerSoul;
                    variables.soulDrawn = message.data.soulDrawn;
                    variables.blazeDrawn = message.data.blazeDrawn;
                    variables.gasMaskOn = message.data.gasMaskOn;
                    variables.facePlayer = message.data.facePlayer;
                    variables.PlayerTickDelay = message.data.PlayerTickDelay;
                    variables.fireProof = message.data.fireProof;
                    variables.matchBurn = message.data.matchBurn;
                    variables.smokeAir = message.data.smokeAir;
                    variables.smokeExposure = message.data.smokeExposure;
                    variables.smokeDamageTimer = message.data.smokeDamageTimer;
                    variables.freshAirTicks = message.data.freshAirTicks;
                    variables.dl_cool = message.data.dl_cool;
                    variables.dl_pending_clear = message.data.dl_pending_clear;
                    variables.dl_active = message.data.dl_active;
                    variables.wasInSmoke = message.data.wasInSmoke;
                    variables.ml_cool = message.data.ml_cool;
                    variables.ml_pending_clear = message.data.ml_pending_clear;
                    variables.ml_active = message.data.ml_active;
                    variables.mol_cool = message.data.mol_cool;
                    variables.mol_pending_clear = message.data.mol_pending_clear;
                    variables.mol_active = message.data.mol_active;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean arrowFired = false;
        public boolean extinguisherOn = false;
        public boolean flintDrawn = false;
        public boolean playerSoul = false;
        public boolean soulDrawn = false;
        public boolean blazeDrawn = false;
        public boolean gasMaskOn = false;
        public double facePlayer = 0.0;
        public double PlayerTickDelay = 0.0;
        public double fireProof = 0.0;
        public double matchBurn = 0.0;
        public double smokeAir = 100.0;
        public double smokeExposure = 0.0;
        public double smokeDamageTimer = 0.0;
        public double freshAirTicks = 0.0;
        public double dl_cool = 0.0;
        public boolean dl_pending_clear = false;
        public boolean dl_active = false;
        public boolean wasInSmoke = false;
        public double ml_cool = 0.0;
        public boolean ml_pending_clear = false;
        public boolean ml_active = false;
        public double mol_cool = 0.0;
        public boolean mol_pending_clear = false;
        public boolean mol_active = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BurntMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("arrowFired", this.arrowFired);
            nbt.m_128379_("extinguisherOn", this.extinguisherOn);
            nbt.m_128379_("flintDrawn", this.flintDrawn);
            nbt.m_128379_("playerSoul", this.playerSoul);
            nbt.m_128379_("soulDrawn", this.soulDrawn);
            nbt.m_128379_("blazeDrawn", this.blazeDrawn);
            nbt.m_128379_("gasMaskOn", this.gasMaskOn);
            nbt.m_128347_("facePlayer", this.facePlayer);
            nbt.m_128347_("PlayerTickDelay", this.PlayerTickDelay);
            nbt.m_128347_("fireProof", this.fireProof);
            nbt.m_128347_("matchBurn", this.matchBurn);
            nbt.m_128347_("smokeAir", this.smokeAir);
            nbt.m_128347_("smokeExposure", this.smokeExposure);
            nbt.m_128347_("smokeDamageTimer", this.smokeDamageTimer);
            nbt.m_128347_("freshAirTicks", this.freshAirTicks);
            nbt.m_128347_("dl_cool", this.dl_cool);
            nbt.m_128379_("dl_pending_clear", this.dl_pending_clear);
            nbt.m_128379_("dl_active", this.dl_active);
            nbt.m_128379_("wasInSmoke", this.wasInSmoke);
            nbt.m_128347_("ml_cool", this.ml_cool);
            nbt.m_128379_("ml_pending_clear", this.ml_pending_clear);
            nbt.m_128379_("ml_active", this.ml_active);
            nbt.m_128347_("mol_cool", this.mol_cool);
            nbt.m_128379_("mol_pending_clear", this.mol_pending_clear);
            nbt.m_128379_("mol_active", this.mol_active);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.arrowFired = nbt.m_128471_("arrowFired");
            this.extinguisherOn = nbt.m_128471_("extinguisherOn");
            this.flintDrawn = nbt.m_128471_("flintDrawn");
            this.playerSoul = nbt.m_128471_("playerSoul");
            this.soulDrawn = nbt.m_128471_("soulDrawn");
            this.blazeDrawn = nbt.m_128471_("blazeDrawn");
            this.gasMaskOn = nbt.m_128471_("gasMaskOn");
            this.facePlayer = nbt.m_128459_("facePlayer");
            this.PlayerTickDelay = nbt.m_128459_("PlayerTickDelay");
            this.fireProof = nbt.m_128459_("fireProof");
            this.matchBurn = nbt.m_128459_("matchBurn");
            this.smokeAir = nbt.m_128459_("smokeAir");
            this.smokeExposure = nbt.m_128459_("smokeExposure");
            this.smokeDamageTimer = nbt.m_128459_("smokeDamageTimer");
            this.freshAirTicks = nbt.m_128459_("freshAirTicks");
            this.dl_cool = nbt.m_128459_("dl_cool");
            this.dl_pending_clear = nbt.m_128471_("dl_pending_clear");
            this.dl_active = nbt.m_128471_("dl_active");
            this.wasInSmoke = nbt.m_128471_("wasInSmoke");
            this.ml_cool = nbt.m_128459_("ml_cool");
            this.ml_pending_clear = nbt.m_128471_("ml_pending_clear");
            this.ml_active = nbt.m_128471_("ml_active");
            this.mol_cool = nbt.m_128459_("mol_cool");
            this.mol_pending_clear = nbt.m_128471_("mol_pending_clear");
            this.mol_active = nbt.m_128471_("mol_active");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("burnt", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "burnt_mapvars";
        public boolean burntOn = true;
        public boolean biomeSpecific = false;
        public boolean rainExtinguish = true;
        public boolean collapseOn = true;
        public boolean flameParticles = true;
        public boolean ashParticles = true;
        public boolean burnDamage = true;
        public boolean smokeParticles = true;
        public boolean sootOn = true;
        public boolean vanillaCatch = true;
        public boolean craftedBlocksBurn = true;
        public boolean fireDevil = true;
        public boolean wisp = true;
        public boolean woolBurns = true;
        public boolean flameBowOn = true;
        public boolean fireAspectOn = false;
        public boolean structuresOn = true;
        public boolean lightningCatch = false;
        public boolean smokeFogParticles = true;
        public boolean chokingOn = true;
        public boolean burnChestContents = true;
        public boolean toxicSmoke = true;
        public boolean dynamicFog = true;
        public double fireSpeed = 5.0;
        public double fireSpread = 6.0;
        public double playerDistance = 0.0;
        public double grassRecovery = 3.0;
        public double smokeCount = 0.0;
        public double burnSpeed = 50.0;
        public double burnSpread = 50.0;
        public double groundSpread = 50.0;
        public boolean soulFireOverworld = true;
        public double burning = 0.0;
        public boolean overworldOnly = true;
        public double chanceCollapse = 100.0;
        public boolean forestRecovery = false;
        public boolean distantSmoke = true;
        public boolean tarPits = true;
        public boolean hotSprings = true;
        public boolean geysers = true;
        public boolean volcanos = true;
        public boolean dripstoneCaveSulphur = false;
        public boolean lavaCatch = false;
        public boolean w2_available = false;
        public double w2_angle_deg = 0.0;
        public double w2_speed = 0.0;
        public boolean w2_precip = false;
        public double w2_precip_str = 0.0;
        public boolean sc_found = false;
        public double sc_tx = 0.0;
        public double sc_tz = 0.0;
        public double sc_nextLocate = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.burntOn = nbt.m_128471_("burntOn");
            this.biomeSpecific = nbt.m_128471_("biomeSpecific");
            this.rainExtinguish = nbt.m_128471_("rainExtinguish");
            this.collapseOn = nbt.m_128471_("collapseOn");
            this.flameParticles = nbt.m_128471_("flameParticles");
            this.ashParticles = nbt.m_128471_("ashParticles");
            this.burnDamage = nbt.m_128471_("burnDamage");
            this.smokeParticles = nbt.m_128471_("smokeParticles");
            this.sootOn = nbt.m_128471_("sootOn");
            this.vanillaCatch = nbt.m_128471_("vanillaCatch");
            this.craftedBlocksBurn = nbt.m_128471_("craftedBlocksBurn");
            this.fireDevil = nbt.m_128471_("fireDevil");
            this.wisp = nbt.m_128471_("wisp");
            this.woolBurns = nbt.m_128471_("woolBurns");
            this.flameBowOn = nbt.m_128471_("flameBowOn");
            this.fireAspectOn = nbt.m_128471_("fireAspectOn");
            this.structuresOn = nbt.m_128471_("structuresOn");
            this.lightningCatch = nbt.m_128471_("lightningCatch");
            this.smokeFogParticles = nbt.m_128471_("smokeFogParticles");
            this.chokingOn = nbt.m_128471_("chokingOn");
            this.burnChestContents = nbt.m_128471_("burnChestContents");
            this.toxicSmoke = nbt.m_128471_("toxicSmoke");
            this.dynamicFog = nbt.m_128471_("dynamicFog");
            this.fireSpeed = nbt.m_128459_("fireSpeed");
            this.fireSpread = nbt.m_128459_("fireSpread");
            this.playerDistance = nbt.m_128459_("playerDistance");
            this.grassRecovery = nbt.m_128459_("grassRecovery");
            this.smokeCount = nbt.m_128459_("smokeCount");
            this.burnSpeed = nbt.m_128459_("burnSpeed");
            this.burnSpread = nbt.m_128459_("burnSpread");
            this.groundSpread = nbt.m_128459_("groundSpread");
            this.soulFireOverworld = nbt.m_128471_("soulFireOverworld");
            this.burning = nbt.m_128459_("burning");
            this.overworldOnly = nbt.m_128471_("overworldOnly");
            this.chanceCollapse = nbt.m_128459_("chanceCollapse");
            this.forestRecovery = nbt.m_128471_("forestRecovery");
            this.distantSmoke = nbt.m_128471_("distantSmoke");
            this.tarPits = nbt.m_128471_("tarPits");
            this.hotSprings = nbt.m_128471_("hotSprings");
            this.geysers = nbt.m_128471_("geysers");
            this.volcanos = nbt.m_128471_("volcanos");
            this.dripstoneCaveSulphur = nbt.m_128471_("dripstoneCaveSulphur");
            this.lavaCatch = nbt.m_128471_("lavaCatch");
            this.w2_available = nbt.m_128471_("w2_available");
            this.w2_angle_deg = nbt.m_128459_("w2_angle_deg");
            this.w2_speed = nbt.m_128459_("w2_speed");
            this.w2_precip = nbt.m_128471_("w2_precip");
            this.w2_precip_str = nbt.m_128459_("w2_precip_str");
            this.sc_found = nbt.m_128471_("sc_found");
            this.sc_tx = nbt.m_128459_("sc_tx");
            this.sc_tz = nbt.m_128459_("sc_tz");
            this.sc_nextLocate = nbt.m_128459_("sc_nextLocate");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("burntOn", this.burntOn);
            nbt.m_128379_("biomeSpecific", this.biomeSpecific);
            nbt.m_128379_("rainExtinguish", this.rainExtinguish);
            nbt.m_128379_("collapseOn", this.collapseOn);
            nbt.m_128379_("flameParticles", this.flameParticles);
            nbt.m_128379_("ashParticles", this.ashParticles);
            nbt.m_128379_("burnDamage", this.burnDamage);
            nbt.m_128379_("smokeParticles", this.smokeParticles);
            nbt.m_128379_("sootOn", this.sootOn);
            nbt.m_128379_("vanillaCatch", this.vanillaCatch);
            nbt.m_128379_("craftedBlocksBurn", this.craftedBlocksBurn);
            nbt.m_128379_("fireDevil", this.fireDevil);
            nbt.m_128379_("wisp", this.wisp);
            nbt.m_128379_("woolBurns", this.woolBurns);
            nbt.m_128379_("flameBowOn", this.flameBowOn);
            nbt.m_128379_("fireAspectOn", this.fireAspectOn);
            nbt.m_128379_("structuresOn", this.structuresOn);
            nbt.m_128379_("lightningCatch", this.lightningCatch);
            nbt.m_128379_("smokeFogParticles", this.smokeFogParticles);
            nbt.m_128379_("chokingOn", this.chokingOn);
            nbt.m_128379_("burnChestContents", this.burnChestContents);
            nbt.m_128379_("toxicSmoke", this.toxicSmoke);
            nbt.m_128379_("dynamicFog", this.dynamicFog);
            nbt.m_128347_("fireSpeed", this.fireSpeed);
            nbt.m_128347_("fireSpread", this.fireSpread);
            nbt.m_128347_("playerDistance", this.playerDistance);
            nbt.m_128347_("grassRecovery", this.grassRecovery);
            nbt.m_128347_("smokeCount", this.smokeCount);
            nbt.m_128347_("burnSpeed", this.burnSpeed);
            nbt.m_128347_("burnSpread", this.burnSpread);
            nbt.m_128347_("groundSpread", this.groundSpread);
            nbt.m_128379_("soulFireOverworld", this.soulFireOverworld);
            nbt.m_128347_("burning", this.burning);
            nbt.m_128379_("overworldOnly", this.overworldOnly);
            nbt.m_128347_("chanceCollapse", this.chanceCollapse);
            nbt.m_128379_("forestRecovery", this.forestRecovery);
            nbt.m_128379_("distantSmoke", this.distantSmoke);
            nbt.m_128379_("tarPits", this.tarPits);
            nbt.m_128379_("hotSprings", this.hotSprings);
            nbt.m_128379_("geysers", this.geysers);
            nbt.m_128379_("volcanos", this.volcanos);
            nbt.m_128379_("dripstoneCaveSulphur", this.dripstoneCaveSulphur);
            nbt.m_128379_("lavaCatch", this.lavaCatch);
            nbt.m_128379_("w2_available", this.w2_available);
            nbt.m_128347_("w2_angle_deg", this.w2_angle_deg);
            nbt.m_128347_("w2_speed", this.w2_speed);
            nbt.m_128379_("w2_precip", this.w2_precip);
            nbt.m_128347_("w2_precip_str", this.w2_precip_str);
            nbt.m_128379_("sc_found", this.sc_found);
            nbt.m_128347_("sc_tx", this.sc_tx);
            nbt.m_128347_("sc_tz", this.sc_tz);
            nbt.m_128347_("sc_nextLocate", this.sc_nextLocate);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                BurntMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "burnt_worldvars";
        public double fogDistance = 51.0;
        public boolean plumeObjMade = false;
        public boolean flameObjMade = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.fogDistance = nbt.m_128459_("fogDistance");
            this.plumeObjMade = nbt.m_128471_("plumeObjMade");
            this.flameObjMade = nbt.m_128471_("flameObjMade");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("fogDistance", this.fogDistance);
            nbt.m_128379_("plumeObjMade", this.plumeObjMade);
            nbt.m_128379_("flameObjMade", this.flameObjMade);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                BurntMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.arrowFired = original.arrowFired;
            clone.extinguisherOn = original.extinguisherOn;
            clone.flintDrawn = original.flintDrawn;
            clone.playerSoul = original.playerSoul;
            clone.soulDrawn = original.soulDrawn;
            clone.blazeDrawn = original.blazeDrawn;
            clone.gasMaskOn = original.gasMaskOn;
            clone.facePlayer = original.facePlayer;
            clone.PlayerTickDelay = original.PlayerTickDelay;
            clone.fireProof = original.fireProof;
            clone.matchBurn = original.matchBurn;
            clone.smokeAir = original.smokeAir;
            clone.smokeExposure = original.smokeExposure;
            clone.smokeDamageTimer = original.smokeDamageTimer;
            clone.freshAirTicks = original.freshAirTicks;
            clone.dl_cool = original.dl_cool;
            clone.dl_pending_clear = original.dl_pending_clear;
            clone.dl_active = original.dl_active;
            clone.wasInSmoke = original.wasInSmoke;
            clone.ml_cool = original.ml_cool;
            clone.ml_pending_clear = original.ml_pending_clear;
            clone.ml_active = original.ml_active;
            clone.mol_cool = original.mol_cool;
            clone.mol_pending_clear = original.mol_pending_clear;
            clone.mol_active = original.mol_active;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    BurntMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    BurntMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                BurntMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

