/*
 * Decompiled with CFR 0.152.
 */
package com.adamcalculator.cheststofox;

import com.adamcalculator.cheststofox.ChestsToFox;
import com.adamcalculator.cheststofox.Config;
import com.adamcalculator.cheststofox.StateMachine;
import com.adamcalculator.cheststofox.container.ContainerManager;
import com.adamcalculator.cheststofox.container.stat.StatCollector;
import com.adamcalculator.cheststofox.util.Files;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public final class Command {
    private static long bufferClearTimer = 0L;

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ctf").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"export").then(ClientCommandManager.literal((String)"available").executes(Command::exportAvailable))).then(ClientCommandManager.literal((String)"all").executes(Command::exportAll)))).then(ClientCommandManager.literal((String)"auto_close_gui").executes(Command::toggleAutoCloseGuis))).then(ClientCommandManager.literal((String)"saving").executes(Command::toggleSaving))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"buffer").then(ClientCommandManager.literal((String)"clear").executes(Command::bufferClear))).then(ClientCommandManager.literal((String)"clear_once").executes(Command::bufferClearOnce)))).executes(Command::printState)));
    }

    private static int toggleAutoCloseGuis(CommandContext<FabricClientCommandSource> context) {
        if (Config.CONFIG.isAutoCloseGuis()) {
            Command.autoCloseGuiOff(context);
        } else {
            Command.autoCloseGuiOn(context);
        }
        return 0;
    }

    private static void autoCloseGuiOff(CommandContext<FabricClientCommandSource> context) {
        Config.CONFIG.setAutoClose(false);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cheststofox.command.ctf.auto_close_guis.disabled").method_27692(class_124.field_1061));
    }

    private static void autoCloseGuiOn(CommandContext<FabricClientCommandSource> context) {
        Config.CONFIG.setAutoClose(true);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cheststofox.command.ctf.auto_close_guis.enabled").method_27692(class_124.field_1060));
    }

    private static int bufferClearOnce(CommandContext<FabricClientCommandSource> context) {
        boolean bl = StateMachine.clearOnce = !StateMachine.clearOnce;
        if (StateMachine.clearOnce) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cheststofox.command.ctf.buffer.clearOnce.howto").method_27692(class_124.field_1065));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cheststofox.command.ctf.buffer.clearOnce.canceled").method_27692(class_124.field_1077));
        }
        return 1;
    }

    private static int bufferClear(CommandContext<FabricClientCommandSource> context) {
        long current = System.currentTimeMillis();
        if (current - bufferClearTimer > 2500L) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cheststofox.command.ctf.buffer.clear.double_call_notice").method_27692(class_124.field_1065));
            bufferClearTimer = current;
        } else {
            ContainerManager.clearAllMemory();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cheststofox.command.ctf.buffer.clear.success").method_27692(class_124.field_1060));
        }
        return 1;
    }

    private static int toggleSaving(CommandContext<FabricClientCommandSource> context) {
        if (Config.CONFIG.isSaving()) {
            Command.savingDisable(context);
        } else {
            Command.savingEnable(context);
        }
        return 1;
    }

    private static void savingEnable(CommandContext<FabricClientCommandSource> context) {
        Config.CONFIG.setSaving(true);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cheststofox.command.ctf.saving.enabled").method_27692(class_124.field_1060));
    }

    private static void savingDisable(CommandContext<FabricClientCommandSource> context) {
        Config.CONFIG.setSaving(false);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"cheststofox.command.ctf.saving.disabled").method_27692(class_124.field_1061));
    }

    private static int printState(CommandContext<FabricClientCommandSource> context) {
        class_5250 currBuff;
        String prefix;
        class_5250 saving = class_2561.method_43471((String)(Config.CONFIG.isSaving() ? "cheststofox.generic.boolean.enabled" : "cheststofox.generic.boolean.disabled"));
        class_5250 autoCloseGuis = class_2561.method_43471((String)(Config.CONFIG.isAutoCloseGuis() ? "cheststofox.generic.boolean.enabled" : "cheststofox.generic.boolean.disabled"));
        class_5250 miniStatText = class_2561.method_43473();
        if (ContainerManager.isNotEmpty()) {
            prefix = "\n ";
            currBuff = class_2561.method_43469((String)"cheststofox.command.ctf.printState.buffer.stat", (Object[])new Object[]{ContainerManager.getSavedPositions().length});
            HashMap<String, StatCollector.StatRow> miniStat = StatCollector.collectAvailable(ContainerManager.containersData);
            int i = 0;
            for (String id : miniStat.keySet()) {
                StatCollector.StatRow row = miniStat.get(id);
                class_5250 rowText = class_2561.method_43469((String)"cheststofox.command.ctf.printState.buffer.hover_mini_stat.row", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(row.getAmount())).method_27692(class_124.field_1062), class_2561.method_43470((String)row.getLocalized()).method_27692(class_124.field_1060), class_2561.method_43470((String)String.valueOf(row.getContainers().size())).method_27692(class_124.field_1076)});
                miniStatText.method_10852((class_2561)rowText);
                miniStatText.method_10852(class_2561.method_30163((String)"\n"));
                if (i++ <= 7) continue;
                break;
            }
        } else {
            prefix = " ";
            currBuff = class_2561.method_43471((String)"cheststofox.command.ctf.printState.buffer.empty");
        }
        currBuff.method_27695(new class_124[]{class_124.field_1062, class_124.field_1073}).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43469((String)"cheststofox.command.ctf.printState.buffer.hover_mini_stat", (Object[])new Object[]{miniStatText}))));
        class_5250 buffWithPref = class_2561.method_43470((String)prefix).method_10852((class_2561)currBuff);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"cheststofox.command.ctf.printState", (Object[])new Object[]{class_2561.method_43470((String)ChestsToFox.prettyVersion()).method_27692(class_124.field_1054), saving, autoCloseGuis, buffWithPref}));
        return 1;
    }

    private static int exportAll(CommandContext<FabricClientCommandSource> context) {
        String content = StatCollector.statToCsv(StatCollector.collectAll(ContainerManager.containersData));
        Command.genericExport(context, content);
        return 1;
    }

    private static int exportAvailable(CommandContext<FabricClientCommandSource> context) {
        String content = StatCollector.statToCsv(StatCollector.collectAvailable(ContainerManager.containersData));
        Command.genericExport(context, content);
        return 1;
    }

    private static void genericExport(CommandContext<FabricClientCommandSource> context, String exportedString) {
        String filename = ChestsToFox.getCurrentNameOfExportFile();
        File file = new File(ChestsToFox.getExportsDir(), filename);
        Files.writeFile(file, exportedString);
        class_5250 filetext = class_2561.method_43470((String)(Config.CONFIG.workdir.replace("%MINECRAFT%", ".minecraft") + "/" + file.getName())).method_27695(new class_124[]{class_124.field_1073, class_124.field_1056, class_124.field_1077}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10607(ChestsToFox.getExportsDir().getAbsolutePath())));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"cheststofox.command.ctf.export.success", (Object[])new Object[]{filetext}).method_27692(class_124.field_1060));
    }
}

