/*
 * Decompiled with CFR 0.152.
 */
package com.adamcalculator.cheststofox.container;

import com.adamcalculator.cheststofox.container.ContainerEntry;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_2338;

@Environment(value=EnvType.CLIENT)
public class ContainersData {
    @SerializedName(value="chests")
    private HashMap<String, ContainerEntry> containersList = new HashMap();
    private class_2338[] cachedSavedPositions = new class_2338[0];

    public void updateContainerAt(class_2338 pos, class_1263 inventory) {
        ContainerEntry chestEntry = this.getOrCreate(pos);
        chestEntry.overwriteFromInventory(inventory);
    }

    public boolean isExist(class_2338 pos) {
        String key = ContainersData.posToKey(pos);
        return this.containersList.containsKey(key);
    }

    public ContainerEntry getContainer(class_2338 basePos) {
        String key = ContainersData.posToKey(basePos);
        return this.containersList.get(key);
    }

    public ContainerEntry getContainer(String key) {
        return this.containersList.get(key);
    }

    public class_2338[] getSavedPositions() {
        return this.cachedSavedPositions;
    }

    private ContainerEntry getOrCreate(class_2338 pos) {
        String key = ContainersData.posToKey(pos);
        if (this.containersList.containsKey(key)) {
            return this.containersList.get(key);
        }
        ContainerEntry chestEntry = new ContainerEntry();
        this.containersList.put(key, chestEntry);
        this.recalculateCache();
        return chestEntry;
    }

    public void clearAllMemory() {
        this.containersList.clear();
        this.recalculateCache();
    }

    public void clearAt(class_2338 baseBlock) {
        this.containersList.remove(ContainersData.posToKey(baseBlock));
        this.recalculateCache();
    }

    protected void recalculateCache() {
        ArrayList<class_2338> l = new ArrayList<class_2338>();
        for (String s : this.containersList.keySet()) {
            String[] split = s.split(" ");
            class_2338 blockPos = new class_2338(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            l.add(blockPos);
        }
        this.cachedSavedPositions = l.toArray(new class_2338[0]);
    }

    public static String posToKey(class_2338 pos) {
        return pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260();
    }

    public boolean isEmpty() {
        return this.containersList.isEmpty();
    }
}

