/*
 * Decompiled with CFR 0.152.
 */
package com.adamcalculator.cheststofox.container.stat;

import com.adamcalculator.cheststofox.ChestsToFox;
import com.adamcalculator.cheststofox.container.ContainerEntry;
import com.adamcalculator.cheststofox.container.ContainersData;
import com.adamcalculator.cheststofox.util.Util;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class StatCollector {
    public static HashMap<String, StatRow> collectAvailable(ContainersData containersData) {
        HashMap stat = new HashMap();
        for (class_2338 chestPosition : containersData.getSavedPositions()) {
            ContainerEntry chest = containersData.getContainer(chestPosition);
            chest.iterate((slot, itemEntry) -> {
                String id = itemEntry.getId();
                int amount = itemEntry.getCount();
                StatRow row = (StatRow)stat.get(id);
                if (row == null) {
                    row = new StatRow(id);
                    row.setLocalized(itemEntry.getLocalized());
                    stat.put(id, row);
                }
                row.increaseAmount(amount, ContainersData.posToKey(chestPosition));
            });
        }
        return Util.sortHashmapByValues(stat, Comparator.comparingInt(o -> -o.amount));
    }

    public static HashMap<String, StatRow> collectAll(ContainersData containersData) {
        class_2960 airIdentifier = class_7923.field_41178.method_10221((Object)class_1802.field_8162);
        HashMap<String, StatRow> stat = new HashMap<String, StatRow>();
        for (class_2960 id : class_7923.field_41178.method_10235()) {
            if (id.equals((Object)airIdentifier)) continue;
            String strId = ChestsToFox.getItemId(id);
            StatRow row = new StatRow(strId);
            row.setLocalized(((class_1792)class_7923.field_41178.method_63535(id)).method_63680().method_10858(99));
            stat.put(strId, row);
        }
        for (class_2338 chestPosition : containersData.getSavedPositions()) {
            ContainerEntry chest = containersData.getContainer(chestPosition);
            chest.iterate((slot, itemEntry) -> {
                String id = itemEntry.getId();
                int amount = itemEntry.getCount();
                StatRow row = (StatRow)stat.get(id);
                row.increaseAmount(amount, ContainersData.posToKey(chestPosition));
            });
        }
        return Util.sortHashmapByKeys(stat, String::compareToIgnoreCase);
    }

    public static String statToCsv(HashMap<String, StatRow> stat) {
        StringBuilder sb = new StringBuilder("\"localized\",\"id\",\"amount\"\r\n");
        for (StatRow row : stat.values()) {
            String localized = row.localized.replace("\"", "\"\"");
            sb.append("\"");
            sb.append(localized);
            sb.append("\"");
            sb.append(",");
            sb.append("\"");
            sb.append(row.id);
            sb.append("\"");
            sb.append(",");
            sb.append("\"");
            sb.append(row.amount);
            sb.append("\"");
            sb.append("\r\n");
        }
        return sb.toString();
    }

    @Environment(value=EnvType.CLIENT)
    public static class StatRow {
        public String localized = "<noname>";
        String id;
        int amount;
        final Set<String> containers = new HashSet<String>();

        public StatRow(String id) {
            this.id = id;
        }

        public void setLocalized(String localized) {
            this.localized = localized;
        }

        public void increaseAmount(int offset, String chest) {
            this.amount += offset;
            this.containers.add(chest);
        }

        public Set<String> getContainers() {
            return this.containers;
        }

        public int getAmount() {
            return this.amount;
        }

        public String getId() {
            return this.id;
        }

        public String getLocalized() {
            return this.localized;
        }
    }
}

