package com.adamcalculator.cheststofox;

import com.adamcalculator.cheststofox.container.ContainerManager;
import com.adamcalculator.cheststofox.util.ContainerLinker;
import com.adamcalculator.cheststofox.util.Util;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.block.entity.*;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2611;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3719;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_488;
import net.minecraft.class_495;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Timer;
import java.util.TimerTask;

public class ChestsToFox implements ClientModInitializer {
	public static final int CHESTS_TO_FOX_VERSION_BUILD = 30;
	public static final String CHESTS_TO_FOX_VERSION_NAME = "1.3";


	public static final Logger LOGGER = LoggerFactory.getLogger("ChestsToFox");
	public static final ContainerLinker CONTAINER_LINKER = new ContainerLinker();


	@Override
	public void onInitializeClient() {
		LOGGER.info("Mod ChestsToFox initializing in client");
		Config.CONFIG = Config.loadFromFile();
		Config.CONFIG.version = 1;

		// block click event
		UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
			if (hitResult.method_17783() == class_239.class_240.field_1332) {
				return clickedToBlock(world, hitResult);
			}

			return class_1269.field_5811;
		});

		Command.register();
	}

	private class_1269 clickedToBlock(class_1937 world, class_3965 hitResult) {
		if (!Config.CONFIG.isSaving() && !StateMachine.clearOnce) return class_1269.field_5811;

		final class_2586 blockEntity = world.method_8321(hitResult.method_17777());
		class_2338 baseBlock = null;
		if (blockEntity instanceof class_2595 chestBlock) {
			baseBlock = Util.getBaseChestBlockPos(chestBlock);

		} else if (blockEntity instanceof class_3719 barrel) {
			baseBlock = barrel.method_11016();

		} else if (blockEntity instanceof class_2614 hopper) {
			baseBlock = hopper.method_11016();

		} else if (blockEntity instanceof class_2627 shulker) {
			baseBlock = shulker.method_11016();

		} else if (blockEntity instanceof class_2611) {
			CONTAINER_LINKER.skipOnce();
		}

		if (StateMachine.clearOnce) {
			if (baseBlock == null) {
				baseBlock = hitResult.method_17777();
			}
			if (ContainerManager.isContainerAtExists(baseBlock)) {
				ContainerManager.clearAt(baseBlock);
				class_310.method_1551().field_1724.method_43496(class_2561.method_43469("cheststofox.command.ctf.buffer.clearOnce.success", baseBlock.method_23854()).method_27692(class_124.field_1060));
			} else {
				class_310.method_1551().field_1724.method_43496(class_2561.method_43469("cheststofox.command.ctf.buffer.clearOnce.not_found", baseBlock.method_23854()).method_27692(class_124.field_1077));
			}
			StateMachine.clearOnce = false;
			return class_1269.field_5814;
		} else {
			if (baseBlock != null) {
				CONTAINER_LINKER.waitContainerDataForOpen(baseBlock);
			}
		}


		return class_1269.field_5811;
	}

	public static File getExportsDir() {
		return new File(Config.CONFIG.workdir.replace("%MINECRAFT%", class_310.method_1551().field_1697.getAbsolutePath()));
	}

	public static String getCurrentNameOfExportFile() {
		DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
		LocalDateTime now = LocalDateTime.now();
		return "export_" + dtf.format(now) + ".csv";
	}

	public static void setScreenInject(class_437 screen, CallbackInfo ci) {
		if (!Config.CONFIG.isSaving()) return;

		// when closing screen
		if (screen == null) {
			class_437 previously = class_310.method_1551().field_1755;
			if (CONTAINER_LINKER.isSkipOnceAndMakeDone()) {
				return;
			}

			if (previously instanceof class_476 genericContainerScreen) {
				processInventoryForPos(genericContainerScreen.field_2797.method_7629(), CONTAINER_LINKER.getAndDone());

			} else if (previously instanceof class_488 hopperScreen) {
				processInventoryForPos(hopperScreen.field_2797.field_7826, CONTAINER_LINKER.getAndDone());

			} else if (previously instanceof class_495 schulkerBoxScreen) {
				processInventoryForPos(schulkerBoxScreen.field_2797.field_7867, CONTAINER_LINKER.getAndDone());
			}
		} else {
			if (Config.CONFIG.autoCloseWhenSaving && !CONTAINER_LINKER.isSkipOnce()) {
				if (screen instanceof class_476 || screen instanceof class_488 || screen instanceof class_495) {
					Timer timer = new Timer();
					timer.schedule(new TimerTask() {
						@Override
						public void run() {
							// direct call causes glitches (Timer runs on non-render thread)
							class_310.method_1551().method_40000(screen::method_25419);
						}
					}, Config.CONFIG.autoCloseWhenSavingDelay);
				}
			}
		}
	}

	public static void processInventoryForPos(class_1263 inventory, class_2338 pos) {
		if (pos == null) {
			Debug.log("CONTAINER_LINKER currently not wait guis (server open custom gui or big network ping???)");
			return;
		}
		ContainerManager.updateContainerData(pos, inventory);
	}

	public static String prettyVersion() {
		return String.format("%s (v%s)", CHESTS_TO_FOX_VERSION_NAME, CHESTS_TO_FOX_VERSION_BUILD);
	}

	public static String getItemId(class_1799 stack) {
		return getItemId(stack.method_7909());
	}

	public static String getItemId(class_1792 item) {
		return getItemId(class_7923.field_41178.method_10221(item));
	}

	/**
	 * This method converts Identifiers of items to string ids
	 * If you want change/modify ids in sheets, you can make this here
	 */
	public static String getItemId(class_2960 identifier) {
		return identifier.method_12832(); // path = dirt (without 'namespace:' prefix); make toString() to minecraft:dirt
	}
}