package com.adamcalculator.cheststofox;

import com.adamcalculator.cheststofox.container.ContainerManager;
import com.adamcalculator.cheststofox.container.stat.StatCollector;
import com.adamcalculator.cheststofox.util.Files;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.text.*;
import java.io.File;
import java.util.HashMap;

public final class Command {
    private static long bufferClearTimer = 0;

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) ->
                dispatcher.register(ClientCommandManager.literal("ctf")
                .then(ClientCommandManager.literal("export")
                        .then(ClientCommandManager.literal("available")
                                .executes(Command::exportAvailable))

                        .then(ClientCommandManager.literal("all")
                                .executes(Command::exportAll)))

                .then(ClientCommandManager.literal("auto_close_gui")
                        .executes(Command::toggleAutoCloseGuis))

                .then(ClientCommandManager.literal("saving")
                        .executes(Command::toggleSaving))

                .then(ClientCommandManager.literal("buffer")
                        .then(ClientCommandManager.literal("clear")
                                .executes(Command::bufferClear))

                        .then(ClientCommandManager.literal("clear_once")
                                .executes(Command::bufferClearOnce)))

                .executes(Command::printState)));
    }



    private static int toggleAutoCloseGuis(CommandContext<FabricClientCommandSource> context) {
        if (Config.CONFIG.isAutoCloseGuis()) {
            autoCloseGuiOff(context);
        } else {
            autoCloseGuiOn(context);
        }
        return 0;
    }

    private static void autoCloseGuiOff(CommandContext<FabricClientCommandSource> context) {
        Config.CONFIG.setAutoClose(false);
        context.getSource().sendFeedback(class_2561.method_43471("cheststofox.command.ctf.auto_close_guis.disabled").method_27692(class_124.field_1061));
    }

    private static void autoCloseGuiOn(CommandContext<FabricClientCommandSource> context) {
        Config.CONFIG.setAutoClose(true);
        context.getSource().sendFeedback(class_2561.method_43471("cheststofox.command.ctf.auto_close_guis.enabled").method_27692(class_124.field_1060));
    }

    private static int bufferClearOnce(CommandContext<FabricClientCommandSource> context) {
        StateMachine.clearOnce = !StateMachine.clearOnce;
        if (StateMachine.clearOnce) {
            context.getSource().sendFeedback(class_2561.method_43471("cheststofox.command.ctf.buffer.clearOnce.howto").method_27692(class_124.field_1065));

        } else {
            context.getSource().sendFeedback(class_2561.method_43471("cheststofox.command.ctf.buffer.clearOnce.canceled").method_27692(class_124.field_1077));

        }
        return 1;
    }

    private static int bufferClear(CommandContext<FabricClientCommandSource> context) {
        long current = System.currentTimeMillis();
        if (current - bufferClearTimer > 2500) {
            context.getSource().sendFeedback(class_2561.method_43471("cheststofox.command.ctf.buffer.clear.double_call_notice").method_27692(class_124.field_1065));
            bufferClearTimer = current;
        } else {
            ContainerManager.clearAllMemory();
            context.getSource().sendFeedback(class_2561.method_43471("cheststofox.command.ctf.buffer.clear.success").method_27692(class_124.field_1060));
        }
        return 1;
    }

    private static int toggleSaving(CommandContext<FabricClientCommandSource> context) {
        if (Config.CONFIG.isSaving()) {
            savingDisable(context);
        } else {
            savingEnable(context);
        }
        return 1;
    }

    private static void savingEnable(CommandContext<FabricClientCommandSource> context) {
        Config.CONFIG.setSaving(true);
        context.getSource().sendFeedback(class_2561.method_43471("cheststofox.command.ctf.saving.enabled").method_27692(class_124.field_1060));
    }

    private static void savingDisable(CommandContext<FabricClientCommandSource> context) {
        Config.CONFIG.setSaving(false);
        context.getSource().sendFeedback(class_2561.method_43471("cheststofox.command.ctf.saving.disabled").method_27692(class_124.field_1061));
    }

    private static int printState(CommandContext<FabricClientCommandSource> context) {
        Object saving = class_2561.method_43471(Config.CONFIG.isSaving() ? "cheststofox.generic.boolean.enabled" : "cheststofox.generic.boolean.disabled");
        Object autoCloseGuis = class_2561.method_43471(Config.CONFIG.isAutoCloseGuis() ? "cheststofox.generic.boolean.enabled" : "cheststofox.generic.boolean.disabled");

        class_5250 currBuff;
        String prefix;
        final class_5250 miniStatText = class_2561.method_43473();
        if (ContainerManager.isNotEmpty()) {
            prefix = "\n ";
            currBuff = class_2561.method_43469("cheststofox.command.ctf.printState.buffer.stat", ContainerManager.getSavedPositions().length);
            final HashMap<String, StatCollector.StatRow> miniStat = StatCollector.collectAvailable(ContainerManager.containersData);
            int i = 0;
            for (String id : miniStat.keySet()) {
                StatCollector.StatRow row = miniStat.get(id);

                class_2561 rowText = class_2561.method_43469("cheststofox.command.ctf.printState.buffer.hover_mini_stat.row",
                        class_2561.method_43470(String.valueOf(row.getAmount())).method_27692(class_124.field_1062),
                        class_2561.method_43470(row.getLocalized()).method_27692(class_124.field_1060),
                        class_2561.method_43470(String.valueOf(row.getContainers().size())).method_27692(class_124.field_1076));
                miniStatText.method_10852(rowText);
                miniStatText.method_10852(class_2561.method_30163("\n"));

                if (i++ > 7) {
                    break;
                }
            }
        } else {
            prefix = " ";
            currBuff = class_2561.method_43471("cheststofox.command.ctf.printState.buffer.empty");
        }


        currBuff.method_27695(class_124.field_1062, class_124.field_1073)
                .method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43469("cheststofox.command.ctf.printState.buffer.hover_mini_stat", miniStatText))));

        class_5250 buffWithPref = class_2561.method_43470(prefix).method_10852(currBuff);
        context.getSource().sendFeedback(class_2561.method_43469("cheststofox.command.ctf.printState", class_2561.method_43470(ChestsToFox.prettyVersion()).method_27692(class_124.field_1054), saving, autoCloseGuis, buffWithPref));
        return 1;
    }

    private static int exportAll(CommandContext<FabricClientCommandSource> context) {
        final String content = StatCollector.statToCsv(StatCollector.collectAll(ContainerManager.containersData));
        genericExport(context, content);
        return 1;
    }

    private static int exportAvailable(CommandContext<FabricClientCommandSource> context) {
        final String content = StatCollector.statToCsv(StatCollector.collectAvailable(ContainerManager.containersData));
        genericExport(context, content);
        return 1;
    }

    private static void genericExport(CommandContext<FabricClientCommandSource> context, String exportedString) {
        final String filename = ChestsToFox.getCurrentNameOfExportFile();
        final File file = new File(ChestsToFox.getExportsDir(), filename);
        Files.writeFile(file, exportedString);
        class_2561 filetext = class_2561.method_43470(Config.CONFIG.workdir.replace("%MINECRAFT%", ".minecraft") + "/" + file.getName())
                .method_27695(class_124.field_1073, class_124.field_1056, class_124.field_1077)
                .method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11746, ChestsToFox.getExportsDir().getAbsolutePath())));

        context.getSource().sendFeedback(class_2561.method_43469("cheststofox.command.ctf.export.success", filetext).method_27692(class_124.field_1060));
    }
}
