package com.adamcalculator.cheststofox;

import com.adamcalculator.cheststofox.container.ContainerEntry;
import com.adamcalculator.cheststofox.container.ContainerManager;
import com.adamcalculator.cheststofox.util.Util;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2595;
import net.minecraft.class_2614;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_863;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class RenderInjecting {
    public static void renderChestBlockEntity(class_2595 chestBlock, class_4587 matrices, class_4597 vertexConsumers, CallbackInfo ci) {
        if (!StateMachine.isRenderCustomContainers()) return;

        try {
            if (Util.isAppendixChest(chestBlock)) return;
            class_2338 basePos = Util.getBaseChestBlockPos(chestBlock);
            if (ContainerManager.isContainerAtExists(basePos)) {
                ContainerEntry container = ContainerManager.getContainer(basePos);
                if (StateMachine.isRenderHighlightedContainer(basePos, container)) {
                    class_238 box = new class_238(1-0.95f, 1-0.95f-0.05, 1-0.95f, 0.95f, 0.95f-0.05, 0.95f);
                    if (Util.isDoubleChest(chestBlock)) {
                        class_2350 direction = chestBlock.method_11010().method_11654(class_2281.field_10768).method_10160();
                        final float widenerCoff = 1f;
                        if (direction == class_2350.field_11039) {
                            box = new class_238(box.field_1323 - widenerCoff, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324);
                        } else if (direction == class_2350.field_11043) {
                            box = new class_238(box.field_1323, box.field_1322, box.field_1321 - widenerCoff, box.field_1320, box.field_1325, box.field_1324);
                        } else if (direction == class_2350.field_11034) {
                            box = new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320 + widenerCoff, box.field_1325, box.field_1324);
                        } else if (direction == class_2350.field_11035) {
                            box = new class_238(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324 + widenerCoff);
                        }
                    }

                    float red = container.red();
                    float green = container.green();
                    float blue = container.blue();
                    class_863.method_23102(matrices, vertexConsumers, box, red, green, blue, 0.5f);
                }
            }
        } catch (Exception e) {
            ChestsToFox.LOGGER.error("container rendering error", e);
        }
    }

    public static void renderHopperBlockEntity(class_2614 hopperBlock, class_4587 matrices, class_4597 vertexConsumers, CallbackInfo ci) {
        renderCube(hopperBlock.method_11016(), 0.4f, matrices, vertexConsumers, ci);
    }

    public static void renderCube(class_2338 basePos, float alpha, class_4587 matrices, class_4597 vertexConsumers, CallbackInfo ci) {
        if (!StateMachine.isRenderCustomContainers()) return;
        try {
            if (ContainerManager.isContainerAtExists(basePos)) {
                ContainerEntry container = ContainerManager.getContainer(basePos);
                if (StateMachine.isRenderHighlightedContainer(basePos, container)) {
                    class_238 box = new class_238(0, 0, 0, 1, 1, 1).method_1014(0.01);

                    float red = container.red();
                    float green = container.green();
                    float blue = container.blue();
                    class_863.method_23102(matrices, vertexConsumers, box, red, green, blue, alpha);
                }
            }

        } catch (Exception e) {
            ChestsToFox.LOGGER.error("cube rendering error", e);
        }
    }
}
