package com.adamcalculator.cheststofox.container;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import net.minecraft.class_1263;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2480;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

// chests slot:item
public class ContainerEntry {
    @SerializedName("slots")
    private HashMap<Integer, ItemEntry> slots = new HashMap<>();

    public void overwriteFromInventory(class_1263 inventory) {
        slots.clear();

        for (int stack = 0; stack < inventory.method_5439(); stack++) {
            final class_1799 itemStack = inventory.method_5438(stack);
            final class_1792 item = itemStack.method_7909();

            if (itemStack.method_7960()) {
                continue;
            }

            if (item instanceof class_1747 blockItem) {
                final class_2248 block = blockItem.method_7711();
                if (block instanceof class_2480) {
                    overwriteFromShulkerBox(stack, itemStack);
                    // add here 'continue' for remove shulkerbox from lists
                }
            }
            slots.put(stack, ItemEntry.ofItemStack(itemStack));
        }
    }

    private void overwriteFromShulkerBox(int slotInSource, class_1799 shulkerItemStack) {
        class_9288 containerComponent = shulkerItemStack.method_57825(class_9334.field_49622, null);
        if (containerComponent == null) {
            return;
        }
        int slotInShulker = 0;
        for (class_1799 itemStack : containerComponent.method_59714()) {
            if (!itemStack.method_7960()) {
                slots.put(((slotInSource+10)  * 1000) + slotInShulker, ItemEntry.ofItemStack(itemStack));
            }
            slotInShulker++;
        }
    }

    public float blue() {
        return (float) Math.sin((double)System.currentTimeMillis() / 2300) / 2f + 0.5f;//Color.ofHSB((float) Math.sin((double)System.currentTimeMillis() / 6000) / 2f + 1f, (float) Math.sin((double)System.currentTimeMillis() / 2400) / 2f + 1f, (float) Math.sin((double)System.currentTimeMillis() / 840*2) / 2f + 1f).getBlue();
    }

    public float green() {
        return (float) Math.sin((double)System.currentTimeMillis() / 1000) / 2f + 0.5f;//Color.ofHSB((float) Math.sin((double)System.currentTimeMillis() / 2000) / 2f + 1f, (float) Math.cos((double)System.currentTimeMillis() / 800) / 2f + 1f, (float) Math.sin((double)System.currentTimeMillis() / 600) / 2f + 1f).getGreen();
    }

    public float red() {
        return (float) Math.sin((double)System.currentTimeMillis() / 1500) / 2f + 0.5f;//Color.ofHSB((float) Math.sin((double)System.currentTimeMillis() / 2000) / 2f + 1f, (float) Math.sin((double)System.currentTimeMillis() / 3000) / 2f + 1f, (float) Math.sin((double)System.currentTimeMillis() / 12000) / 2f + 1f).getRed();
    }

    @Override
    public String toString() {
        return "ChestEntry{" +
                "slots=" + slots +
                '}';
    }

    public void iterate(ChestEntryIterator iter) {
        for (Integer slot : slots.keySet()) {
            ItemEntry itemEntry = slots.get(slot);
            iter.iterate(slot, itemEntry);
        }
    }

    public interface ChestEntryIterator {
        void iterate(int slot, ItemEntry itemEntry);
    }
}
