package com.adamcalculator.cheststofox.container;

import com.adamcalculator.cheststofox.ChestsToFox;
import com.google.gson.GsonBuilder;
import net.minecraft.class_1263;
import net.minecraft.class_2338;

public class ContainerManager {
    public static final ContainersData containersData = new ContainersData();

    public static void updateContainerData(class_2338 pos, class_1263 inventory) {
        containersData.updateContainerAt(pos, inventory);
    }

    public static String export() {
        String s = new GsonBuilder().setPrettyPrinting().create().toJson(containersData, ContainersData.class);
        ChestsToFox.LOGGER.info(s);
        return s;
    }

    public static boolean isContainerAtExists(class_2338 pos) {
        return containersData.isExist(pos);
    }

    public static ContainerEntry getContainer(class_2338 basePos) {
        return containersData.getContainer(basePos);
    }

    public static ContainerEntry getContainer(String basePos) {
        return containersData.getContainer(basePos);
    }

    public static class_2338[] getSavedPositions() {
        return containersData.getSavedPositions();
    }

    public static boolean isNotEmpty() {
        return !containersData.isEmpty();
    }

    public static void clearAllMemory() {
        containersData.clearAllMemory();
    }

    public static void clearAt(class_2338 baseBlock) {
        containersData.clearAt(baseBlock);
    }
}
