package com.adamcalculator.cheststofox.container;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_2338;

public class ContainersData {
    // <position> <chestEntry object>
    @SerializedName("chests")
    private HashMap<String, ContainerEntry> containersList = new HashMap<>();
    private class_2338[] cachedSavedPositions = new class_2338[0];


    public void updateContainerAt(class_2338 pos, class_1263 inventory) {
        ContainerEntry chestEntry = getOrCreate(pos);
        chestEntry.overwriteFromInventory(inventory);
    }

    public boolean isExist(class_2338 pos) {
        String key = posToKey(pos);
        return containersList.containsKey(key);
    }

    public ContainerEntry getContainer(class_2338 basePos) {
        String key = posToKey(basePos);
        return containersList.get(key);
    }

    public ContainerEntry getContainer(String key) {
        return containersList.get(key);
    }

    public class_2338[] getSavedPositions() {
        return cachedSavedPositions;
    }

    private ContainerEntry getOrCreate(class_2338 pos) {
        String key = posToKey(pos);
        if (containersList.containsKey(key)) {
            return containersList.get(key);
        }

        ContainerEntry chestEntry = new ContainerEntry();
        containersList.put(key, chestEntry);
        recalculateCache();

        return chestEntry;
    }

    public void clearAllMemory() {
        containersList.clear();
        recalculateCache();
    }


    public void clearAt(class_2338 baseBlock) {
        containersList.remove(posToKey(baseBlock));
        recalculateCache();
    }

    protected void recalculateCache() {
        List<class_2338> l = new ArrayList<>();

        for (String s : containersList.keySet()) {
            String[] split = s.split(" ");
            class_2338 blockPos = new class_2338(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
            l.add(blockPos);
        }

        cachedSavedPositions = l.toArray(new class_2338[0]);
    }

    public static String posToKey(class_2338 pos) {
        return pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260();
    }

    public boolean isEmpty() {
        return containersList.isEmpty();
    }

}
