package com.adamcalculator.cheststofox.container;

import com.adamcalculator.cheststofox.ChestsToFox;
import com.google.gson.annotations.SerializedName;
import net.minecraft.class_1799;

public class ItemEntry {
    @SerializedName("id")
    private String id;
    @SerializedName("count")
    private int count;
    private String localized;

    public static ItemEntry ofItemStack(class_1799 stack) {
        ItemEntry itemEntry = new ItemEntry(ChestsToFox.getItemId(stack), stack.method_7947());
        itemEntry.localized = stack.method_7964().method_10858(99);
        return itemEntry;
    }

    public ItemEntry(String id, int count) {
        this.id = id;
        this.count = count;
    }

    public String getId() {
        return id;
    }

    public int getCount() {
        return count;
    }

    public String getLocalized() {
        return localized;
    }
}
