package com.adamcalculator.cheststofox.mixin.client;

import com.adamcalculator.cheststofox.RenderInjecting;
import com.adamcalculator.cheststofox.container.ContainerManager;
import net.minecraft.block.entity.*;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_3719;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_863;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_863.class)
public abstract class DebugRendererMixin {
    @Inject(at = @At("HEAD"), method = "render")
    private void render(class_4587 matrices, class_4597.class_4598 vertexConsumers, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        final class_310 client = class_310.method_1551();
        final class_3695 profiler = client.method_16011();

        profiler.method_15396("mixin:ChestsToFox-highlights");
        for (final class_2338 pos : ContainerManager.getSavedPositions()) {
            matrices.method_22903();
            matrices.method_22904((double)pos.method_10263() - cameraX, (double)pos.method_10264() - cameraY, (double)pos.method_10260() - cameraZ);

            final class_2586 blockEntity = client.field_1687 != null ? client.field_1687.method_8321(pos) : null;
            if (blockEntity instanceof class_2595 chestBlock) {
                RenderInjecting.renderChestBlockEntity(chestBlock, matrices, vertexConsumers, ci);

            } else if (blockEntity instanceof class_2614 hopperBlockEntity) {
                RenderInjecting.renderHopperBlockEntity(hopperBlockEntity, matrices, vertexConsumers, ci);

            } else if (blockEntity instanceof class_3719 barrelBlockEntity) {
                RenderInjecting.renderCube(barrelBlockEntity.method_11016(), 0.5f, matrices, vertexConsumers, ci);

            } else if (blockEntity instanceof class_2627 shulkerboxBlockEntity) {
                RenderInjecting.renderCube(shulkerboxBlockEntity.method_11016(), 0.3f, matrices, vertexConsumers, ci);
            } else {
                RenderInjecting.renderCube(pos, 0.2f, matrices, vertexConsumers, ci);
            }


            matrices.method_22909();
        }
        profiler.method_15407();
    }
}
