package com.adamcalculator.cheststofox.util;

import java.util.*;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;

public final class Util {
    private Util() {}

    // get right part of chest
    public static class_2338 getBaseChestBlockPos(class_2595 chestBlock) {
        return getBaseChestBlockPos(chestBlock, -1);
    }

    // get left part of chest
    public static class_2338 getAppendixChestBlockPos(class_2595 chestBlock) {
        return getBaseChestBlockPos(chestBlock, 1);
    }

    public static boolean isDoubleChest(class_2595 chestBlock) {
        class_2680 cachedState = chestBlock.method_11010();
        class_2745 chestType = cachedState.method_11654(class_2281.field_10770);
        return chestType != class_2745.field_12569;
    }

    public static boolean isAppendixChest(class_2595 chestBlock) {
        class_2680 cachedState = chestBlock.method_11010();
        class_2745 chestType = cachedState.method_11654(class_2281.field_10770);
        return chestType == class_2745.field_12574;
    }

    public static class_2338 getBaseChestBlockPos(class_2595 chestBlock, int offset) {
        class_2338 pos = chestBlock.method_11016();
        class_2680 cachedState = chestBlock.method_11010();
        class_2745 chestType = cachedState.method_11654(class_2281.field_10770);
        var facing = cachedState.method_11654(class_2281.field_10768);
        var direction = facing.method_10153();

        return switch (chestType) {
            case field_12571, field_12569 -> pos;
            case field_12574 -> switch (direction) {
                case field_11043 -> pos.method_10089(offset);
                case field_11034 -> pos.method_10077(offset);
                case field_11035 -> pos.method_10088(offset);
                case field_11039 -> pos.method_10076(offset);
                default -> throw new RuntimeException("Chest with unsupported direction: " + direction);
            };
        };

    }

    public static <K, V> LinkedHashMap<K, V> sortHashmapByValues(HashMap<K, V> map, Comparator<V> comparator) {
        LinkedHashMap<K, V> sortedMap = new LinkedHashMap<>();
        ArrayList<V> list = new ArrayList<>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            list.add(entry.getValue());
        }
        list.sort(comparator);
        for (V num : list) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (entry.getValue().equals(num)) {
                    sortedMap.put(entry.getKey(), num);
                }
            }
        }

        return sortedMap;
    }

    public static <K extends String, V> LinkedHashMap<K, V> sortHashmapByKeys(HashMap<K, V> map, Comparator<K> comparator) {
        ArrayList<K> sortedKeys = new ArrayList<>(map.keySet());

        sortedKeys.sort(comparator);

        LinkedHashMap<K, V> sortedMap = new LinkedHashMap<>();

        for (K sortedKey : sortedKeys) {
            sortedMap.put(sortedKey, map.get(sortedKey));
        }

        return sortedMap;
    }
}
