/*
 * Decompiled with CFR 0.152.
 */
package net.the_blue_shark.peculiar_creatures.entity.custom;

import com.mojang.datafixers.util.Pair;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.MobAnchorElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import eu.pb4.polymer.virtualentity.mixin.accessors.EntityAccessor;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2781;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_9280;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.the_blue_shark.peculiar_creatures.entity.ModEntities;
import net.the_blue_shark.peculiar_creatures.mixin.ZombieEntityAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fStack;
import org.joml.Quaternionfc;
import xyz.nucleoid.packettweaker.PacketContext;

public class SmurfCatEntity
extends class_1429
implements PolymerEntity {
    private static final UUID SIZE_MODIFIER_UUID = UUID.fromString("6f7d6b0c-dc69-4c3e-a2c4-8b2d2d2e2b2b");
    private final ElementHolder holder;
    private final EntityAttachment attachment;
    private final ItemDisplayElement head = new ItemDisplayElement(this.createModelItem("smurf_cat_head"));
    private final ItemDisplayElement chest = new ItemDisplayElement(this.createModelItem("smurf_cat_chest"));
    private final ItemDisplayElement rightLeg = new ItemDisplayElement(this.createModelItem("smurf_cat_leg_right"));
    private final ItemDisplayElement leftLeg = new ItemDisplayElement(this.createModelItem("smurf_cat_leg_left"));
    private final ItemDisplayElement rightArm = new ItemDisplayElement(this.createModelItem("smurf_cat_arm_right"));
    private final ItemDisplayElement leftArm = new ItemDisplayElement(this.createModelItem("smurf_cat_arm_left"));
    private final InteractionElement interaction = InteractionElement.redirect((class_1297)this);
    private final MobAnchorElement rideAnchor = new MobAnchorElement();
    private Matrix4x3fStack stack = new Matrix4x3fStack(8);
    private float previousSpeed = Float.MIN_NORMAL;
    private float previousLimbPos = Float.MIN_NORMAL;
    private float deathAngle;

    public SmurfCatEntity(class_1299<SmurfCatEntity> entityEntityType, class_1937 world) {
        super(entityEntityType, world);
        this.holder = new ElementHolder(){

            protected void notifyElementsOfPositionUpdate(class_243 newPos, class_243 delta) {
                SmurfCatEntity.this.rideAnchor.notifyMove(this.currentPos, newPos, delta);
            }

            public boolean startWatching(class_3244 handler) {
                class_3222 player = handler.field_14140;
                if (PolymerResourcePackUtils.hasMainPack((class_3222)player)) {
                    return super.startWatching(handler);
                }
                return false;
            }

            public class_243 getPos() {
                return this.getAttachment().getPos();
            }
        };
        this.leftLeg.setInterpolationDuration(2);
        this.leftLeg.ignorePositionUpdates();
        this.rightLeg.setInterpolationDuration(2);
        this.rightLeg.ignorePositionUpdates();
        this.leftArm.setInterpolationDuration(2);
        this.leftArm.ignorePositionUpdates();
        this.rightArm.setInterpolationDuration(2);
        this.rightArm.ignorePositionUpdates();
        this.chest.setInterpolationDuration(2);
        this.chest.ignorePositionUpdates();
        this.head.setInterpolationDuration(2);
        this.head.ignorePositionUpdates();
        this.leftLeg.setItemDisplayContext(class_811.field_4319);
        this.rightLeg.setItemDisplayContext(class_811.field_4319);
        this.leftArm.setItemDisplayContext(class_811.field_4319);
        this.rightArm.setItemDisplayContext(class_811.field_4319);
        this.chest.setItemDisplayContext(class_811.field_4319);
        this.head.setItemDisplayContext(class_811.field_4319);
        this.interaction.setSize(0.3f, 0.6f);
        this.interaction.ignorePositionUpdates();
        this.rideAnchor.ignorePositionUpdates();
        this.updateAnimation();
        this.holder.addPassengerElement((VirtualElement)this.interaction);
        this.holder.addPassengerElement((VirtualElement)this.leftLeg);
        this.holder.addPassengerElement((VirtualElement)this.rightLeg);
        this.holder.addPassengerElement((VirtualElement)this.leftArm);
        this.holder.addPassengerElement((VirtualElement)this.rightArm);
        this.holder.addPassengerElement((VirtualElement)this.chest);
        this.holder.addPassengerElement((VirtualElement)this.head);
        this.holder.addElement((VirtualElement)this.rideAnchor);
        this.attachment = new EntityAttachment(this.holder, (class_1297)this, false);
    }

    private void updateAnimation() {
        float speed = this.field_42108.method_48566();
        float limbPos = this.field_42108.method_48569();
        float f = (float)this.field_6213 / 20.0f * 1.6f;
        if ((f = class_3532.method_15355((float)f)) > 1.0f) {
            f = 1.0f;
        }
        if (this.deathAngle == f && speed == this.previousSpeed && limbPos == this.previousLimbPos) {
            return;
        }
        this.interaction.setOnFire(this.method_5809());
        this.deathAngle = f;
        this.previousSpeed = speed;
        this.previousLimbPos = limbPos;
        this.leftLeg.startInterpolation();
        this.rightLeg.startInterpolation();
        this.leftArm.startInterpolation();
        this.rightArm.startInterpolation();
        this.chest.startInterpolation();
        this.head.startInterpolation();
        this.stack.clear();
        this.stack.rotateY((float)Math.toRadians(-class_3532.method_17821((float)0.5f, (float)this.field_5982, (float)this.method_36454())) + (float)((double)1.0E-5f * Math.random()));
        if (this.field_6213 > 0) {
            this.stack.rotate((Quaternionfc)class_7833.field_40718.rotation(f * 1.5707964f));
        }
        this.stack.pushMatrix();
        this.stack.translate(0.0f, 0.5625f, 0.0f);
        this.stack.rotateY((float)Math.toRadians(this.method_5791() - this.method_36454()));
        this.stack.rotateX((float)Math.toRadians(this.method_36455()));
        this.head.setTransformation((Matrix4x3f)this.stack);
        this.stack.popMatrix();
        this.stack.pushMatrix();
        this.stack.translate(0.0f, 0.6875f, 0.0f);
        this.chest.setTransformation((Matrix4x3f)this.stack);
        this.stack.popMatrix();
        this.stack.pushMatrix();
        this.stack.translate(0.0390625f, 0.5f, 0.03125f).rotateX(class_3532.method_15362((float)(limbPos * 0.6662f)) * 0.7f * speed);
        this.leftLeg.setTransformation((Matrix4x3f)this.stack);
        this.stack.popMatrix();
        this.stack.pushMatrix();
        this.stack.translate(-0.0390625f, 0.5f, 0.03125f).rotateX(class_3532.method_15362((float)(limbPos * 0.6662f + (float)Math.PI)) * 0.7f * speed);
        this.rightLeg.setTransformation((Matrix4x3f)this.stack);
        this.stack.popMatrix();
        this.stack.pushMatrix();
        this.stack.translate(0.171875f, 0.1875f, 0.0f).rotateX(class_3532.method_15362((float)(limbPos * 0.6662f)) * 0.7f * speed);
        this.leftArm.setTransformation((Matrix4x3f)this.stack);
        this.stack.popMatrix();
        this.stack.pushMatrix();
        this.stack.translate(-0.171875f, 0.1875f, 0.0f).rotateX(class_3532.method_15362((float)(limbPos * 0.6662f + (float)Math.PI)) * 0.7f * speed);
        this.rightArm.setTransformation((Matrix4x3f)this.stack);
        this.stack.popMatrix();
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.4));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 1.0, stack -> stack.method_31574(class_1802.field_16998), true));
        this.field_6201.method_6277(3, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.35).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_52450, 12.0);
    }

    public void method_5773() {
        super.method_5773();
        this.method_29242(false);
        this.updateAnimation();
        this.holder.tick();
    }

    @Nullable
    protected class_3414 method_5994() {
        return class_3417.field_15051;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14867;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_14971;
    }

    protected void method_5958(class_3218 world) {
        super.method_5958(world);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8542);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntities.SMURF_CAT.method_5883((class_1937)world, class_3730.field_16466);
    }

    public class_1299<?> getPolymerEntityType(PacketContext packetContext) {
        if (PolymerResourcePackUtils.hasMainPack((class_3222)packetContext.getPlayer())) {
            return class_1299.field_6131;
        }
        return class_1299.field_6051;
    }

    public void modifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial) {
        if (PolymerResourcePackUtils.hasMainPack((class_3222)player)) {
            data.add(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.FLAGS, (Object)((byte)(1 << EntityTrackedData.INVISIBLE_FLAG_INDEX))));
            data.add(class_2945.class_7834.method_46360((class_2940)class_1531.field_7107, (Object)17));
            data.add(new class_2945.class_7834(EntityAccessor.getNO_GRAVITY().comp_2327(), EntityAccessor.getNO_GRAVITY().comp_2328(), (Object)true));
        } else {
            data.add(class_2945.class_7834.method_46360(ZombieEntityAccessor.getBabyFlag(), (Object)true));
        }
    }

    public List<Pair<class_1304, class_1799>> getPolymerVisibleEquipment(List<Pair<class_1304, class_1799>> items, class_3222 player) {
        if (!PolymerResourcePackUtils.hasMainPack((class_3222)player)) {
            class_1799 head = PolymerUtils.createPlayerHead((String)"e3RleHR1cmVzOntTS0lOOnt1cmw6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTM2Y2E0ZTA5YmJmYzVhMjFhMGNhZWIzZTUzYjIwMWE4YWJlNWUxNTk3ZjA3MTg0NGUzNjgwMmQ2MGQ0Y2M2OCJ9fX0=");
            class_1799 chest = new class_1799((class_1935)class_1802.field_8577);
            chest.method_57379(class_9334.field_49644, (Object)new class_9282(3847130));
            class_1799 leggings = new class_1799((class_1935)class_1802.field_8570);
            leggings.method_57379(class_9334.field_49644, (Object)new class_9282(0xFFFFFF));
            class_1799 boots = new class_1799((class_1935)class_1802.field_8370);
            boots.method_57379(class_9334.field_49644, (Object)new class_9282(0xFFFFFF));
            return List.of(new Pair((Object)class_1304.field_6169, (Object)head), new Pair((Object)class_1304.field_6174, (Object)chest), new Pair((Object)class_1304.field_6172, (Object)leggings), new Pair((Object)class_1304.field_6166, (Object)boots));
        }
        return List.of();
    }

    public void modifyRawEntityAttributeData(List<class_2781.class_2782> data, class_3222 player, boolean initial) {
        if (!PolymerResourcePackUtils.hasMainPack((class_3222)player)) {
            data.add(new class_2781.class_2782(class_5134.field_47760, 0.6, List.of()));
        }
    }

    private class_1799 createModelItem(String modelKey) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8446);
        List<String> keys = List.of(modelKey);
        class_9280 cmd = new class_9280(List.of(), List.of(), keys, List.of());
        stack.method_57379(class_9334.field_49637, (Object)cmd);
        return stack;
    }
}

