/*
 * Decompiled with CFR 0.152.
 */
package com.caspicof.simpleelevators;

import java.io.File;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class ElevatorListener
implements Listener {
    private final JavaPlugin plugin;
    private FileConfiguration messagesConfig;

    public ElevatorListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    private void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    @EventHandler
    public void onSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (!event.isSneaking()) {
            return;
        }
        Location location = player.getLocation().clone();
        if (location.getBlock().getType() != Material.DAYLIGHT_DETECTOR) {
            return;
        }
        Location targetLocation = this.findPairedDetector(location);
        if (targetLocation == null) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messagesConfig.getString("no_detector_found")));
            return;
        }
        Location teleportLocation = targetLocation.clone();
        teleportLocation.setX((double)teleportLocation.getBlockX() + 0.5);
        teleportLocation.setZ((double)teleportLocation.getBlockZ() + 0.5);
        teleportLocation.setY((double)(teleportLocation.getBlockY() + 1));
        player.teleport(teleportLocation);
        String soundName = this.plugin.getConfig().getString("teleport_sound");
        Sound sound = soundName != null ? Sound.valueOf((String)soundName) : Sound.ENTITY_ENDERMAN_TELEPORT;
        player.playSound(location, sound, 1.0f, 1.0f);
        String particleName = this.plugin.getConfig().getString("teleport_particle");
        Particle particle = particleName != null ? Particle.valueOf((String)particleName) : Particle.PORTAL;
        player.spawnParticle(particle, location, 50, 0.5, 1.0, 0.5, 0.1);
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messagesConfig.getString("teleport_success")));
    }

    private Location findPairedDetector(Location start) {
        Location loc;
        int y;
        int maxDistance = this.plugin.getConfig().getInt("max_search_distance");
        World world = start.getWorld();
        for (y = start.getBlockY() + 1; y <= start.getBlockY() + maxDistance; ++y) {
            loc = new Location(world, start.getX(), (double)y, start.getZ());
            if (loc.getBlock().getType() != Material.DAYLIGHT_DETECTOR) continue;
            return loc;
        }
        for (y = start.getBlockY() - 1; y >= start.getBlockY() - maxDistance; --y) {
            loc = new Location(world, start.getX(), (double)y, start.getZ());
            if (loc.getBlock().getType() != Material.DAYLIGHT_DETECTOR) continue;
            return loc;
        }
        return null;
    }
}

