/*
 * Decompiled with CFR 0.152.
 */
package dev.locations;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.locations.Location;
import dev.locations.LocationsState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public final class LocationsMod
implements ModInitializer {
    public static final String MOD_ID = "locations";
    private final Map<UUID, String> lastInside = new HashMap<UUID, String>();
    private static final Map<String, Integer> COLOR_PRESETS = new LinkedHashMap<String, Integer>();
    private static final List<String> COLOR_NAMES;

    private static int presetColorOrError(String name) {
        Integer rgb = COLOR_PRESETS.get(name.toLowerCase(Locale.ROOT));
        return rgb == null ? -2 : rgb;
    }

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register(this::registerCommands);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> LocationsState.get(server).load());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> LocationsState.get(server).save());
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            class_2960 dimId;
            MinecraftServer server = world.method_8503();
            LocationsState state = LocationsState.get(server);
            List<Location> locs = state.getLocations(dimId = world.method_27983().method_29177());
            if (locs.isEmpty()) {
                return;
            }
            for (class_3222 p : world.method_18456()) {
                int rgb;
                boolean justEntered;
                class_2338 bp = p.method_24515();
                Location current = LocationsMod.findBestMatch(locs, bp);
                String key = current == null ? null : current.name;
                String prev = this.lastInside.put(p.method_5667(), key);
                boolean bl = justEntered = !Objects.equals(prev, key) && key != null;
                if (current == null || !justEntered) continue;
                int n = rgb = current.colorRgb != -1 ? current.colorRgb : 0xFFFFFF;
                if (current.fancy) {
                    class_5250 title = class_2561.method_43470((String)current.name).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)rgb)));
                    StringBuilder sb = new StringBuilder();
                    int n2 = Math.max(8, current.name.length() * 2);
                    for (int i = 0; i < n2; ++i) {
                        sb.append('\u00af');
                    }
                    class_5250 subtitle = class_2561.method_43470((String)sb.toString());
                    try {
                        p.field_13987.method_14364((class_2596)new class_5905(10, 70, 20));
                        p.field_13987.method_14364((class_2596)new class_5904((class_2561)title));
                        p.field_13987.method_14364((class_2596)new class_5903((class_2561)subtitle));
                        p.field_13987.method_14364((class_2596)new class_2767((class_6880)class_3417.field_23792, class_3419.field_15256, p.method_23317(), p.method_23318(), p.method_23321(), 1.0f, 1.0f, p.method_59922().method_43055()));
                    }
                    catch (Throwable t) {
                        class_5250 msg = class_2561.method_43470((String)"Now Entering ").method_10852((class_2561)class_2561.method_43470((String)current.name).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)rgb))));
                        p.method_7353((class_2561)msg, true);
                    }
                    continue;
                }
                class_5250 msg = class_2561.method_43470((String)"Now Entering ").method_10852((class_2561)class_2561.method_43470((String)current.name).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)rgb))));
                p.method_7353((class_2561)msg, true);
            }
        });
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 env) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"location").requires(src -> true)).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 p = src.method_44023();
            if (p == null) {
                return 0;
            }
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            int r = Math.min(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), 100);
            class_2960 dim = src.method_9225().method_27983().method_29177();
            class_2338 pos = p.method_24515();
            LocationsState state = LocationsState.get(src.method_9211());
            if (state.find(dim, name) != null) {
                src.method_9213((class_2561)class_2561.method_43470((String)("Location already exists: " + name)));
                return 0;
            }
            state.add(dim, new Location(name, pos, r, -1, Location.Shape.CIRCLE));
            src.method_9226(() -> class_2561.method_43470((String)("Created location '" + name + "' shape=circle @ " + pos.method_23854() + " r=" + r)), true);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> class_2172.method_9265(List.of("circle", "square"), (SuggestionsBuilder)b)).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Usage: /location create <name> <radius> <circle|square> <color>"));
            return 0;
        })).then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> class_2172.method_9265(COLOR_NAMES, (SuggestionsBuilder)b)).executes(ctx -> {
            Location.Shape shape;
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 p = src.method_44023();
            if (p == null) {
                return 0;
            }
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            int r = Math.min(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), 100);
            String shapeStr = StringArgumentType.getString((CommandContext)ctx, (String)"shape");
            if ("circle".equalsIgnoreCase(shapeStr)) {
                shape = Location.Shape.CIRCLE;
            } else if ("square".equalsIgnoreCase(shapeStr)) {
                shape = Location.Shape.SQUARE;
            } else {
                src.method_9213((class_2561)class_2561.method_43470((String)"Shape must be 'circle' or 'square'."));
                return 0;
            }
            String colorStr = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            int rgb = LocationsMod.presetColorOrError(colorStr);
            if (rgb == -2) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Unknown color name. Use tab to see options."));
                return 0;
            }
            class_2960 dim = src.method_9225().method_27983().method_29177();
            class_2338 pos = p.method_24515();
            LocationsState state = LocationsState.get(src.method_9211());
            if (state.find(dim, name) != null) {
                src.method_9213((class_2561)class_2561.method_43470((String)("Location already exists: " + name)));
                return 0;
            }
            state.add(dim, new Location(name, pos, r, rgb, shape));
            src.method_9226(() -> class_2561.method_43470((String)("Created location '" + name + "' shape=" + shapeStr.toLowerCase(Locale.ROOT) + " color=" + colorStr.toLowerCase(Locale.ROOT) + " @ " + pos.method_23854() + " r=" + r)), true);
            return 1;
        }))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 p = src.method_44023();
            if (p == null) {
                return 0;
            }
            class_2960 dim = src.method_9225().method_27983().method_29177();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            LocationsState state = LocationsState.get(src.method_9211());
            if (state.remove(dim, name)) {
                src.method_9226(() -> class_2561.method_43470((String)("Removed location '" + name + "'")), true);
                return 1;
            }
            src.method_9213((class_2561)class_2561.method_43470((String)("No such location: " + name)));
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"edit").then(class_2170.method_9247((String)"name").then(class_2170.method_9244((String)"newName", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            class_2338 pos;
            class_2960 dim;
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 p = src.method_44023();
            if (p == null) {
                return 0;
            }
            LocationsState state = LocationsState.get(src.method_9211());
            Location loc = LocationsMod.tryFindLocAt(state, dim = src.method_9225().method_27983().method_29177(), pos = p.method_24515());
            if (loc == null) {
                src.method_9213((class_2561)class_2561.method_43470((String)"You\u2019re not standing inside a location."));
                return 0;
            }
            String newName = StringArgumentType.getString((CommandContext)ctx, (String)"newName").trim();
            if (newName.isEmpty()) {
                src.method_9213((class_2561)class_2561.method_43470((String)"New name cannot be empty."));
                return 0;
            }
            if (!newName.equalsIgnoreCase(loc.name) && state.find(dim, newName) != null) {
                src.method_9213((class_2561)class_2561.method_43470((String)"A location with that name already exists here."));
                return 0;
            }
            Location updated = new Location(newName, loc.center, loc.radius, loc.colorRgb, loc.shape);
            state.remove(dim, loc.name);
            state.add(dim, updated);
            state.save();
            src.method_9226(() -> class_2561.method_43470((String)("Renamed location to '" + newName + "'.")), true);
            return 1;
        })))).then(class_2170.method_9247((String)"color").then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9265(COLOR_NAMES, (SuggestionsBuilder)b)).executes(ctx -> {
            class_2338 pos;
            class_2960 dim;
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 p = src.method_44023();
            if (p == null) {
                return 0;
            }
            LocationsState state = LocationsState.get(src.method_9211());
            Location loc = LocationsMod.tryFindLocAt(state, dim = src.method_9225().method_27983().method_29177(), pos = p.method_24515());
            if (loc == null) {
                src.method_9213((class_2561)class_2561.method_43470((String)"You\u2019re not standing inside a location."));
                return 0;
            }
            String colorStr = StringArgumentType.getString((CommandContext)ctx, (String)"color");
            int rgb = LocationsMod.presetColorOrError(colorStr);
            if (rgb == -2) {
                src.method_9213((class_2561)class_2561.method_43470((String)"Unknown color. Use tab to see options."));
                return 0;
            }
            Location updated = new Location(loc.name, loc.center, loc.radius, rgb, loc.shape);
            state.remove(dim, loc.name);
            state.add(dim, updated);
            state.save();
            src.method_9226(() -> class_2561.method_43470((String)("Updated color to " + colorStr.toLowerCase(Locale.ROOT) + ".")), true);
            return 1;
        }))))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 p = src.method_44023();
            if (p == null) {
                return 0;
            }
            class_2960 dim = src.method_9225().method_27983().method_29177();
            LocationsState state = LocationsState.get(src.method_9211());
            List<Location> locs = state.getLocations(dim);
            if (locs.isEmpty()) {
                src.method_9226(() -> class_2561.method_43470((String)"No locations in this dimension."), false);
            } else {
                src.method_9226(() -> class_2561.method_43470((String)"Locations:"), false);
                for (Location l : locs) {
                    String extra = l.colorRgb != -1 ? " color=#" + String.format("%06X", l.colorRgb) : "";
                    src.method_9226(() -> class_2561.method_43470((String)(" \u2022 " + l.name + " @ " + l.center.method_23854() + " r=" + l.radius + " shape=" + l.shape.name().toLowerCase(Locale.ROOT) + extra)), false);
                }
            }
            return 1;
        }))).then(class_2170.method_9247((String)"fancy").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            class_2338 pos;
            class_2960 dim;
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 p = src.method_44023();
            if (p == null) {
                return 0;
            }
            LocationsState state = LocationsState.get(src.method_9211());
            Location loc = LocationsMod.tryFindLocAt(state, dim = src.method_9225().method_27983().method_29177(), pos = p.method_24515());
            if (loc == null) {
                src.method_9213((class_2561)class_2561.method_43470((String)"You\u2019re not standing inside a location."));
                return 0;
            }
            boolean value = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
            Location updated = new Location(loc.name, loc.center, loc.radius, loc.colorRgb, loc.shape, value);
            state.remove(dim, loc.name);
            state.add(dim, updated);
            state.save();
            src.method_9226(() -> class_2561.method_43470((String)("Set fancy=" + value + " for '" + loc.name + "'.")), true);
            return 1;
        }))));
    }

    private static Location findBestMatch(List<Location> locs, class_2338 bp) {
        Location best = null;
        long bestKey = Long.MAX_VALUE;
        for (Location loc : locs) {
            long key;
            boolean inside;
            long dx = bp.method_10263() - loc.center.method_10263();
            long dz = bp.method_10260() - loc.center.method_10260();
            if (loc.shape == Location.Shape.CIRCLE) {
                long d2 = dx * dx + dz * dz;
                long r2 = (long)loc.radius * (long)loc.radius;
                inside = d2 <= r2;
                key = d2;
            } else {
                long adx = Math.abs(dx);
                long adz = Math.abs(dz);
                inside = adx <= (long)loc.radius && adz <= (long)loc.radius;
                key = Math.max(adx, adz);
            }
            if (!inside || key >= bestKey) continue;
            bestKey = key;
            best = loc;
        }
        return best;
    }

    private static Location tryFindLocAt(LocationsState state, class_2960 dim, class_2338 pos) {
        for (Location l : state.getLocations(dim)) {
            if (!LocationsMod.contains(l, pos)) continue;
            return l;
        }
        return null;
    }

    private static boolean contains(Location l, class_2338 p) {
        int dx = p.method_10263() - l.center.method_10263();
        int dz = p.method_10260() - l.center.method_10260();
        int r = l.radius;
        if (l.shape == Location.Shape.SQUARE) {
            return Math.abs(dx) <= r && Math.abs(dz) <= r;
        }
        long d2 = (long)dx * (long)dx + (long)dz * (long)dz;
        long r2 = (long)r * (long)r;
        return d2 <= r2;
    }

    static {
        COLOR_PRESETS.put("black", 0);
        COLOR_PRESETS.put("dark_gray", 0x555555);
        COLOR_PRESETS.put("gray", 0xAAAAAA);
        COLOR_PRESETS.put("light_gray", 0xD3D3D3);
        COLOR_PRESETS.put("white", 0xFFFFFF);
        COLOR_PRESETS.put("red", 0xFF5555);
        COLOR_PRESETS.put("dark_red", 0xAA0000);
        COLOR_PRESETS.put("crimson", 14423100);
        COLOR_PRESETS.put("rose", 0xFF007F);
        COLOR_PRESETS.put("salmon", 16416882);
        COLOR_PRESETS.put("hot_pink", 16738740);
        COLOR_PRESETS.put("magenta", 0xFF00FF);
        COLOR_PRESETS.put("pink", 16761035);
        COLOR_PRESETS.put("orange", 16753920);
        COLOR_PRESETS.put("gold", 0xFFAA00);
        COLOR_PRESETS.put("amber", 0xFFBF00);
        COLOR_PRESETS.put("peach", 16767673);
        COLOR_PRESETS.put("coral", 16744272);
        COLOR_PRESETS.put("yellow", 0xFFFF55);
        COLOR_PRESETS.put("lemon", 0xFFF44F);
        COLOR_PRESETS.put("sand", 12759680);
        COLOR_PRESETS.put("beige", 16119260);
        COLOR_PRESETS.put("lime", 0x55FF55);
        COLOR_PRESETS.put("green", 0x55AA55);
        COLOR_PRESETS.put("dark_green", 43520);
        COLOR_PRESETS.put("forest", 0x228B22);
        COLOR_PRESETS.put("olive", 0x808000);
        COLOR_PRESETS.put("chartreuse", 0x7FFF00);
        COLOR_PRESETS.put("spring_green", 65407);
        COLOR_PRESETS.put("mint", 0x98FF98);
        COLOR_PRESETS.put("teal", 32896);
        COLOR_PRESETS.put("turquoise", 4251856);
        COLOR_PRESETS.put("aqua", 0x55FFFF);
        COLOR_PRESETS.put("cyan", 65535);
        COLOR_PRESETS.put("sky", 8900331);
        COLOR_PRESETS.put("blue", 0x5555FF);
        COLOR_PRESETS.put("dark_blue", 170);
        COLOR_PRESETS.put("navy", 128);
        COLOR_PRESETS.put("indigo", 4915330);
        COLOR_PRESETS.put("purple", 0x800080);
        COLOR_PRESETS.put("violet", 0xEE82EE);
        COLOR_PRESETS.put("light_purple", 0xFF55FF);
        COLOR_PRESETS.put("brown", 9127187);
        COLOR_PRESETS.put("dark_brown", 6045747);
        COLOR_PRESETS.put("maroon", 0x800000);
        COLOR_NAMES = new ArrayList<String>(COLOR_PRESETS.keySet());
    }
}

