/*
 * Decompiled with CFR 0.152.
 */
package dev.locations;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dev.locations.Location;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public final class LocationsState {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, List<StoredLocation>>>(){}.getType();
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("locations").resolve("locations.json");
    private final Map<String, List<Location>> byDim = new HashMap<String, List<Location>>();
    private static final LocationsState INSTANCE = new LocationsState();

    private LocationsState() {
    }

    public static LocationsState get(MinecraftServer server) {
        return INSTANCE;
    }

    public List<Location> getLocations(class_2960 dimensionId) {
        return this.byDim.computeIfAbsent(dimensionId.toString(), k -> new ArrayList());
    }

    public void add(class_2960 dimensionId, Location loc) {
        this.getLocations(dimensionId).add(loc);
    }

    public boolean remove(class_2960 dimensionId, String name) {
        List<Location> list = this.getLocations(dimensionId);
        return list.removeIf(l -> l.name.equalsIgnoreCase(name));
    }

    public Location find(class_2960 dimensionId, String name) {
        for (Location l : this.getLocations(dimensionId)) {
            if (!l.name.equalsIgnoreCase(name)) continue;
            return l;
        }
        return null;
    }

    public synchronized void load() {
        block13: {
            try {
                if (!Files.exists(FILE, new LinkOption[0])) {
                    Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
                    return;
                }
                try (BufferedReader reader = Files.newBufferedReader(FILE, StandardCharsets.UTF_8);){
                    Map flat = (Map)GSON.fromJson((Reader)reader, MAP_TYPE);
                    this.byDim.clear();
                    if (flat == null) break block13;
                    for (Map.Entry e : flat.entrySet()) {
                        ArrayList<Location> list = new ArrayList<Location>();
                        for (StoredLocation s : (List)e.getValue()) {
                            Location.Shape shape;
                            try {
                                shape = s.shape == null ? Location.Shape.CIRCLE : Location.Shape.valueOf(s.shape.toUpperCase(Locale.ROOT));
                            }
                            catch (Exception ex) {
                                shape = Location.Shape.CIRCLE;
                            }
                            list.add(new Location(s.name, new class_2338(s.x, s.y, s.z), s.radius, s.color == 0 ? -1 : s.color, shape, s.fancy));
                        }
                        this.byDim.put((String)e.getKey(), list);
                    }
                }
            }
            catch (IOException ioe) {
                System.err.println("[locations] Failed to load config: " + String.valueOf(ioe));
            }
        }
    }

    public synchronized void save() {
        try {
            Files.createDirectories(FILE.getParent(), new FileAttribute[0]);
            HashMap flat = new HashMap();
            for (Map.Entry<String, List<Location>> e : this.byDim.entrySet()) {
                ArrayList<StoredLocation> out = new ArrayList<StoredLocation>();
                for (Location l : e.getValue()) {
                    StoredLocation s = new StoredLocation();
                    s.name = l.name;
                    s.x = l.center.method_10263();
                    s.y = l.center.method_10264();
                    s.z = l.center.method_10260();
                    s.radius = l.radius;
                    s.color = l.colorRgb;
                    s.shape = l.shape.name();
                    s.fancy = l.fancy;
                    out.add(s);
                }
                flat.put(e.getKey(), out);
            }
            try (BufferedWriter w = Files.newBufferedWriter(FILE, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson(flat, MAP_TYPE, (Appendable)w);
            }
        }
        catch (IOException ioe) {
            System.err.println("[locations] Failed to save config: " + String.valueOf(ioe));
        }
    }

    private static final class StoredLocation {
        String name;
        int x;
        int y;
        int z;
        int radius;
        int color;
        String shape;
        boolean fancy;

        private StoredLocation() {
        }
    }
}

