/*
 * Decompiled with CFR 0.152.
 */
package me.croabeast.command;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import me.croabeast.command.BaseCommand;
import me.croabeast.command.Command;
import me.croabeast.command.CommandPredicate;
import me.croabeast.command.DefaultPermissible;
import me.croabeast.command.SenderPredicate;
import me.croabeast.command.TabBuilder;
import me.croabeast.common.Registrable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Server;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BukkitCommand
extends org.bukkit.command.defaults.BukkitCommand
implements Command,
DefaultPermissible {
    private final NamespacedKey key;
    private final Plugin plugin;
    final Map<String, BaseCommand> subCommands = new LinkedHashMap<String, BaseCommand>();
    private boolean registered = false;
    private CommandPredicate predicate = null;
    @NotNull
    SenderPredicate<Throwable> executingError;
    @NotNull
    SenderPredicate<Throwable> completingError;
    private Entry loadedCommand;
    @NotNull
    SenderPredicate<String> wrongArgumentAction;

    protected BukkitCommand(Plugin plugin, String name, String permission) {
        super(name);
        this.plugin = Objects.requireNonNull(plugin);
        UUID uuid = UUID.randomUUID();
        this.key = new NamespacedKey(plugin, uuid.toString());
        this.setPermission(permission);
        this.executingError = (s, e) -> {
            s.sendMessage(plugin.getName() + " Error executing the command " + this.getName());
            e.printStackTrace();
            return true;
        };
        this.completingError = (s, e) -> {
            s.sendMessage(plugin.getName() + " Error completing the command " + this.getName());
            e.printStackTrace();
            return true;
        };
        this.wrongArgumentAction = (s, a) -> true;
    }

    protected BukkitCommand(Plugin plugin, String name) {
        this(plugin, name, Entry.pluginName(plugin) + '.' + name);
    }

    public boolean isWrongArgument(CommandSender sender, String arg) {
        return this.wrongArgumentAction.test((String)sender, arg);
    }

    public boolean testPermissionSilent(@NotNull CommandSender target) {
        return this.isPermitted(target, false);
    }

    public boolean testPermission(@NotNull CommandSender target) {
        return this.isPermitted(target);
    }

    public void addAliases(String ... aliases) {
        List list = this.getAliases();
        for (String alias : aliases) {
            if (alias.equals(this.getName())) continue;
            list.add(alias);
        }
        this.setAliases(list);
    }

    public void removeAliases(String ... aliases) {
        List list = this.getAliases();
        list.removeAll(Arrays.asList(aliases));
        this.setAliases(list);
    }

    public void setAliases(String ... aliases) {
        super.setAliases(Arrays.asList(aliases));
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
        boolean success;
        if (!this.subCommands.isEmpty() && args.length > 0) {
            BaseCommand sub = this.getSubCommand(args[0]);
            if (sub == null) {
                return this.wrongArgumentAction.test((String)sender, args[0]);
            }
            int last = args.length - 1;
            if (sub.isPermitted(sender)) {
                boolean success2;
                String[] newArgs = new String[last];
                if (args.length > 1) {
                    System.arraycopy(args, 1, newArgs, 0, last);
                }
                try {
                    success2 = sub.getPredicate().test(sender, newArgs);
                }
                catch (Throwable e) {
                    success2 = this.executingError.test((Throwable)sender, e);
                }
                return success2;
            }
        }
        try {
            success = this.getPredicate().test(sender, args);
        }
        catch (Throwable e) {
            success = this.executingError.test((Throwable)sender, e);
        }
        return success;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        try {
            Collection before = (Collection)this.generateCompletions(sender, args).get();
            TabBuilder builder = this.getCompletionBuilder();
            ArrayList comps = builder != null && !builder.isEmpty() ? builder.build(sender, args) : (before == null ? null : new ArrayList(before));
            return Objects.requireNonNull(comps, "Completions are null");
        }
        catch (Exception e) {
            this.completingError.test((Throwable)sender, e);
            return super.tabComplete(sender, alias, args);
        }
    }

    @Override
    @NotNull
    public CommandPredicate getPredicate() {
        return Objects.requireNonNull(this.predicate, "Executable predicate is not set");
    }

    @Override
    @Nullable
    public BaseCommand getSubCommand(String name) {
        BaseCommand command = this.subCommands.get(name);
        if (command != null) {
            return command;
        }
        for (BaseCommand sub : this.subCommands.values()) {
            if (!sub.getAliases().contains(name)) continue;
            return sub;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<BaseCommand> getSubCommands() {
        return Collections.unmodifiableSet(new HashSet<BaseCommand>(this.subCommands.values()));
    }

    @Override
    public void addSubCommand(@NotNull BaseCommand sub) {
        Objects.requireNonNull(sub);
        if (!this.subCommands.containsValue(sub)) {
            this.subCommands.put(sub.getName(), sub);
        }
    }

    @Override
    public void removeSubCommand(@NotNull String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("Sub-command name cannot be null or empty");
        }
        this.subCommands.remove(name);
    }

    @Deprecated
    public void registerSubCommand(@NotNull BaseCommand sub) {
        this.addSubCommand(sub);
    }

    private static void addPerm(String perm) {
        if (StringUtils.isBlank((String)perm)) {
            return;
        }
        try {
            Permission permission = new Permission(perm);
            Bukkit.getPluginManager().addPermission(permission);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void removePerm(String perm) {
        if (!StringUtils.isBlank((String)perm)) {
            Bukkit.getPluginManager().removePermission(perm);
        }
    }

    private void loadCommandPermissions(boolean loaded) {
        Collection<BaseCommand> subs = this.subCommands.values();
        if (loaded) {
            BukkitCommand.removePerm(this.getPermission());
            if (!this.subCommands.isEmpty()) {
                subs.forEach(s -> BukkitCommand.removePerm(s.getPermission()));
                BukkitCommand.removePerm(this.getWildcardPermission());
            }
            return;
        }
        BukkitCommand.addPerm(this.getPermission());
        if (this.subCommands.isEmpty()) {
            return;
        }
        subs.forEach(s -> BukkitCommand.addPerm(s.getPermission()));
        BukkitCommand.addPerm(this.getWildcardPermission());
    }

    static SimpleCommandMap getMap() {
        Server server = Bukkit.getServer();
        Field field = server.getClass().getDeclaredField("commandMap");
        field.setAccessible(true);
        return (SimpleCommandMap)field.get(server);
    }

    static Map<String, org.bukkit.command.Command> knownCommands() {
        SimpleCommandMap map = BukkitCommand.getMap();
        Field field = SimpleCommandMap.class.getDeclaredField("knownCommands");
        field.setAccessible(true);
        return (Map)field.get(map);
    }

    public static void syncCommands() {
        Server server = Bukkit.getServer();
        Method method = server.getClass().getDeclaredMethod("syncCommands", new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)server, new Object[0]);
    }

    public boolean register(boolean sync) {
        if (this.registered) {
            return false;
        }
        org.bukkit.command.Command c = BukkitCommand.knownCommands().get(this.getName());
        if (this.isOverriding() && c != null) {
            this.loadedCommand = new Entry(c);
            this.loadedCommand.unregister();
        }
        this.loadCommandPermissions(true);
        BukkitCommand.getMap().register(Entry.pluginName(this.plugin), (org.bukkit.command.Command)this);
        if (sync) {
            BukkitCommand.syncCommands();
        }
        this.registered = true;
        return true;
    }

    @Override
    public boolean register() {
        return this.register(true);
    }

    public boolean unregister(boolean sync) {
        if (!this.registered) {
            return false;
        }
        org.bukkit.command.Command c = BukkitCommand.knownCommands().get(this.getName());
        if (!Objects.equals(c, this)) {
            return false;
        }
        BukkitCommand.knownCommands().values().removeIf(c1 -> Objects.equals(c1, c));
        c.unregister((CommandMap)BukkitCommand.getMap());
        this.loadCommandPermissions(false);
        if (this.loadedCommand != null) {
            this.loadedCommand.register();
            this.loadedCommand = null;
        }
        if (sync) {
            BukkitCommand.syncCommands();
        }
        this.registered = false;
        return !false;
    }

    @Override
    public boolean unregister() {
        return this.unregister(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BukkitCommand)) {
            return false;
        }
        BukkitCommand that = (BukkitCommand)o;
        return Objects.equals(this.getKey(), that.getKey());
    }

    public int hashCode() {
        return Objects.hashCode(this.getKey());
    }

    @Generated
    public NamespacedKey getKey() {
        return this.key;
    }

    @Generated
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    @Generated
    public boolean isRegistered() {
        return this.registered;
    }

    @Generated
    public void setPredicate(CommandPredicate predicate) {
        this.predicate = predicate;
    }

    @Generated
    public void setExecutingError(@NotNull SenderPredicate<Throwable> executingError) {
        if (executingError == null) {
            throw new NullPointerException("executingError is marked non-null but is null");
        }
        this.executingError = executingError;
    }

    @Generated
    public void setCompletingError(@NotNull SenderPredicate<Throwable> completingError) {
        if (completingError == null) {
            throw new NullPointerException("completingError is marked non-null but is null");
        }
        this.completingError = completingError;
    }

    @Generated
    public void setWrongArgumentAction(@NotNull SenderPredicate<String> wrongArgumentAction) {
        if (wrongArgumentAction == null) {
            throw new NullPointerException("wrongArgumentAction is marked non-null but is null");
        }
        this.wrongArgumentAction = wrongArgumentAction;
    }

    private static class Entry
    implements Registrable {
        private final org.bukkit.command.Command command;
        private final Plugin plugin;
        private final String fallbackPrefix;

        private Entry(@NotNull org.bukkit.command.Command command) {
            this.command = command;
            Plugin plugin = this.plugin = command instanceof PluginIdentifiableCommand ? ((PluginIdentifiableCommand)command).getPlugin() : null;
            if (this.plugin != null) {
                this.fallbackPrefix = Entry.pluginName(this.plugin);
                return;
            }
            HashSet names = new HashSet();
            BukkitCommand.knownCommands().forEach((k, v) -> {
                if (command.equals(v)) {
                    names.add(k);
                }
            });
            String prefix = "";
            for (String name : names) {
                if (!name.contains(":")) continue;
                prefix = name.split(":")[0];
            }
            this.fallbackPrefix = prefix;
        }

        static String pluginName(Plugin plugin) {
            return plugin.getName().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public boolean isRegistered() {
            return BukkitCommand.knownCommands().containsValue(this.command);
        }

        @Override
        public boolean register() {
            return BukkitCommand.getMap().register(this.fallbackPrefix, this.command);
        }

        @Override
        public boolean unregister() {
            BukkitCommand.knownCommands().values().removeIf(c -> c.equals(this.command));
            return this.command.unregister((CommandMap)BukkitCommand.getMap());
        }

        public String toString() {
            return "Entry{command=" + this.command + ", plugin=" + this.plugin + ", prefix='" + this.fallbackPrefix + "'}";
        }
    }
}

