/*
 * Decompiled with CFR 0.152.
 */
package me.croabeast.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import me.croabeast.command.BaseCommand;
import me.croabeast.command.Command;
import me.croabeast.command.CommandPredicate;
import me.croabeast.command.DefaultPermissible;
import me.croabeast.command.SenderPredicate;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class SubCommand
implements BaseCommand {
    private final String name;
    private String permission;
    private final Command parent;
    private final List<String> aliases = new ArrayList<String>();
    private CommandPredicate predicate = null;

    public SubCommand(Command parent, String name, String ... aliases) {
        this.parent = Objects.requireNonNull(parent, "Parent cannot be null");
        if (StringUtils.isBlank((String)name)) {
            throw new NullPointerException("Name is empty");
        }
        this.name = name;
        this.permission = parent.getPermission() + '.' + this.name;
        List<String> list = Arrays.asList(aliases);
        this.aliases.addAll(list);
    }

    public SubCommand(Command parent, String name) {
        this.parent = Objects.requireNonNull(parent, "Parent cannot be null");
        if (StringUtils.isBlank((String)name)) {
            throw new NullPointerException("Name is empty");
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(name.split(";")));
        this.name = (String)list.get(0);
        this.permission = parent.getPermission() + '.' + this.name;
        if (list.size() == 1) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            this.aliases.add((String)list.get(i));
        }
    }

    @Override
    public boolean isPermitted(CommandSender sender, boolean log) {
        SenderPredicate<String> checker = DefaultPermissible.DEFAULT_CHECKER;
        return checker.test((String)sender, this.parent.getWildcardPermission()) || checker.test((String)sender, this.permission);
    }

    @Override
    @NotNull
    public CommandPredicate getPredicate() {
        return Objects.requireNonNull(this.predicate, "Executable predicate is not set");
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public Command getParent() {
        return this.parent;
    }

    @Override
    @Generated
    public List<String> getAliases() {
        return this.aliases;
    }

    @Generated
    public void setPermission(String permission) {
        this.permission = permission;
    }

    @Generated
    public void setPredicate(CommandPredicate predicate) {
        this.predicate = predicate;
    }
}

