/*
 * Decompiled with CFR 0.152.
 */
package me.croabeast.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import me.croabeast.command.CommandPredicate;
import me.croabeast.command.SenderPredicate;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public final class TabBuilder {
    private final Map<Integer, Set<Suggestion<?>>> map = new LinkedHashMap();
    private SenderPredicate<String> permPredicate = Permissible::hasPermission;

    private Set<Suggestion<?>> fromIndex(int index) {
        return this.map.getOrDefault(index, new LinkedHashSet());
    }

    public TabBuilder setPermissionPredicate(SenderPredicate<String> predicate) {
        this.permPredicate = Objects.requireNonNull(predicate);
        return this;
    }

    private TabBuilder addArg0(int index, CommandPredicate predicate, BiFunction<CommandSender, String[], String> arg) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(arg);
        Set<Suggestion<?>> args = this.fromIndex(index);
        args.add(new Suggestion<String>(predicate, arg){

            @Override
            Class<String> getType() {
                return String.class;
            }
        });
        this.map.put(index, args);
        return this;
    }

    private TabBuilder addCollectionArg0(int index, CommandPredicate predicate, BiFunction<CommandSender, String[], Collection<String>> arg) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(arg);
        Set<Suggestion<?>> args = this.fromIndex(index);
        args.add(new Suggestion<Collection<String>>(predicate, arg){

            @Override
            Class<Collection<String>> getType() {
                return null;
            }
        });
        this.map.put(index, args);
        return this;
    }

    public TabBuilder addArgument(int index, CommandPredicate predicate, BiFunction<CommandSender, String[], String> argument) {
        return this.addArg0(index, predicate, argument);
    }

    public TabBuilder addArgument(int index, CommandPredicate predicate, String argument) {
        return this.addArg0(index, predicate, (s, a) -> argument);
    }

    public TabBuilder addArgument(int index, String permission, BiFunction<CommandSender, String[], String> argument) {
        return this.addArg0(index, (s, a) -> this.permPredicate.test((String)s, permission), argument);
    }

    public TabBuilder addArgument(int index, String permission, String argument) {
        return this.addArgument(index, permission, (CommandSender s, String[] a) -> argument);
    }

    public TabBuilder addArgument(int index, BiFunction<CommandSender, String[], String> argument) {
        return this.addArgument(index, (s, a) -> true, argument);
    }

    public TabBuilder addArgument(int index, String argument) {
        return this.addArgument(index, (CommandSender s, String[] a) -> argument);
    }

    public TabBuilder addArguments(int index, CommandPredicate predicate, BiFunction<CommandSender, String[], Collection<String>> function) {
        return this.addCollectionArg0(index, predicate, function);
    }

    public TabBuilder addArguments(int index, CommandPredicate predicate, Collection<String> arguments) {
        return this.addCollectionArg0(index, predicate, (s, a) -> Objects.requireNonNull(arguments));
    }

    public TabBuilder addArguments(int index, CommandPredicate predicate, String ... arguments) {
        return this.addArguments(index, predicate, Arrays.asList(arguments));
    }

    public TabBuilder addArguments(int index, BiFunction<CommandSender, String[], Collection<String>> function) {
        return this.addArguments(index, (s, a) -> true, function);
    }

    public TabBuilder addArguments(int index, Collection<String> arguments) {
        return this.addArguments(index, (s, a) -> true, arguments);
    }

    public TabBuilder addArguments(int index, String ... arguments) {
        return this.addArguments(index, (s, a) -> true, arguments);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public List<String> build(CommandSender sender, String[] args) {
        LinkedList list = new LinkedList();
        this.fromIndex(args.length - 1).stream().filter(o -> o.predicate.test(sender, args)).forEach(o -> {
            if (Objects.equals(String.class, o.getType())) {
                list.add((String)o.function.apply(sender, args));
                return;
            }
            list.addAll((Collection)o.function.apply(sender, args));
        });
        String t = args[args.length - 1];
        return list.stream().filter(s -> s.regionMatches(true, 0, t, 0, t.length())).collect(Collectors.toList());
    }

    private static abstract class Suggestion<T> {
        final CommandPredicate predicate;
        final BiFunction<CommandSender, String[], T> function;

        abstract Class<T> getType();

        @Generated
        Suggestion(CommandPredicate predicate, BiFunction<CommandSender, String[], T> function) {
            this.predicate = predicate;
            this.function = function;
        }
    }
}

