/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.panorandom;

import com.nettakrim.panorandom.PanorandomClient;
import com.nettakrim.panorandom.PanorandomCubemapTexture;
import com.nettakrim.panorandom.mixin.TextureManagerInvoker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10537;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;

public class PanoramaResourceLoader
extends class_4080<Set<Map.Entry<String, List<Image>>>>
implements IdentifiableResourceReloadListener {
    public static final String resourceLocation = "textures/gui/title/background";

    protected Set<Map.Entry<String, List<Image>>> prepare(class_3300 manager, class_3695 profiler) {
        try {
            HashMap<String, List> unsortedSets = new HashMap<String, List>();
            HashMap<Object, Image> overlaySets = new HashMap<Object, Image>();
            try {
                Optional vanillaOverlay = class_310.method_1551().method_45573().method_43032().method_14486(class_2960.method_60655((String)"minecraft", (String)"textures/gui/title/background/panorama_overlay.png"));
                if (vanillaOverlay.isPresent()) {
                    overlaySets.put("vanilla", new Image(((class_3298)vanillaOverlay.get()).method_14482().readAllBytes()));
                }
            }
            catch (IOException error) {
                PanorandomClient.LOGGER.warn("Failed to load vanilla overlay: ", (Throwable)error);
            }
            class_7654 resourceFinder = new class_7654(resourceLocation, ".png");
            for (Map.Entry identifierResourceEntry : resourceFinder.method_45116(manager).entrySet()) {
                for (class_3298 resource : (List)identifierResourceEntry.getValue()) {
                    String name = resourceFinder.method_45115((class_2960)identifierResourceEntry.getKey()).method_12832();
                    int length = name.length();
                    if (length <= 2) continue;
                    if (name.endsWith("_overlay")) {
                        try (InputStream stream = resource.method_14482();){
                            overlaySets.put(resource.method_14480() + "/" + name.substring(0, length - "_overlay".length()), new Image(stream.readAllBytes()));
                        }
                        catch (IOException error) {
                            PanorandomClient.LOGGER.error("Failed to prepare panorama overlay with id '{}': {}", (Object)name, (Object)error);
                        }
                        continue;
                    }
                    String id = name.substring(length - 2);
                    if (id.charAt(0) != '_' || id.charAt(1) < '0' || id.charAt(1) > '5') continue;
                    int faceIndex = name.charAt(1) - 48;
                    String panoramaSet2 = resource.method_14480() + "/" + name.substring(0, length - 2);
                    List resources = unsortedSets.computeIfAbsent(panoramaSet2, k -> new ArrayList());
                    try {
                        InputStream stream = resource.method_14482();
                        try {
                            resources.add(new IndexedImage(new Image(stream.readAllBytes()), faceIndex));
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (IOException error) {
                        PanorandomClient.LOGGER.error("Failed to prepare panorama with id '{}': {}", (Object)name, (Object)error);
                    }
                }
            }
            unsortedSets.entrySet().removeIf(panoramaSet -> ((List)panoramaSet.getValue()).size() != 6);
            HashMap<String, List<Image>> sortedSets = new HashMap<String, List<Image>>();
            for (Map.Entry entry : unsortedSets.entrySet()) {
                List<Image> sortedResources = ((List)entry.getValue()).stream().sorted(Comparator.comparingInt(IndexedImage::faceIndex)).map(IndexedImage::resource).toList();
                Image overlay = (Image)overlaySets.get(entry.getKey());
                if (overlay == null) {
                    overlay = (Image)overlaySets.get("vanilla");
                }
                if (overlay != null) {
                    ArrayList<Image> preparedResources = new ArrayList<Image>(sortedResources);
                    preparedResources.add(overlay);
                    sortedResources = preparedResources;
                }
                sortedSets.put((String)entry.getKey(), sortedResources);
            }
            return sortedSets.entrySet();
        }
        catch (Exception error) {
            PanorandomClient.LOGGER.error("Failed to prepare panorandom: ", (Throwable)error);
            return null;
        }
    }

    private void clear() {
        for (class_2960 id : PanorandomClient.PANORAMAS) {
            class_1060 textureManager = class_310.method_1551().method_1531();
            if (((TextureManagerInvoker)textureManager).getTextures().containsKey(id)) {
                textureManager.method_4615(id);
            }
            if (!((TextureManagerInvoker)textureManager).getTextures().containsKey(id.method_48331("_overlay"))) continue;
            textureManager.method_4615(id.method_48331("_overlay"));
        }
        PanorandomClient.PANORAMAS.clear();
        PanorandomClient.ENABLED.clear();
    }

    protected void apply(Set<Map.Entry<String, List<Image>>> prepared, class_3300 manager, class_3695 profiler) {
        try {
            if (prepared == null) {
                return;
            }
            this.clear();
            for (Map.Entry<String, List<Image>> panoramaSet : prepared) {
                StringBuilder builder = new StringBuilder(panoramaSet.getKey().toLowerCase(Locale.ROOT));
                for (int i = 0; i < builder.length(); ++i) {
                    if (class_2960.method_12831((char)builder.charAt(i))) continue;
                    builder.setCharAt(i, '_');
                }
                class_2960 identifier = class_2960.method_60655((String)"panorandom", (String)builder.toString());
                PanorandomClient.LOGGER.info("registering cubemap texture {}", (Object)identifier);
                List<Image> resources = panoramaSet.getValue();
                class_310.method_1551().method_1531().method_65876(identifier, (class_10537)new PanorandomCubemapTexture(identifier, new PanorandomCubemapTexture.CubemapImages(resources.get(0).toNativeImage(), resources.get(1).toNativeImage(), resources.get(2).toNativeImage(), resources.get(3).toNativeImage(), resources.get(4).toNativeImage(), resources.get(5).toNativeImage())));
                class_2960 overlayId = identifier.method_48331("_overlay");
                if (resources.size() == 7 && resources.get(6) != null) {
                    PanorandomClient.LOGGER.info("registering overlay texture {}", (Object)overlayId);
                    class_310.method_1551().method_1531().method_4616(overlayId, (class_1044)new class_1043(() -> ((class_2960)overlayId).toString(), resources.get(6).toNativeImage()));
                }
                PanorandomClient.PANORAMAS.add(identifier);
            }
            Collections.sort(PanorandomClient.PANORAMAS);
            PanorandomClient.ENABLED.addAll(PanorandomClient.PANORAMAS);
            PanorandomClient.ENABLED.removeIf(PanorandomClient.DISABLED::contains);
            PanorandomClient.randomisePanorama();
        }
        catch (Exception error) {
            PanorandomClient.LOGGER.error("Failed to apply panorandom: ", (Throwable)error);
        }
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"panorandom", (String)resourceLocation);
    }

    public record Image(byte[] data) {
        public class_1011 toNativeImage() throws IOException {
            try (ByteArrayInputStream in = new ByteArrayInputStream(this.data);){
                class_1011 class_10112 = class_1011.method_4309((InputStream)in);
                return class_10112;
            }
        }
    }

    private record IndexedImage(Image resource, int faceIndex) {
    }
}

