/*
 * Decompiled with CFR 0.152.
 */
package io.github.pelotrio.worldoptimiser;

import io.github.pelotrio.worldoptimiser.WorldOptimiser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="worldoptimiser")
public class WorldUpgraderEventHandler {
    private static final Logger logger = LogManager.getLogger((String)"worldoptimiser/worldupgrader");

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        LevelStorageSource.LevelStorageAccess session = server.f_129744_;
        if (!WorldOptimiser.hasNewMods) {
            boolean hasMismatch;
            Map<String, String> previousMods = WorldUpgraderEventHandler.read(session);
            if (previousMods.isEmpty()) {
                return;
            }
            Map<String, String> currentMods = ModList.get().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, m -> m.getVersion().toString()));
            boolean bl = hasMismatch = !currentMods.equals(previousMods);
            if (!hasMismatch) {
                return;
            }
        }
        logger.info("World will be optimised it may take a while, please wait...");
        WorldUpgrader updater = new WorldUpgrader(session, server.m_129933_(), server.m_247573_().m_247579_().m_175515_(Registries.f_256862_), true);
        while (!updater.m_18829_()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info("World optimisation complete");
    }

    public static Map<String, String> read(LevelStorageSource.LevelStorageAccess session) {
        Path levelDat = session.m_78283_(LevelResource.f_78178_);
        try {
            CompoundTag root = NbtIo.m_128937_((File)levelDat.toFile());
            CompoundTag fml = root.m_128469_("fml");
            if (!fml.m_128425_("LoadingModList", 9)) {
                return Map.of();
            }
            ListTag list = fml.m_128437_("LoadingModList", 10);
            LinkedHashMap<String, String> mods = new LinkedHashMap<String, String>();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.m_128728_(i);
                String id = entry.m_128461_("ModId");
                String ver = entry.m_128461_("ModVersion");
                if (id.isEmpty()) continue;
                mods.put(id, ver);
            }
            return mods;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read LoadingModList from " + levelDat, e);
        }
    }
}

