/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.enderteleporter;

import cc.spea.enderteleporter.blocks.EnderTeleporterBlock;
import cc.spea.enderteleporter.blocks.EnderTeleporterBlockEntity;
import cc.spea.enderteleporter.gui.ModMenu;
import cc.spea.enderteleporter.networking.PacketHandler;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="enderteleporter")
public class EnderTeleporter {
    public static final String MODID = "enderteleporter";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"enderteleporter");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"enderteleporter");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"enderteleporter");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"enderteleporter");
    public static final RegistryObject<Block> ENDER_TELEPORTER_BLOCK = BLOCKS.register("ender_teleporter", () -> new EnderTeleporterBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)));
    public static final RegistryObject<Item> ENDER_TELEPORTER_BLOCK_ITEM = ITEMS.register("ender_teleporter", () -> new BlockItem((Block)ENDER_TELEPORTER_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockEntityType<EnderTeleporterBlockEntity>> ENDER_TELEPORTER_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("ender_teleporter", () -> BlockEntityType.Builder.m_155273_(EnderTeleporterBlockEntity::new, (Block[])new Block[]{(Block)ENDER_TELEPORTER_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<CreativeModeTab> ENDER_TELEPORTER_TAB = CREATIVE_MODE_TABS.register("ender_teleporter_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257737_(() -> ((Item)ENDER_TELEPORTER_BLOCK_ITEM.get()).m_7968_()).m_257941_((Component)Component.m_237115_((String)"gui.endertelepoerter.title")).m_257501_((parameters, output) -> output.m_246326_((ItemLike)ENDER_TELEPORTER_BLOCK.get())).m_257652_());
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"enderteleporter");
    public static final RegistryObject<MenuType<ModMenu>> MOD_MENU = MENUS.register("ender_teleporter_menu", () -> IForgeMenuType.create((windowId, inv, data) -> {
        BlockPos pos = data.m_130135_();
        BlockEntity be = inv.f_35978_.m_9236_().m_7702_(pos);
        if (be instanceof EnderTeleporterBlockEntity) {
            EnderTeleporterBlockEntity etbe = (EnderTeleporterBlockEntity)be;
            return new ModMenu(windowId, inv, etbe);
        }
        return null;
    }));

    public EnderTeleporter(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        MENUS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        PacketHandler.register();
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.accept(ENDER_TELEPORTER_BLOCK_ITEM);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="enderteleporter", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
        }
    }
}

