/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.enderteleporter.blocks;

import cc.spea.enderteleporter.blocks.EnderTeleporterBlockEntity;
import cc.spea.enderteleporter.data.TeleporterData;
import cc.spea.enderteleporter.data.TeleporterManager;
import cc.spea.enderteleporter.networking.PacketHandler;
import cc.spea.enderteleporter.networking.packets.S2C_OpenScreenPacket;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class EnderTeleporterBlock
extends BaseEntityBlock {
    public EnderTeleporterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new EnderTeleporterBlockEntity(p_153215_, p_153216_);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockentity;
        if (stack.m_41788_() && (blockentity = world.m_7702_(pos)) instanceof EnderTeleporterBlockEntity) {
            EnderTeleporterBlockEntity enderTeleporterBlockEntity = (EnderTeleporterBlockEntity)blockentity;
            enderTeleporterBlockEntity.m_58638_(stack.m_41786_());
        }
        if (!world.m_5776_() && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            TeleporterManager manager = TeleporterManager.get(serverLevel);
            String name = stack.m_41786_().getString();
            TeleporterData data = new TeleporterData(name, pos, (ResourceKey<Level>)world.m_46472_());
            manager.addGlobalTeleporter(data);
            if (placer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)placer;
                manager.addTeleporterToPlayerList(serverPlayer.m_20148_(), pos);
            }
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            if (!world.m_5776_() && world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                TeleporterManager manager = TeleporterManager.get(serverLevel);
                manager.removeGlobalTeleporter(pos);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = serverPlayer.m_21120_(hand);
            TeleporterManager manager = TeleporterManager.get(serverPlayer.m_284548_());
            if (stack.m_150930_(Items.f_42747_)) {
                Optional<TeleporterData> existingLink = manager.getDeathTeleporterData(serverPlayer.m_20148_());
                if (existingLink.isPresent()) {
                    TeleporterData existingData = existingLink.get();
                    player.m_5661_((Component)Component.m_237110_((String)"message.enderteleporter.totem_already_linked", (Object[])new Object[]{Component.m_237113_((String)existingData.name()).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                manager.addTeleporterToPlayerList(serverPlayer.m_20148_(), pos);
                manager.setDeathTeleporter(serverPlayer.m_20148_(), pos);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                world.m_5594_(null, pos, SoundEvents.f_12513_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_5661_((Component)Component.m_237110_((String)"message.enderteleporter.totem_linked", (Object[])new Object[]{Component.m_237113_((String)"").m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GREEN), true);
                return InteractionResult.CONSUME;
            }
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof EnderTeleporterBlockEntity) {
                TeleporterManager managerInside = TeleporterManager.get(serverPlayer.m_284548_());
                List<TeleporterData> teleporters = managerInside.getPlayerTeleporters(serverPlayer.m_20148_()).stream().sorted(Comparator.comparing(TeleporterData::name)).collect(Collectors.toList());
                managerInside.addTeleporterToPlayerList(serverPlayer.m_20148_(), pos);
                int pearlCount = 0;
                for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                    if (!serverPlayer.m_150109_().m_8020_(i).m_150930_(Items.f_42584_)) continue;
                    pearlCount += serverPlayer.m_150109_().m_8020_(i).m_41613_();
                }
                PacketHandler.sendToPlayer(new S2C_OpenScreenPacket(teleporters, pearlCount, serverPlayer.m_7500_(), pos), serverPlayer);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        MapColor mapColor = pState.m_284242_((BlockGetter)pLevel, pPos);
        if (mapColor == MapColor.f_283808_) {
            return;
        }
        int colorValue = mapColor.f_283871_;
        float r = (float)(colorValue >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorValue >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorValue & 0xFF) / 255.0f;
        Vector3f particleColor = new Vector3f(r, g, b);
        float particleScale = 1.1f;
        DustParticleOptions dustOptions = new DustParticleOptions(particleColor, particleScale);
        int particleCount = 4;
        for (int i = 0; i < particleCount; ++i) {
            double particleX = (double)pPos.m_123341_() + pRandom.m_188500_();
            double particleY = (double)pPos.m_123342_() + pRandom.m_188500_();
            double particleZ = (double)pPos.m_123343_() + pRandom.m_188500_();
            double xSpeed = (pRandom.m_188500_() - 0.5) * 0.2;
            double ySpeed = (pRandom.m_188500_() - 0.5) * 0.2;
            double zSpeed = (pRandom.m_188500_() - 0.5) * 0.2;
            pLevel.m_7106_((ParticleOptions)dustOptions, particleX, particleY, particleZ, xSpeed, ySpeed, zSpeed);
        }
    }
}

