/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.enderteleporter.command;

import cc.spea.enderteleporter.data.TeleporterData;
import cc.spea.enderteleporter.data.TeleporterManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;

public class ModCommands {
    public static void register(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"enders").then(Commands.m_82127_((String)"list").executes(ModCommands::executeListCommand)));
    }

    private static int executeListCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        TeleporterManager manager = TeleporterManager.get(player.m_284548_());
        Collection<TeleporterData> playerTeleporters = manager.getPlayerTeleporters(player.m_20148_());
        if (playerTeleporters.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"You have not discovered any Ender Teleporters. Interact with one to add it to your list.").m_130940_(ChatFormatting.YELLOW));
            return 1;
        }
        List sortedTeleporters = playerTeleporters.stream().map(data -> new TeleporterWithDistance((TeleporterData)data, ModCommands.getEffectiveDistanceSq(player, data))).sorted(Comparator.comparingDouble(TeleporterWithDistance::distanceSq)).collect(Collectors.toList());
        MutableComponent message = Component.m_237113_((String)"--- Your Ender Teleporters (closest first) ---").m_130940_(ChatFormatting.GOLD);
        for (TeleporterWithDistance teleporter : sortedTeleporters) {
            TeleporterData data2 = teleporter.data();
            BlockPos pos = data2.pos();
            int distance = (int)Math.sqrt(teleporter.distanceSq);
            MutableComponent line = Component.m_237113_((String)"\n- ").m_7220_((Component)Component.m_237113_((String)data2.name()).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)String.format(" at [%d, %d, %d] in %s (%d blocks away)", pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), ModCommands.getDimensionName(data2.dimension()), distance)).m_130940_(ChatFormatting.GRAY));
            message.m_7220_((Component)line);
        }
        player.m_213846_((Component)message);
        return 1;
    }

    private static double getEffectiveDistanceSq(ServerPlayer player, TeleporterData teleporter) {
        ResourceKey playerDim = player.m_9236_().m_46472_();
        ResourceKey<Level> teleporterDim = teleporter.dimension();
        Vec3 playerPos = player.m_20182_();
        Vec3 teleporterPos = Vec3.m_82512_((Vec3i)teleporter.pos());
        if (playerDim.equals(teleporterDim)) {
            return playerPos.m_82557_(teleporterPos);
        }
        if (playerDim.equals((Object)Level.f_46428_) && teleporterDim.equals((Object)Level.f_46429_)) {
            Vec3 scaledTeleporterPos = new Vec3(teleporterPos.f_82479_ * 8.0, teleporterPos.f_82480_, teleporterPos.f_82481_ * 8.0);
            return playerPos.m_82557_(scaledTeleporterPos);
        }
        if (playerDim.equals((Object)Level.f_46429_) && teleporterDim.equals((Object)Level.f_46428_)) {
            Vec3 scaledTeleporterPos = new Vec3(teleporterPos.f_82479_ / 8.0, teleporterPos.f_82480_, teleporterPos.f_82481_ / 8.0);
            return playerPos.m_82557_(scaledTeleporterPos);
        }
        return Double.MAX_VALUE;
    }

    private static String getDimensionName(ResourceKey<Level> dimensionKey) {
        return dimensionKey.m_135782_().m_135815_().replace("_", " ").toUpperCase();
    }

    private record TeleporterWithDistance(TeleporterData data, double distanceSq) {
    }
}

