/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.enderteleporter.data;

import cc.spea.enderteleporter.data.TeleporterData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class TeleporterManager
extends SavedData {
    private static final String DATA_NAME = "enderteleporter_data_v3";
    private final Map<BlockPos, TeleporterData> globalTeleporters = new HashMap<BlockPos, TeleporterData>();
    private final Map<UUID, Set<BlockPos>> playerTeleporterLists = new HashMap<UUID, Set<BlockPos>>();
    private final Map<UUID, BlockPos> deathTeleporterLinks = new HashMap<UUID, BlockPos>();

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag globalListTag = new ListTag();
        for (TeleporterData data : this.globalTeleporters.values()) {
            globalListTag.add((Object)data.save(new CompoundTag()));
        }
        nbt.m_128365_("GlobalTeleporters", (Tag)globalListTag);
        CompoundTag playerListsTag = new CompoundTag();
        this.playerTeleporterLists.forEach((uuid, positions) -> {
            ListTag posListTag = new ListTag();
            for (BlockPos pos : positions) {
                posListTag.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            playerListsTag.m_128365_(uuid.toString(), (Tag)posListTag);
        });
        nbt.m_128365_("PlayerTeleporterLists", (Tag)playerListsTag);
        CompoundTag deathLinksTag = new CompoundTag();
        this.deathTeleporterLinks.forEach((uuid, pos) -> deathLinksTag.m_128365_(uuid.toString(), (Tag)NbtUtils.m_129224_((BlockPos)pos)));
        nbt.m_128365_("DeathTeleporterLinks", (Tag)deathLinksTag);
        return nbt;
    }

    public static TeleporterManager load(CompoundTag nbt) {
        TeleporterManager manager = new TeleporterManager();
        ListTag globalListTag = nbt.m_128437_("GlobalTeleporters", 10);
        for (int i = 0; i < globalListTag.size(); ++i) {
            CompoundTag teleporterTag = globalListTag.m_128728_(i);
            TeleporterData data = TeleporterData.load(teleporterTag);
            manager.globalTeleporters.put(data.pos(), data);
        }
        CompoundTag playerListsTag = nbt.m_128469_("PlayerTeleporterLists");
        for (String key : playerListsTag.m_128431_()) {
            UUID uuid = UUID.fromString(key);
            ListTag posListTag = playerListsTag.m_128437_(key, 10);
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            for (int i = 0; i < posListTag.size(); ++i) {
                positions.add(NbtUtils.m_129239_((CompoundTag)posListTag.m_128728_(i)));
            }
            manager.playerTeleporterLists.put(uuid, positions);
        }
        CompoundTag deathLinksTag = nbt.m_128469_("DeathTeleporterLinks");
        for (String key : deathLinksTag.m_128431_()) {
            UUID uuid = UUID.fromString(key);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)deathLinksTag.m_128469_(key));
            manager.deathTeleporterLinks.put(uuid, pos);
        }
        return manager;
    }

    public static TeleporterManager get(ServerLevel level) {
        DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
        return (TeleporterManager)storage.m_164861_(TeleporterManager::load, TeleporterManager::new, DATA_NAME);
    }

    public void addGlobalTeleporter(TeleporterData data) {
        this.globalTeleporters.put(data.pos(), data);
        this.m_77762_();
    }

    public void removeGlobalTeleporter(BlockPos pos) {
        this.globalTeleporters.remove(pos);
        this.playerTeleporterLists.values().forEach(set -> set.remove(pos));
        this.deathTeleporterLinks.entrySet().removeIf(entry -> ((BlockPos)entry.getValue()).equals((Object)pos));
        this.m_77762_();
    }

    public void addTeleporterToPlayerList(UUID playerUuid, BlockPos pos) {
        if (this.globalTeleporters.containsKey(pos)) {
            this.playerTeleporterLists.computeIfAbsent(playerUuid, k -> new HashSet()).add(pos);
            this.m_77762_();
        }
    }

    public Collection<TeleporterData> getPlayerTeleporters(UUID playerUuid) {
        Set<BlockPos> playerPositions = this.playerTeleporterLists.get(playerUuid);
        if (playerPositions == null) {
            return Collections.emptyList();
        }
        return playerPositions.stream().map(this.globalTeleporters::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Optional<BlockPos> getDeathTeleporterPos(UUID playerUuid) {
        return Optional.ofNullable(this.deathTeleporterLinks.get(playerUuid));
    }

    public Optional<TeleporterData> getDeathTeleporterData(UUID playerUuid) {
        return this.getDeathTeleporterPos(playerUuid).map(this.globalTeleporters::get);
    }

    public void setDeathTeleporter(UUID playerUuid, BlockPos pos) {
        this.deathTeleporterLinks.put(playerUuid, pos);
        this.m_77762_();
    }

    public void clearDeathTeleporter(UUID playerUuid) {
        if (this.deathTeleporterLinks.remove(playerUuid) != null) {
            this.m_77762_();
        }
    }
}

