/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.enderteleporter.event;

import cc.spea.enderteleporter.EnderTeleporter;
import cc.spea.enderteleporter.command.ModCommands;
import cc.spea.enderteleporter.data.TeleporterData;
import cc.spea.enderteleporter.data.TeleporterManager;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enderteleporter")
public class ModEvents {
    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        ModCommands.register(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (event.isCanceled() || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        TeleporterManager manager = TeleporterManager.get(player.m_284548_());
        Optional<TeleporterData> deathTeleporterOpt = manager.getDeathTeleporterData(player.m_20148_());
        if (deathTeleporterOpt.isPresent()) {
            TeleporterData data = deathTeleporterOpt.get();
            ServerLevel targetLevel = player.m_20194_().m_129880_(data.dimension());
            BlockPos targetPos = data.pos();
            if (targetLevel != null && targetLevel.m_8055_(targetPos).m_60713_((Block)EnderTeleporter.ENDER_TELEPORTER_BLOCK.get())) {
                event.setCanceled(true);
                player.m_21153_(1.0f);
                player.m_21219_();
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
                player.m_9236_().m_7605_((Entity)player, (byte)35);
                player.m_20334_(0.0, 0.0, 0.0);
                player.m_8999_(targetLevel, (double)targetPos.m_123341_() + 0.5, (double)(targetPos.m_123342_() + 1), (double)targetPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                manager.clearDeathTeleporter(player.m_20148_());
                player.m_5661_((Component)Component.m_237115_((String)"message.enderteleporter.saved").m_130940_(ChatFormatting.GOLD), true);
            } else {
                manager.clearDeathTeleporter(player.m_20148_());
            }
        }
    }
}

