/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.enderteleporter.gui;

import cc.spea.enderteleporter.EnderTeleporter;
import cc.spea.enderteleporter.blocks.EnderTeleporterBlockEntity;
import cc.spea.enderteleporter.data.TeleporterData;
import cc.spea.enderteleporter.data.TeleporterManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ModMenu
extends AbstractContainerMenu {
    public final List<TeleporterData> teleporterList;
    private final EnderTeleporterBlockEntity blockEntity;
    private static final int PLAYER_INVENTORY_ROWS = 3;
    private static final int PLAYER_INVENTORY_COLUMNS = 9;

    public ModMenu(int windowId, Inventory playerInv, EnderTeleporterBlockEntity blockEntity) {
        super((MenuType)EnderTeleporter.MOD_MENU.get(), windowId);
        this.blockEntity = blockEntity;
        this.m_38897_(new Slot((Container)blockEntity, 0, 8, 18));
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        Player player = playerInv.f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TeleporterManager manager = TeleporterManager.get(serverPlayer.m_284548_());
            this.teleporterList = manager.getPlayerTeleporters(player.m_20148_()).stream().sorted(Comparator.comparing(TeleporterData::name)).collect(Collectors.toList());
        } else {
            this.teleporterList = Collections.emptyList();
        }
    }

    public ModMenu(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        super((MenuType)EnderTeleporter.MOD_MENU.get(), windowId);
        this.teleporterList = extraData.m_236845_(TeleporterData::read);
        this.blockEntity = (EnderTeleporterBlockEntity)playerInv.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemstack = slotStack.m_41777_();
            if (index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : !this.m_38903_(slotStack, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return ModMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)EnderTeleporter.ENDER_TELEPORTER_BLOCK.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 31 + j * 18, 98 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 31 + i * 18, 156));
        }
    }
}

