/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.enderteleporter.gui;

import cc.spea.enderteleporter.data.TeleporterData;
import cc.spea.enderteleporter.networking.PacketHandler;
import cc.spea.enderteleporter.networking.packets.C2S_TeleportPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class ModScreen
extends Screen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"enderteleporter", (String)"textures/gui/ender_teleporter.png");
    private final List<TeleporterData> teleporterList;
    private final List<Button> locationButtons = new ArrayList<Button>();
    private final int enderPearlCount;
    private final boolean creativeMode;
    private final BlockPos currentTeleporterPos;
    protected int imageWidth = 223;
    protected int imageHeight = 197;
    protected int leftPos;
    protected int topPos;
    private int scrollOffset = 0;
    private static final int VISIBLE_ROWS = 5;
    private static final int ROW_HEIGHT = 22;
    private static final int BLOCKS_PER_PEARL = 100;
    private static final double MAX_DISTANCE = 8.0;
    private boolean isDragging = false;

    public ModScreen(List<TeleporterData> teleporterList, int enderPearlCount, boolean creativeMode, BlockPos currentTeleporterPos) {
        super((Component)Component.m_237113_((String)"Ender Teleporter Network"));
        this.currentTeleporterPos = currentTeleporterPos;
        this.teleporterList = teleporterList.stream().filter(data -> !data.pos().equals((Object)currentTeleporterPos)).collect(Collectors.toList());
        this.enderPearlCount = enderPearlCount;
        this.creativeMode = creativeMode;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            BlockPos playerPos = this.f_96541_.f_91074_.m_20183_();
            this.teleporterList.sort(Comparator.comparingDouble(data -> data.pos().m_123331_((Vec3i)playerPos)));
        }
        this.buildLocationButtons();
    }

    private void buildLocationButtons() {
        int index;
        this.locationButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.locationButtons.clear();
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        int x = this.leftPos + 40;
        int y = this.topPos + 40;
        int buttonWidth = 143;
        int buttonHeight = 20;
        int listSize = this.teleporterList.size();
        for (int i = 0; i < 5 && (index = this.scrollOffset + i) < listSize; ++i) {
            TeleporterData data = this.teleporterList.get(index);
            double distance = Math.sqrt(data.pos().m_123331_((Vec3i)this.f_96541_.f_91074_.m_20183_()));
            int cost = this.calculateTeleportCost(distance);
            boolean canAfford = this.enderPearlCount >= cost;
            MutableComponent buttonText = Component.m_237113_((String)data.name()).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)String.format("%.0fm", distance)).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)" (").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)this.getDimensionName(data.dimension())).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)" [").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)String.format("%d", cost)).m_130940_(canAfford ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.GRAY));
            Button button = Button.m_253074_((Component)buttonText, btn -> {
                PacketHandler.sendToServer(new C2S_TeleportPacket(data.pos(), data.dimension()));
                this.m_7379_();
            }).m_252987_(x, y + i * 22, buttonWidth, buttonHeight).m_253136_();
            button.f_93623_ = canAfford || this.creativeMode;
            this.m_142416_((GuiEventListener)button);
            this.locationButtons.add(button);
        }
    }

    private int calculateTeleportCost(double distance) {
        return (int)Math.floor(distance / 100.0);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.teleporterList.size() > 5) {
            int maxScroll = this.teleporterList.size() - 5;
            this.scrollOffset = Mth.m_14045_((int)(this.scrollOffset - (int)delta), (int)0, (int)maxScroll);
            this.buildLocationButtons();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int scrollbarX;
        if (button == 0 && this.teleporterList.size() > 5 && mouseX >= (double)(scrollbarX = this.leftPos + this.imageWidth - 38) && mouseX < (double)(scrollbarX + 4)) {
            this.isDragging = true;
            return this.m_7979_(mouseX, mouseY, button, 0.0, 0.0);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging && button == 0 && this.teleporterList.size() > 5) {
            int scrollbarY = this.topPos + 40;
            int scrollbarHeight = 108;
            int listSize = this.teleporterList.size();
            int maxScroll = listSize - 5;
            int thumbHeight = (int)((float)scrollbarHeight * 5.0f / (float)listSize);
            thumbHeight = Mth.m_14045_((int)thumbHeight, (int)8, (int)scrollbarHeight);
            double scrollPercentage = (mouseY - (double)scrollbarY - (double)thumbHeight / 2.0) / (double)(scrollbarHeight - thumbHeight);
            this.scrollOffset = Mth.m_14045_((int)((int)Math.round(scrollPercentage * (double)maxScroll)), (int)0, (int)maxScroll);
            this.buildLocationButtons();
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        double distance;
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && (distance = this.f_96541_.f_91074_.m_20183_().m_123331_((Vec3i)this.currentTeleporterPos)) > 64.0) {
            this.m_7379_();
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.leftPos + 8, this.topPos - 10, -1, false);
        MutableComponent pearlCountText = Component.m_237113_((String)String.valueOf(this.enderPearlCount)).m_130940_(ChatFormatting.LIGHT_PURPLE);
        guiGraphics.m_280614_(this.f_96547_, (Component)pearlCountText, this.leftPos + 10, this.topPos + 184, -1, false);
        if (this.teleporterList.size() > 5) {
            this.renderScrollbar(guiGraphics);
        }
    }

    private void renderScrollbar(GuiGraphics guiGraphics) {
        int scrollbarX = this.leftPos + this.imageWidth - 38;
        int scrollbarY = this.topPos + 40;
        int scrollbarHeight = 108;
        int listSize = this.teleporterList.size();
        int maxScroll = Math.max(0, listSize - 5);
        guiGraphics.m_280509_(scrollbarX, scrollbarY, scrollbarX + 4, scrollbarY + scrollbarHeight, -14013910);
        if (maxScroll > 0) {
            int thumbHeight = (int)((float)scrollbarHeight * 5.0f / (float)listSize);
            thumbHeight = Mth.m_14045_((int)thumbHeight, (int)8, (int)scrollbarHeight);
            int thumbY = scrollbarY + (int)((float)(scrollbarHeight - thumbHeight) * (float)this.scrollOffset / (float)maxScroll);
            guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + 4, thumbY + thumbHeight, -8355712);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_ != null && this.f_96541_.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    private String getDimensionName(ResourceKey<Level> dimensionKey) {
        String path = dimensionKey.m_135782_().m_135815_();
        String[] words = path.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }
}

