/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.enderteleporter.networking.packets;

import cc.spea.enderteleporter.EnderTeleporter;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkEvent;

public class C2S_TeleportPacket {
    private final BlockPos targetPos;
    private final ResourceKey<Level> targetDimension;

    public C2S_TeleportPacket(BlockPos pos, ResourceKey<Level> dim) {
        this.targetPos = pos;
        this.targetDimension = dim;
    }

    public C2S_TeleportPacket(FriendlyByteBuf buf) {
        this.targetPos = buf.m_130135_();
        this.targetDimension = buf.m_236801_(Registries.f_256858_);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.targetPos);
        buf.m_236858_(this.targetDimension);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ServerLevel targetLevel = player.m_20194_().m_129880_(this.targetDimension);
            if (targetLevel != null && targetLevel.m_8055_(this.targetPos).m_60713_((Block)EnderTeleporter.ENDER_TELEPORTER_BLOCK.get())) {
                double distance = Math.sqrt(this.targetPos.m_123331_((Vec3i)player.m_20183_()));
                int cost = (int)Math.floor(distance / 100.0);
                int pearlCount = 0;
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    if (!player.m_150109_().m_8020_(i).m_150930_(Items.f_42584_)) continue;
                    pearlCount += player.m_150109_().m_8020_(i).m_41613_();
                }
                if (pearlCount >= cost || player.m_7500_()) {
                    Mob mob;
                    if (!player.m_7500_()) {
                        int remaining = cost;
                        for (int i = 0; i < player.m_150109_().m_6643_() && remaining > 0; ++i) {
                            if (!player.m_150109_().m_8020_(i).m_150930_(Items.f_42584_)) continue;
                            int n = player.m_150109_().m_8020_(i).m_41613_();
                            if (n >= remaining) {
                                player.m_150109_().m_8020_(i).m_41774_(remaining);
                                remaining = 0;
                                continue;
                            }
                            player.m_150109_().m_8020_(i).m_41774_(n);
                            remaining -= n;
                        }
                    }
                    ArrayList<Mob> leashedEntities = new ArrayList<Mob>();
                    for (Entity entity : player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82400_(10.0))) {
                        if (!(entity instanceof Mob) || (mob = (Mob)entity).m_21524_() != player) continue;
                        leashedEntities.add(mob);
                    }
                    player.m_8999_(targetLevel, (double)this.targetPos.m_123341_() + 0.5, (double)(this.targetPos.m_123342_() + 1), (double)this.targetPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                    player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    for (Entity entity : leashedEntities) {
                        if (!(entity instanceof Mob)) continue;
                        mob = (Mob)entity;
                        mob.m_21455_(true, false);
                        if (entity.m_9236_().m_46472_() != this.targetDimension) {
                            entity.m_5489_(targetLevel);
                        }
                        entity.m_6021_((double)this.targetPos.m_123341_() + 0.5, (double)(this.targetPos.m_123342_() + 1), (double)this.targetPos.m_123343_() + 0.5);
                        entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                        mob.m_21463_((Entity)player, true);
                    }
                    if (distance > 10000.0) {
                        float currentHealth = player.m_21223_();
                        float f = currentHealth / 2.0f;
                        player.m_6469_(player.m_269291_().m_269425_(), f);
                        player.m_5661_((Component)Component.m_237115_((String)"message.enderteleporter.long_distance_damage").m_130940_(ChatFormatting.RED), true);
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"message.enderteleporter.teleport_success").m_7220_((Component)Component.m_237113_((String)(" (-" + cost + " pearl" + (cost != 1 ? "s" : "") + ")")).m_130940_(ChatFormatting.LIGHT_PURPLE)).m_130940_(ChatFormatting.GREEN), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"message.enderteleporter.not_enough_pearls", (Object[])new Object[]{cost, pearlCount}).m_130940_(ChatFormatting.RED), true);
                }
            }
        });
        return true;
    }
}

