/*
 * Decompiled with CFR 0.152.
 */
package cc.spea.enderteleporter.networking.packets;

import cc.spea.enderteleporter.data.TeleporterData;
import cc.spea.enderteleporter.gui.ModScreen;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class S2C_OpenScreenPacket {
    private final List<TeleporterData> teleporterList;
    private final int enderPearlCount;
    private final boolean creativeMode;
    private final BlockPos currentTeleporterPos;

    public S2C_OpenScreenPacket(List<TeleporterData> teleporterList, int enderPearlCount, boolean creativeMode, BlockPos currentTeleporterPos) {
        this.teleporterList = teleporterList;
        this.enderPearlCount = enderPearlCount;
        this.creativeMode = creativeMode;
        this.currentTeleporterPos = currentTeleporterPos;
    }

    public S2C_OpenScreenPacket(FriendlyByteBuf buf) {
        this.teleporterList = buf.m_236845_(TeleporterData::read);
        this.enderPearlCount = buf.readInt();
        this.creativeMode = buf.readBoolean();
        this.currentTeleporterPos = buf.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_236828_(this.teleporterList, (b, data) -> data.write((FriendlyByteBuf)b));
        buf.writeInt(this.enderPearlCount);
        buf.writeBoolean(this.creativeMode);
        buf.m_130064_(this.currentTeleporterPos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> Minecraft.m_91087_().m_91152_((Screen)new ModScreen(this.teleporterList, this.enderPearlCount, this.creativeMode, this.currentTeleporterPos)));
        return true;
    }
}

