package com.odinokland.constantmusic.fabric.client.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_310;
import net.minecraft.class_638;

/**
 * The type Client world events.
 */
public final class ClientWorldEvents {
	private ClientWorldEvents() {
	}

	/**
	 * An event which is called after the client world has been changed.
	 */
	public static final Event<AfterClientWorldChange> AFTER_CLIENT_WORLD_CHANGE = EventFactory.createArrayBacked(AfterClientWorldChange.class, callbacks -> (client, world) -> {
		for (AfterClientWorldChange callback : callbacks) {
			callback.afterWorldChange(client, world);
		}
	});

	/**
	 * The interface After client world change.
	 */
	@FunctionalInterface
	public interface AfterClientWorldChange {
		/**
		 * Called after the client world has been changed.
		 *
		 * @param client the client instance
		 * @param world  the new world instance
		 */
		void afterWorldChange(class_310 client, class_638 world);
	}
}