package com.odinokland.constantmusic.fabric.mixin;

import com.odinokland.constantmusic.fabric.client.event.ClientWorldEvents;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * The type Minecraft client mixin.
 */
@Mixin(class_310.class)
public abstract class MinecraftClientMixin {
	@Inject(method = "updateLevelInEngines", at = @At("TAIL"))
	private void afterClientWorldChange(class_638 world, CallbackInfo ci) {
		if (world != null) {
			class_310 client = (class_310) (Object) this;
			ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.invoker().afterWorldChange(client, world);
		}
	}
}
