/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.texboobcat.pufferLike.ai.AIThrottleListener;
import org.texboobcat.pufferLike.async.WorkerPool;
import org.texboobcat.pufferLike.commands.PPCommand;
import org.texboobcat.pufferLike.engine.BudgetEngine;
import org.texboobcat.pufferLike.engine.HardFreezeService;
import org.texboobcat.pufferLike.engine.TickService;
import org.texboobcat.pufferLike.engine.listeners.BudgetCleanupListener;
import org.texboobcat.pufferLike.hologram.HologramService;
import org.texboobcat.pufferLike.hoppers.HopperCoordinatorListener;
import org.texboobcat.pufferLike.integration.WorldGuardHook;
import org.texboobcat.pufferLike.merging.EntityStackerListener;
import org.texboobcat.pufferLike.merging.MergingListener;
import org.texboobcat.pufferLike.packets.PacketOptimizer;
import org.texboobcat.pufferLike.performance.SharedBudgetService;
import org.texboobcat.pufferLike.players.IdleTracker;
import org.texboobcat.pufferLike.proximity.ProximityListener;
import org.texboobcat.pufferLike.proximity.ProximityService;
import org.texboobcat.pufferLike.smoothing.BlockSmootherListener;
import org.texboobcat.pufferLike.smoothing.PistonSmootherListener;
import org.texboobcat.pufferLike.smoothing.WorldSmootherListener;
import org.texboobcat.pufferLike.spawns.SpawnControllerListener;
import org.texboobcat.pufferLike.telemetry.StatsService;
import org.texboobcat.pufferLike.tools.StressTester;
import org.texboobcat.pufferLike.tracker.VisibilityCullingService;
import org.texboobcat.pufferLike.util.Exemptions;

public final class PufferLike
extends JavaPlugin {
    private ProximityService proximityService;
    private TickService tickService;
    private BudgetEngine budgetEngine;
    private StatsService statsService;
    private Exemptions exemptions;
    private WorkerPool workerPool;
    private SharedBudgetService sharedBudget;
    private PacketOptimizer packetOptimizer;
    private IdleTracker idleTracker;
    private WorldGuardHook worldGuardHook;
    private StressTester stressTester;
    private HardFreezeService hardFreezeService;
    private VisibilityCullingService visibilityCullingService;
    private HologramService hologramService;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        FileConfiguration cfg = this.getConfig();
        this.proximityService = new ProximityService((Plugin)this, cfg);
        this.tickService = new TickService((Plugin)this);
        this.budgetEngine = new BudgetEngine((Plugin)this, this.proximityService, this.tickService, cfg);
        this.statsService = new StatsService();
        this.exemptions = new Exemptions(cfg);
        this.workerPool = new WorkerPool((Plugin)this, cfg);
        this.sharedBudget = new SharedBudgetService((Plugin)this, cfg);
        this.idleTracker = new IdleTracker((Plugin)this);
        this.worldGuardHook = new WorldGuardHook((Plugin)this, cfg);
        this.packetOptimizer = new PacketOptimizer((Plugin)this, cfg, this.statsService, this.proximityService, this.idleTracker, this.worldGuardHook);
        this.stressTester = new StressTester((Plugin)this, this.workerPool);
        this.hardFreezeService = new HardFreezeService((Plugin)this, this.proximityService, this.exemptions, cfg);
        this.hologramService = new HologramService((Plugin)this, cfg);
        this.visibilityCullingService = new VisibilityCullingService((Plugin)this, cfg, this.hologramService);
        Bukkit.getPluginManager().registerEvents((Listener)new ProximityListener((Plugin)this, this.proximityService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BudgetCleanupListener(this.budgetEngine), (Plugin)this);
        boolean dabEnabled = cfg.getBoolean("dab.enabled", true);
        Bukkit.getPluginManager().registerEvents((Listener)new AIThrottleListener(this.budgetEngine, this.exemptions, this.statsService, dabEnabled), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SpawnControllerListener(cfg, this.proximityService, this.statsService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new MergingListener((Plugin)this, cfg, this.statsService, this.hologramService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new EntityStackerListener((Plugin)this, cfg, this.statsService, this.hologramService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BlockSmootherListener(cfg, this.tickService, this.statsService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PistonSmootherListener(cfg, this.tickService, this.statsService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new WorldSmootherListener(cfg, this.tickService, this.proximityService, this.statsService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new HopperCoordinatorListener(cfg, this.tickService, this.sharedBudget, this.statsService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.idleTracker, (Plugin)this);
        PPCommand kineticCommand = new PPCommand((Plugin)this, this.proximityService, this.budgetEngine, this.tickService, this.statsService, this.packetOptimizer, this.workerPool, this.stressTester, this.visibilityCullingService, this.hardFreezeService);
        if (this.getCommand("kinetic") != null) {
            this.getCommand("kinetic").setExecutor((CommandExecutor)kineticCommand);
            this.getCommand("kinetic").setTabCompleter((TabCompleter)kineticCommand);
        } else {
            this.getLogger().warning("Command /kinetic not registered in plugin.yml");
        }
        boolean pktEnabled = cfg.getBoolean("packets.enabled", false);
        boolean pktHideFar = cfg.getBoolean("packets.hide-far-entities.enabled", true);
        boolean trackerVis = cfg.getBoolean("tracker.visibility.enabled", false);
        if (pktEnabled && pktHideFar && trackerVis) {
            this.getLogger().warning("Both packets.hide-far-entities and tracker.visibility are enabled; this may cause double-hiding. Consider disabling one.");
        }
        try {
            this.packetOptimizer.start();
        }
        catch (Throwable t) {
            this.getLogger().warning("Failed to start PacketOptimizer: " + t.getMessage());
        }
        try {
            this.hardFreezeService.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.visibilityCullingService.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            try {
                this.budgetEngine.performMaintenance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, 200L, 200L);
    }

    public void onDisable() {
        if (this.packetOptimizer != null) {
            try {
                this.packetOptimizer.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.stressTester != null) {
            try {
                this.stressTester.stopAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.hologramService != null) {
            try {
                this.hologramService.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.workerPool != null) {
            this.workerPool.shutdown();
        }
        if (this.tickService != null) {
            this.tickService.shutdown();
        }
        if (this.proximityService != null) {
            this.proximityService.shutdown();
        }
    }
}

