/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.ai;

import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.PigZombieAngerEvent;
import org.jetbrains.annotations.NotNull;
import org.texboobcat.pufferLike.engine.Action;
import org.texboobcat.pufferLike.engine.BudgetEngine;
import org.texboobcat.pufferLike.telemetry.StatsService;
import org.texboobcat.pufferLike.util.Exemptions;

public class AIThrottleListener
implements Listener {
    private final BudgetEngine budget;
    private final Exemptions exemptions;
    private final StatsService stats;
    private final boolean dabEnabled;

    public AIThrottleListener(@NotNull BudgetEngine budget, @NotNull Exemptions exemptions, @NotNull StatsService stats, boolean dabEnabled) {
        this.budget = budget;
        this.exemptions = exemptions;
        this.stats = stats;
        this.dabEnabled = dabEnabled;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityPathfind(EntityPathfindEvent e) {
        if (!this.dabEnabled) {
            return;
        }
        if (this.exemptions.isExempt(e.getEntity())) {
            return;
        }
        if (this.budget.shouldThrottle(e.getEntity(), Action.PATHFIND)) {
            e.setCancelled(true);
            this.stats.increment("pathfindCancelled");
            return;
        }
        this.budget.markAndGetNext(e.getEntity(), Action.PATHFIND);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent e) {
        if (!this.dabEnabled) {
            return;
        }
        if (e.getEntity() == null) {
            return;
        }
        if (this.exemptions.isExempt(e.getEntity())) {
            return;
        }
        if (this.budget.shouldThrottle(e.getEntity(), Action.TARGET)) {
            e.setCancelled(true);
            this.stats.increment("targetDenied");
            return;
        }
        this.budget.markAndGetNext(e.getEntity(), Action.TARGET);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPigZombieAnger(PigZombieAngerEvent e) {
        if (!this.dabEnabled) {
            return;
        }
        if (this.exemptions.isExempt((Entity)e.getEntity())) {
            return;
        }
        if (this.budget.shouldThrottle((Entity)e.getEntity(), Action.ANGER)) {
            e.setCancelled(true);
            this.stats.increment("piglinAngerGated");
            return;
        }
        this.budget.markAndGetNext((Entity)e.getEntity(), Action.ANGER);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBreed(EntityBreedEvent e) {
        if (!this.dabEnabled) {
            return;
        }
        if (this.exemptions.isExempt((Entity)e.getMother()) || this.exemptions.isExempt((Entity)e.getFather())) {
            return;
        }
        if (this.budget.shouldThrottle((Entity)e.getMother(), Action.BREED) || this.budget.shouldThrottle((Entity)e.getFather(), Action.BREED)) {
            e.setCancelled(true);
            this.stats.increment("breedDeferred");
            return;
        }
        if (e.getMother() != null) {
            this.budget.markAndGetNext((Entity)e.getMother(), Action.BREED);
        }
        if (e.getFather() != null) {
            this.budget.markAndGetNext((Entity)e.getFather(), Action.BREED);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onTransform(EntityTransformEvent e) {
        if (!this.dabEnabled) {
            return;
        }
        if (e.getEntity() == null) {
            return;
        }
        if (this.exemptions.isExempt(e.getEntity())) {
            return;
        }
        if (this.budget.shouldThrottle(e.getEntity(), Action.BREED)) {
            e.setCancelled(true);
            this.stats.increment("transformDeferred");
            return;
        }
        this.budget.markAndGetNext(e.getEntity(), Action.BREED);
    }
}

