/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.async;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WorkerPool {
    private final Plugin plugin;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduler;
    private final BlockingQueue<Runnable> workQueue;
    private final ThreadPoolExecutor threadPool;
    private final AtomicLong tasksSubmitted = new AtomicLong(0L);
    private final AtomicLong tasksCompleted = new AtomicLong(0L);
    private final AtomicLong tasksRejected = new AtomicLong(0L);
    private final AtomicLong tasksFailed = new AtomicLong(0L);
    private final AtomicLong tasksTimedOut = new AtomicLong(0L);
    private volatile long lastTaskSubmissionTime = System.currentTimeMillis();
    private volatile long lastTaskCompletionTime = System.currentTimeMillis();
    private volatile boolean isHealthy = true;
    private volatile String lastError = null;
    private final int maxQueueSize;
    private final boolean enableMonitoring;
    private final long taskTimeoutMs;
    private final boolean enableFallbackExecution;
    private final long keepAliveTimeMs;
    private final double queueWarningThreshold;

    public WorkerPool(Plugin plugin, FileConfiguration config) {
        this(plugin, config != null ? config.getInt("async.core-threads", 4) : 4, config != null ? config.getInt("async.max-threads", 8) : 8, config != null ? config.getInt("async.max-queue-size", 100) : 100, config);
    }

    public WorkerPool(Plugin plugin, int coreThreads, int maxThreads, int maxQueueSize) {
        this(plugin, coreThreads, maxThreads, maxQueueSize, null);
    }

    public WorkerPool(Plugin plugin, int coreThreads, int maxThreads, int maxQueueSize, FileConfiguration config) {
        this.plugin = plugin;
        this.maxQueueSize = maxQueueSize;
        this.enableMonitoring = config != null ? config.getBoolean("async.monitoring.enabled", true) : true;
        this.taskTimeoutMs = config != null ? config.getLong("async.task-timeout-ms", 30000L) : 30000L;
        this.enableFallbackExecution = config != null ? config.getBoolean("async.fallback-execution", true) : true;
        this.keepAliveTimeMs = config != null ? config.getLong("async.keep-alive-time-ms", 60000L) : 60000L;
        this.queueWarningThreshold = config != null ? config.getDouble("async.queue-warning-threshold", 0.8) : 0.8;
        this.workQueue = new ArrayBlockingQueue<Runnable>(maxQueueSize);
        this.threadPool = new ThreadPoolExecutor(Math.max(1, coreThreads), Math.max(coreThreads, maxThreads), this.keepAliveTimeMs, TimeUnit.MILLISECONDS, this.workQueue, new WorkerThreadFactory(), new EnhancedRejectionHandler());
        this.threadPool.allowCoreThreadTimeOut(true);
        this.executor = this.threadPool;
        this.scheduler = Executors.newScheduledThreadPool(1, r -> {
            Thread t = new Thread(r, "Kinetic-Scheduler");
            t.setDaemon(true);
            return t;
        });
        if (this.enableMonitoring) {
            long healthCheckIntervalMs = config != null ? config.getLong("async.health-check-interval-ms", 300000L) : 300000L;
            this.scheduler.scheduleAtFixedRate(this::performHealthCheck, healthCheckIntervalMs, healthCheckIntervalMs, TimeUnit.MILLISECONDS);
            if (plugin.getLogger().isLoggable(Level.FINE)) {
                plugin.getLogger().fine("Scheduled periodic health checks every " + healthCheckIntervalMs + "ms");
            }
        }
    }

    public boolean performHealthCheck() {
        long now = System.currentTimeMillis();
        boolean healthy = true;
        if (now - this.lastTaskCompletionTime > this.taskTimeoutMs * 2L && this.tasksSubmitted.get() > this.tasksCompleted.get()) {
            healthy = false;
            if (this.enableMonitoring) {
                this.plugin.getLogger().warning("WorkerPool health check failed: No task completion in " + (now - this.lastTaskCompletionTime) + "ms");
            }
        }
        long submitted = this.tasksSubmitted.get();
        long rejected = this.tasksRejected.get();
        if (submitted > 100L && (double)rejected / (double)submitted > 0.1) {
            healthy = false;
            if (this.enableMonitoring) {
                this.plugin.getLogger().warning("WorkerPool health check failed: High rejection rate " + String.format("%.2f%%", (double)rejected / (double)submitted * 100.0));
            }
        }
        long timedOut = this.tasksTimedOut.get();
        if (submitted > 50L && (double)timedOut / (double)submitted > 0.05) {
            healthy = false;
            if (this.enableMonitoring) {
                this.plugin.getLogger().warning("WorkerPool health check failed: High timeout rate " + String.format("%.2f%%", (double)timedOut / (double)submitted * 100.0));
            }
        }
        this.isHealthy = healthy;
        return healthy;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void resetHealth() {
        this.isHealthy = true;
        this.lastError = null;
        if (this.enableMonitoring) {
            this.plugin.getLogger().info("WorkerPool health status reset");
        }
    }

    public WorkerPoolStats getStats() {
        return new WorkerPoolStats(this.tasksSubmitted.get(), this.tasksCompleted.get(), this.tasksRejected.get(), this.tasksFailed.get(), this.tasksTimedOut.get(), this.threadPool.getActiveCount(), this.threadPool.getPoolSize(), this.threadPool.getMaximumPoolSize(), this.workQueue.size(), this.maxQueueSize, this.isHealthy, this.lastError, this.lastTaskSubmissionTime, this.lastTaskCompletionTime);
    }

    public void resetStats() {
        this.tasksSubmitted.set(0L);
        this.tasksCompleted.set(0L);
        this.tasksRejected.set(0L);
        this.tasksFailed.set(0L);
        this.tasksTimedOut.set(0L);
        this.lastTaskSubmissionTime = 0L;
        this.lastTaskCompletionTime = 0L;
        this.resetHealth();
        if (this.enableMonitoring) {
            this.plugin.getLogger().info("WorkerPool statistics reset");
        }
    }

    public void shutdown() {
        this.plugin.getLogger().info("Shutting down Kinetic worker pool...");
        this.executor.shutdown();
        this.scheduler.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.plugin.getLogger().warning("Worker pool did not terminate gracefully, forcing shutdown...");
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.plugin.getLogger().severe("Worker pool did not terminate after forced shutdown!");
                }
            }
            if (!this.scheduler.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.plugin.getLogger().info("Kinetic worker pool shut down complete.");
    }

    private static class WorkerThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private WorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Kinetic-Worker-" + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            t.setPriority(4);
            return t;
        }
    }

    private class EnhancedRejectionHandler
    implements RejectedExecutionHandler {
        private EnhancedRejectionHandler() {
        }

        @Override
        public void rejectedExecution(final Runnable r, ThreadPoolExecutor executor) {
            block5: {
                WorkerPool.this.tasksRejected.incrementAndGet();
                WorkerPool.this.isHealthy = false;
                WorkerPool.this.lastError = "Task rejected - pool overloaded";
                if (WorkerPool.this.enableMonitoring) {
                    WorkerPool.this.plugin.getLogger().warning("Worker pool rejected task - queue full (" + WorkerPool.this.workQueue.size() + "/" + WorkerPool.this.maxQueueSize + "), active threads: " + WorkerPool.this.threadPool.getActiveCount() + "/" + WorkerPool.this.threadPool.getMaximumPoolSize());
                }
                if (WorkerPool.this.enableFallbackExecution) {
                    try {
                        if (WorkerPool.this.enableMonitoring) {
                            WorkerPool.this.plugin.getLogger().info("Executing rejected task on main thread as fallback");
                        }
                        new BukkitRunnable(){

                            public void run() {
                                block3: {
                                    try {
                                        r.run();
                                        if (WorkerPool.this.enableMonitoring) {
                                            WorkerPool.this.plugin.getLogger().fine("Fallback execution completed successfully");
                                        }
                                    }
                                    catch (Exception e) {
                                        WorkerPool.this.tasksFailed.incrementAndGet();
                                        if (!WorkerPool.this.enableMonitoring) break block3;
                                        WorkerPool.this.plugin.getLogger().log(Level.WARNING, "Fallback execution failed", e);
                                    }
                                }
                            }
                        }.runTask(WorkerPool.this.plugin);
                    }
                    catch (Exception e) {
                        if (!WorkerPool.this.enableMonitoring) break block5;
                        WorkerPool.this.plugin.getLogger().log(Level.SEVERE, "Failed to schedule fallback execution", e);
                    }
                }
            }
        }
    }

    public static class WorkerPoolStats {
        private final long tasksSubmitted;
        private final long tasksCompleted;
        private final long tasksRejected;
        private final long tasksFailed;
        private final long tasksTimedOut;
        private final int activeThreads;
        private final int poolSize;
        private final int maxPoolSize;
        private final int queueSize;
        private final int maxQueueSize;
        private final boolean isHealthy;
        private final String lastError;
        private final long lastTaskSubmissionTime;
        private final long lastTaskCompletionTime;

        public WorkerPoolStats(long tasksSubmitted, long tasksCompleted, long tasksRejected, long tasksFailed, long tasksTimedOut, int activeThreads, int poolSize, int maxPoolSize, int queueSize, int maxQueueSize, boolean isHealthy, String lastError, long lastTaskSubmissionTime, long lastTaskCompletionTime) {
            this.tasksSubmitted = tasksSubmitted;
            this.tasksCompleted = tasksCompleted;
            this.tasksRejected = tasksRejected;
            this.tasksFailed = tasksFailed;
            this.tasksTimedOut = tasksTimedOut;
            this.activeThreads = activeThreads;
            this.poolSize = poolSize;
            this.maxPoolSize = maxPoolSize;
            this.queueSize = queueSize;
            this.maxQueueSize = maxQueueSize;
            this.isHealthy = isHealthy;
            this.lastError = lastError;
            this.lastTaskSubmissionTime = lastTaskSubmissionTime;
            this.lastTaskCompletionTime = lastTaskCompletionTime;
        }

        public long getTasksSubmitted() {
            return this.tasksSubmitted;
        }

        public long getTasksCompleted() {
            return this.tasksCompleted;
        }

        public long getTasksRejected() {
            return this.tasksRejected;
        }

        public long getTasksFailed() {
            return this.tasksFailed;
        }

        public long getTasksTimedOut() {
            return this.tasksTimedOut;
        }

        public int getActiveThreads() {
            return this.activeThreads;
        }

        public int getPoolSize() {
            return this.poolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public boolean isHealthy() {
            return this.isHealthy;
        }

        public String getLastError() {
            return this.lastError;
        }

        public long getLastTaskSubmissionTime() {
            return this.lastTaskSubmissionTime;
        }

        public long getLastTaskCompletionTime() {
            return this.lastTaskCompletionTime;
        }

        public double getSuccessRate() {
            if (this.tasksSubmitted == 0L) {
                return 1.0;
            }
            return (double)this.tasksCompleted / (double)this.tasksSubmitted;
        }

        public double getRejectionRate() {
            if (this.tasksSubmitted == 0L) {
                return 0.0;
            }
            return (double)this.tasksRejected / (double)this.tasksSubmitted;
        }

        public double getFailureRate() {
            if (this.tasksSubmitted == 0L) {
                return 0.0;
            }
            return (double)this.tasksFailed / (double)this.tasksSubmitted;
        }

        public double getTimeoutRate() {
            if (this.tasksSubmitted == 0L) {
                return 0.0;
            }
            return (double)this.tasksTimedOut / (double)this.tasksSubmitted;
        }

        public double getQueueUtilization() {
            if (this.maxQueueSize == 0) {
                return 0.0;
            }
            return (double)this.queueSize / (double)this.maxQueueSize;
        }

        public long getTasksPending() {
            return this.tasksSubmitted - this.tasksCompleted;
        }

        public String toString() {
            return String.format("WorkerPoolStats{submitted=%d, completed=%d, rejected=%d, failed=%d, timedOut=%d, activeThreads=%d/%d, queue=%d/%d, success=%.2f%%, healthy=%s}", this.tasksSubmitted, this.tasksCompleted, this.tasksRejected, this.tasksFailed, this.tasksTimedOut, this.activeThreads, this.maxPoolSize, this.queueSize, this.maxQueueSize, this.getSuccessRate() * 100.0, this.isHealthy);
        }
    }
}

