/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.texboobcat.pufferLike.async.WorkerPool;
import org.texboobcat.pufferLike.engine.Action;
import org.texboobcat.pufferLike.engine.BudgetEngine;
import org.texboobcat.pufferLike.engine.HardFreezeService;
import org.texboobcat.pufferLike.engine.TickService;
import org.texboobcat.pufferLike.packets.PacketOptimizer;
import org.texboobcat.pufferLike.proximity.ProximityService;
import org.texboobcat.pufferLike.telemetry.StatsService;
import org.texboobcat.pufferLike.tools.StressTester;
import org.texboobcat.pufferLike.tracker.VisibilityCullingService;

public class PPCommand
implements CommandExecutor,
TabCompleter {
    private final Plugin plugin;
    private final ProximityService proximity;
    private final BudgetEngine budget;
    private final TickService tickService;
    private final StatsService stats;
    private final PacketOptimizer packetOptimizer;
    private final WorkerPool workerPool;
    private final StressTester stressTester;
    private final VisibilityCullingService visibilityService;
    private final HardFreezeService hardFreezeService;

    public PPCommand(Plugin plugin, ProximityService proximity, BudgetEngine budget, TickService tickService, StatsService stats, PacketOptimizer packetOptimizer, WorkerPool workerPool, StressTester stressTester, VisibilityCullingService visibilityService, HardFreezeService hardFreezeService) {
        this.plugin = plugin;
        this.proximity = proximity;
        this.budget = budget;
        this.tickService = tickService;
        this.stats = stats;
        this.packetOptimizer = packetOptimizer;
        this.workerPool = workerPool;
        this.stressTester = stressTester;
        this.visibilityService = visibilityService;
        this.hardFreezeService = hardFreezeService;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7eKinetic\u00a77: use \u00a7b/kinetic help\u00a77 for a list of commands.");
            return true;
        }
        var6_6 = sub = args[0].toLowerCase(Locale.ROOT);
        var7_7 = -1;
        switch (var6_6.hashCode()) {
            case 3198785: {
                if (!var6_6.equals("help")) break;
                var7_7 = 0;
                break;
            }
            case -891989580: {
                if (!var6_6.equals("stress")) break;
                var7_7 = 1;
                break;
            }
            case 1000796129: {
                if (!var6_6.equals("workerstats")) break;
                var7_7 = 2;
                break;
            }
            case 631127898: {
                if (!var6_6.equals("workerhealth")) break;
                var7_7 = 3;
                break;
            }
            case -1753888737: {
                if (!var6_6.equals("workercontrol")) break;
                var7_7 = 4;
                break;
            }
            case -58200798: {
                if (!var6_6.equals("tickstats")) break;
                var7_7 = 5;
                break;
            }
            case -2133005767: {
                if (!var6_6.equals("tickhealth")) break;
                var7_7 = 6;
                break;
            }
            case -1542686432: {
                if (!var6_6.equals("tickcontrol")) break;
                var7_7 = 7;
                break;
            }
            case 113498234: {
                if (!var6_6.equals("budgetstats")) break;
                var7_7 = 8;
                break;
            }
            case -1182315672: {
                if (!var6_6.equals("budgetentity")) break;
                var7_7 = 9;
                break;
            }
            case 106940336: {
                if (!var6_6.equals("probe")) break;
                var7_7 = 10;
                break;
            }
            case -1638221455: {
                if (!var6_6.equals("probeperiod")) break;
                var7_7 = 11;
                break;
            }
            case -934641255: {
                if (!var6_6.equals("reload")) break;
                var7_7 = 12;
                break;
            }
            case 113762: {
                if (!var6_6.equals("set")) break;
                var7_7 = 13;
                break;
            }
            case 1399412055: {
                if (!var6_6.equals("worldbudget")) break;
                var7_7 = 14;
                break;
            }
            case 266418688: {
                if (!var6_6.equals("playerexempt")) break;
                var7_7 = 15;
                break;
            }
            case -892481550: {
                if (!var6_6.equals("status")) break;
                var7_7 = 16;
                break;
            }
            case 1768153062: {
                if (!var6_6.equals("trackerinfo")) break;
                var7_7 = 17;
                break;
            }
            case 795791724: {
                if (!var6_6.equals("heatmap")) break;
                var7_7 = 18;
                break;
            }
            case -807058197: {
                if (!var6_6.equals("packets")) break;
                var7_7 = 19;
            }
        }
        switch (var7_7) {
            case 0: {
                sender.sendMessage("\u00a76Kinetic commands:");
                sender.sendMessage("\u00a77- \u00a7b/kinetic help\u00a77 \u2014 show this help");
                sender.sendMessage("\u00a77- \u00a7b/kinetic status\u00a77 \u2014 module counters and TPS snapshot");
                sender.sendMessage("\u00a77- \u00a7b/kinetic probe \u00a7f[player|@nearest]\u00a77 \u2014 nearest-player distance at a location");
                sender.sendMessage("\u00a77- \u00a7b/kinetic probeperiod \u00a7f<ACTION> [player]\u00a77 \u2014 compute DAB period for an action");
                sender.sendMessage("\u00a77- \u00a7b/kinetic workerstats\u00a77 \u2014 async worker pool stats \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic workerhealth \u00a7f<check|reset>\u00a77 \u2014 worker pool health management \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic workercontrol \u00a7f<resetstats|pause|resume>\u00a77 \u2014 worker pool control \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic tickstats\u00a77 \u2014 server tick service statistics \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic tickhealth \u00a7f<check|reset>\u00a77 \u2014 tick service health management \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic tickcontrol \u00a7f<resetstats|restart>\u00a77 \u2014 tick service control \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic budgetstats \u00a7f[world]\u00a77 \u2014 DAB engine stats \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic budgetentity \u00a7f[player]\u00a77 \u2014 per-entity budget info");
                sender.sendMessage("\u00a77- \u00a7b/kinetic packets \u00a7f<on|off>\u00a77 \u2014 toggle packet optimizer \u00a78(perm: kinetic.packets)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic heatmap \u00a7f[limit]\u00a77 or \u00a7bexport [limit]\u00a77 \u2014 chunk suppression report \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic trackerinfo\u00a77 \u2014 visibility/hard-freeze info \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic reload\u00a77 \u2014 reload config \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic set \u00a7f<path> <value>\u00a77 \u2014 live-tune config \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic worldbudget \u00a7f<world> [budget]\u00a77 \u2014 manage per-world budgets \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic playerexempt \u00a7f<add|remove|list|pattern> [player]\u00a77 \u2014 manage player exemptions \u00a78(perm: kinetic.admin)");
                sender.sendMessage("\u00a77- \u00a7b/kinetic stress \u00a7f<ai|particles|sounds|dab|visdense|path|snapshot|stop|status> ... \u00a78(perm: kinetic.admin)");
                return true;
            }
            case 1: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cRun stress commands in-game as a player.");
                    return true;
                }
                p = (Player)sender;
                if (args.length < 2) {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic stress ai <type> <count> <seconds> [radius]\u00a77 | \u00a7bparticles <bursts> <perBurst> [radius] [period]\u00a77 | \u00a7bsounds <bursts> <perBurst> [radius] [period]\u00a77 | \u00a7bdab <type> <perBand> <seconds> <r1,r2,...>\u00a77 | \u00a7bvisdense <type> <count> <radius> <seconds>\u00a77 | \u00a7bpath <radius> <seconds> [periodTicks]\u00a77 | \u00a7bsnapshot\u00a77 | \u00a7bstop [all|ai|particles|sounds|dab-bands|vis-dense|move]\u00a77 | \u00a7bstatus");
                    return true;
                }
                mode = args[1].toLowerCase(Locale.ROOT);
                try {
                    var10_50 = mode;
                    var11_71 = -1;
                    switch (var10_50.hashCode()) {
                        case 3112: {
                            if (!var10_50.equals("ai")) break;
                            var11_71 = 0;
                            break;
                        }
                        case 3433509: {
                            if (!var10_50.equals("path")) break;
                            var11_71 = 1;
                            break;
                        }
                        case -1800314195: {
                            if (!var10_50.equals("particles")) break;
                            var11_71 = 2;
                            break;
                        }
                        case -896509628: {
                            if (!var10_50.equals("sounds")) break;
                            var11_71 = 3;
                            break;
                        }
                        case 99205: {
                            if (!var10_50.equals("dab")) break;
                            var11_71 = 4;
                            break;
                        }
                        case 1579618047: {
                            if (!var10_50.equals("visdense")) break;
                            var11_71 = 5;
                            break;
                        }
                        case 284874180: {
                            if (!var10_50.equals("snapshot")) break;
                            var11_71 = 6;
                            break;
                        }
                        case 3540994: {
                            if (!var10_50.equals("stop")) break;
                            var11_71 = 7;
                            break;
                        }
                        case -892481550: {
                            if (!var10_50.equals("status")) break;
                            var11_71 = 8;
                        }
                    }
                    switch (var11_71) {
                        case 0: {
                            if (args.length < 5) {
                                sender.sendMessage("\u00a77Usage: \u00a7b/kinetic stress ai <type> <count> <seconds> [radius]");
                                return true;
                            }
                            type = EntityType.valueOf((String)args[2].toUpperCase(Locale.ROOT));
                            count = Integer.parseInt(args[3]);
                            seconds = Integer.parseInt(args[4]);
                            radius = args.length >= 6 ? Double.parseDouble(args[5]) : 16.0;
                            this.stressTester.startAiSwarm(p, type, count, seconds, radius);
                            sender.sendMessage("\u00a7a[stress]\u00a77 AI swarm started for \u00a7b" + seconds + "\u00a77s.");
                            break;
                        }
                        case 1: {
                            if (args.length < 4) {
                                sender.sendMessage("\u00a77Usage: \u00a7b/kinetic stress path <radius> <seconds> [periodTicks]");
                                return true;
                            }
                            radius = Double.parseDouble(args[2]);
                            seconds = Integer.parseInt(args[3]);
                            period = args.length >= 5 ? Integer.parseInt(args[4]) : 5;
                            this.stressTester.startMovePath(p, radius, seconds, period);
                            sender.sendMessage("\u00a7a[stress]\u00a77 moving path started for \u00a7b" + seconds + "\u00a77s.");
                            break;
                        }
                        case 2: {
                            if (args.length < 4) {
                                sender.sendMessage("\u00a77Usage: \u00a7b/kinetic stress particles <bursts> <perBurst> [radius] [periodTicks]");
                                return true;
                            }
                            bursts = Integer.parseInt(args[2]);
                            perBurst = Integer.parseInt(args[3]);
                            radius = args.length >= 5 ? Double.parseDouble(args[4]) : 12.0;
                            period = args.length >= 6 ? Integer.parseInt(args[5]) : 10;
                            this.stressTester.startParticleBursts(p, bursts, perBurst, radius, period);
                            sender.sendMessage("\u00a7a[stress]\u00a77 particle bursts scheduled.");
                            break;
                        }
                        case 3: {
                            if (args.length < 4) {
                                sender.sendMessage("\u00a77Usage: \u00a7b/kinetic stress sounds <bursts> <perBurst> [radius] [periodTicks]");
                                return true;
                            }
                            bursts = Integer.parseInt(args[2]);
                            perBurst = Integer.parseInt(args[3]);
                            radius = args.length >= 5 ? Double.parseDouble(args[4]) : 12.0;
                            period = args.length >= 6 ? Integer.parseInt(args[5]) : 10;
                            this.stressTester.startSoundBursts(p, bursts, perBurst, radius, period);
                            sender.sendMessage("\u00a7a[stress]\u00a77 sound bursts scheduled.");
                            break;
                        }
                        case 4: {
                            if (args.length < 6) {
                                sender.sendMessage("\u00a77Usage: \u00a7b/kinetic stress dab <type> <perBand> <seconds> <r1,r2,...>");
                                return true;
                            }
                            type = EntityType.valueOf((String)args[2].toUpperCase(Locale.ROOT));
                            perBand = Integer.parseInt(args[3]);
                            seconds = Integer.parseInt(args[4]);
                            radii = new ArrayList<Double>();
                            for (String s : args[5].split(",")) {
                                try {
                                    radii.add(Double.parseDouble(s));
                                }
                                catch (NumberFormatException var20_152) {
                                    // empty catch block
                                }
                            }
                            if (radii.isEmpty()) {
                                sender.sendMessage("\u00a7cNo valid radii provided.");
                                return true;
                            }
                            this.stressTester.startDabBands(p, type, perBand, seconds, radii);
                            sender.sendMessage("\u00a7a[stress]\u00a77 DAB bands scheduled for \u00a7b" + seconds + "\u00a77s.");
                            break;
                        }
                        case 5: {
                            if (args.length < 6) {
                                sender.sendMessage("\u00a77Usage: \u00a7b/kinetic stress visdense <type> <count> <radius> <seconds>");
                                return true;
                            }
                            type = EntityType.valueOf((String)args[2].toUpperCase(Locale.ROOT));
                            count = Integer.parseInt(args[3]);
                            radius = Double.parseDouble(args[4]);
                            seconds = Integer.parseInt(args[5]);
                            this.stressTester.startVisibilityDense(p, type, count, radius, seconds);
                            sender.sendMessage("\u00a7a[stress]\u00a77 visibility dense scenario started for \u00a7b" + seconds + "\u00a77s.");
                            break;
                        }
                        case 6: {
                            outFile = new File(this.plugin.getDataFolder(), "tracker_snapshot.json");
                            outFile.getParentFile().mkdirs();
                            try {
                                fw = new FileWriter(outFile, false);
                                try {
                                    visEnabled = this.plugin.getConfig().getBoolean("tracker.visibility.enabled", false);
                                    hfEnabled = this.plugin.getConfig().getBoolean("dab.hard-freeze.enabled", false);
                                    fw.write("{\n");
                                    fw.write("  \"visibility\": {\n");
                                    fw.write("    \"enabled\": " + visEnabled + ",\n");
                                    if (this.visibilityService != null) {
                                        fw.write("    \"playersTracked\": " + this.visibilityService.getPlayersTrackedCount() + ",\n");
                                        fw.write("    \"hiddenSetSize\": " + this.visibilityService.getTotalHiddenCount() + ",\n");
                                        fw.write("    \"showOps\": " + this.visibilityService.getTotalShowOps() + ",\n");
                                        fw.write("    \"hideOps\": " + this.visibilityService.getTotalHideOps() + "\n");
                                    }
                                    fw.write("  },\n");
                                    fw.write("  \"hardFreeze\": {\n");
                                    fw.write("    \"enabled\": " + hfEnabled + ",\n");
                                    if (this.hardFreezeService != null) {
                                        fw.write("    \"aiFrozen\": " + this.hardFreezeService.getAiFrozenCount() + ",\n");
                                        fw.write("    \"aiUnfrozen\": " + this.hardFreezeService.getAiUnfrozenCount() + "\n");
                                    }
                                    fw.write("  }\n");
                                    fw.write("}\n");
                                }
                                finally {
                                    fw.close();
                                }
                            }
                            catch (IOException ioe) {
                                sender.sendMessage("\u00a7cFailed to write snapshot: " + ioe.getMessage());
                                return true;
                            }
                            sender.sendMessage("\u00a7aSnapshot written to \u00a7b" + outFile.getAbsolutePath());
                            break;
                        }
                        case 7: {
                            if (args.length >= 3) {
                                what = args[2].toLowerCase(Locale.ROOT);
                                if (what.equals("all")) {
                                    this.stressTester.stopAll();
                                } else {
                                    this.stressTester.stop(what);
                                }
                            } else {
                                this.stressTester.stopAll();
                            }
                            sender.sendMessage("\u00a7e[stress]\u00a77 stopped.");
                            break;
                        }
                        case 8: {
                            sender.sendMessage("\u00a7e[stress]\u00a77 running: ai=" + this.stressTester.hasRunning("ai") + ", particles=" + this.stressTester.hasRunning("particles") + ", sounds=" + this.stressTester.hasRunning("sounds") + ", dab-bands=" + this.stressTester.hasRunning("dab-bands") + ", vis-dense=" + this.stressTester.hasRunning("vis-dense") + ", move=" + this.stressTester.hasRunning("move"));
                            break;
                        }
                        default: {
                            sender.sendMessage("\u00a77Unknown stress mode. Use \u00a7bai|particles|sounds|dab|visdense|path|snapshot|stop|status");
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    sender.sendMessage("\u00a7cError: " + ex.getMessage());
                }
                return true;
            }
            case 2: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (this.workerPool == null) {
                    sender.sendMessage("\u00a7eWorker pool not initialized.");
                    return true;
                }
                s = this.workerPool.getStats();
                sender.sendMessage("\u00a7e=== WorkerPool Statistics ===");
                sender.sendMessage(String.format(Locale.US, "\u00a77Thread Pool: \u00a7b%d\u00a77/\u00a7b%d\u00a77 threads (\u00a7b%d\u00a77 active), queue: \u00a7b%d\u00a77/\u00a7b%d\u00a77 (\u00a7b%.1f%%\u00a77 full)", new Object[]{s.getPoolSize(), s.getMaxPoolSize(), s.getActiveThreads(), s.getQueueSize(), s.getMaxQueueSize(), s.getQueueUtilization() * 100.0}));
                sender.sendMessage(String.format(Locale.US, "\u00a77Tasks: \u00a7b%d\u00a77 submitted, \u00a7b%d\u00a77 completed (\u00a7b%.1f%%\u00a77 success rate)", new Object[]{s.getTasksSubmitted(), s.getTasksCompleted(), s.getSuccessRate() * 100.0}));
                sender.sendMessage(String.format(Locale.US, "\u00a77Failed: \u00a7c%d\u00a77 (\u00a7c%.1f%%\u00a77), Timed out: \u00a76%d\u00a77 (\u00a76%.1f%%\u00a77), Rejected: \u00a7c%d\u00a77 (\u00a7c%.1f%%\u00a77)", new Object[]{s.getTasksFailed(), s.getFailureRate() * 100.0, s.getTasksTimedOut(), s.getTimeoutRate() * 100.0, s.getTasksRejected(), s.getRejectionRate() * 100.0}));
                sender.sendMessage("\u00a77Health: " + (s.isHealthy() != false ? "\u00a7aHealthy" : "\u00a7cUnhealthy"));
                if (s.getLastError() != null) {
                    sender.sendMessage("\u00a77Last Error: \u00a7c" + s.getLastError());
                }
                now = System.currentTimeMillis();
                if (s.getLastTaskSubmissionTime() > 0L) {
                    sender.sendMessage("\u00a77Last Submission: \u00a7b" + (now - s.getLastTaskSubmissionTime()) + "ms ago");
                }
                if (s.getLastTaskCompletionTime() > 0L) {
                    sender.sendMessage("\u00a77Last Completion: \u00a7b" + (now - s.getLastTaskCompletionTime()) + "ms ago");
                }
                return true;
            }
            case 3: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (this.workerPool == null) {
                    sender.sendMessage("\u00a7eWorker pool not initialized.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic workerhealth <check|reset>");
                    return true;
                }
                now = action = args[1].toLowerCase(Locale.ROOT);
                ex = -1;
                switch (now.hashCode()) {
                    case 94627080: {
                        if (!now.equals("check")) break;
                        ex = 0;
                        break;
                    }
                    case 108404047: {
                        if (!now.equals("reset")) break;
                        ex = 1;
                    }
                }
                switch (ex) {
                    case 0: {
                        healthy = this.workerPool.performHealthCheck();
                        sender.sendMessage("\u00a7eWorkerPool Health Check:");
                        sender.sendMessage("\u00a77Status: " + (healthy != false ? "\u00a7aHealthy" : "\u00a7cUnhealthy"));
                        if (!healthy && this.workerPool.getLastError() != null) {
                            sender.sendMessage("\u00a77Issue: \u00a7c" + this.workerPool.getLastError());
                        }
                        stats = this.workerPool.getStats();
                        sender.sendMessage(String.format(Locale.US, "\u00a77Metrics: Success=\u00a7b%.1f%%\u00a77, Rejection=\u00a7c%.1f%%\u00a77, Timeout=\u00a76%.1f%%\u00a77", new Object[]{stats.getSuccessRate() * 100.0, stats.getRejectionRate() * 100.0, stats.getTimeoutRate() * 100.0}));
                        break;
                    }
                    case 1: {
                        this.workerPool.resetHealth();
                        sender.sendMessage("\u00a7aWorkerPool health status has been reset to healthy.");
                        break;
                    }
                    default: {
                        sender.sendMessage("\u00a77Usage: \u00a7b/kinetic workerhealth <check|reset>");
                    }
                }
                return true;
            }
            case 4: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (this.workerPool == null) {
                    sender.sendMessage("\u00a7eWorker pool not initialized.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic workercontrol <resetstats>");
                    return true;
                }
                now = action = args[1].toLowerCase(Locale.ROOT);
                ex = -1;
                switch (now.hashCode()) {
                    case -1657954128: {
                        if (!now.equals("resetstats")) break;
                        ex = 0;
                    }
                }
                switch (ex) {
                    case 0: {
                        this.workerPool.resetStats();
                        sender.sendMessage("\u00a7aWorkerPool statistics have been reset.");
                        break;
                    }
                    default: {
                        sender.sendMessage("\u00a77Usage: \u00a7b/kinetic workercontrol <resetstats>");
                    }
                }
                return true;
            }
            case 5: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (this.tickService == null) {
                    sender.sendMessage("\u00a7eTickService not initialized.");
                    return true;
                }
                stats = this.tickService.getStats();
                sender.sendMessage("\u00a7e=== TickService Statistics ===");
                sender.sendMessage(String.format(Locale.US, "\u00a77Current Tick: \u00a7b%,d\u00a77 | Current TPS: \u00a7b%.2f\u00a77 | Health: %s", new Object[]{stats.getCurrentTick(), stats.getCurrentTPS(), stats.isHealthy() != false ? "\u00a7aHealthy" : "\u00a7cUnhealthy"}));
                sender.sendMessage(String.format(Locale.US, "\u00a77Total Ticks: \u00a7b%,d\u00a77 | Missed: \u00a7c%,d\u00a77 (\u00a7c%.3f%%\u00a77)", new Object[]{stats.getTotalTicks(), stats.getMissedTicks(), stats.getMissedTickRate()}));
                sender.sendMessage(String.format(Locale.US, "\u00a77Uptime: \u00a7b%d\u00a77s | Average TPS: \u00a7b%.2f", new Object[]{stats.getUptimeMs() / 1000L, stats.getAverageTPSOverUptime()}));
                sender.sendMessage("\u00a77Features: TPS Monitoring=" + (stats.isTpsMonitoringEnabled() != false ? "\u00a7aEnabled" : "\u00a7cDisabled") + "\u00a77, Health Checks=" + (stats.isHealthChecksEnabled() != false ? "\u00a7aEnabled" : "\u00a7cDisabled"));
                return true;
            }
            case 6: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (this.tickService == null) {
                    sender.sendMessage("\u00a7eTickService not initialized.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic tickhealth <check|reset>");
                    return true;
                }
                now = action = args[1].toLowerCase(Locale.ROOT);
                ex = -1;
                switch (now.hashCode()) {
                    case 94627080: {
                        if (!now.equals("check")) break;
                        ex = 0;
                        break;
                    }
                    case 108404047: {
                        if (!now.equals("reset")) break;
                        ex = 1;
                    }
                }
                switch (ex) {
                    case 0: {
                        healthy = this.tickService.isHealthy();
                        sender.sendMessage("\u00a7e=== TickService Health Check ===");
                        sender.sendMessage("\u00a77Status: " + (healthy != false ? "\u00a7aHealthy" : "\u00a7cUnhealthy"));
                        sender.sendMessage("\u00a77Current TPS: \u00a7b" + String.format("%.2f", new Object[]{this.tickService.getCurrentTPS()}));
                        sender.sendMessage("\u00a77TPS Healthy: " + (this.tickService.isTPSHealthy() != false ? "\u00a7aYes" : "\u00a7cNo"));
                        stats = this.tickService.getStats();
                        sender.sendMessage(String.format(Locale.US, "\u00a77Metrics: Missed Ticks=\u00a7c%,d\u00a77 (\u00a7c%.3f%%\u00a77), Uptime=\u00a7b%ds", new Object[]{stats.getMissedTicks(), stats.getMissedTickRate(), stats.getUptimeMs() / 1000L}));
                        break;
                    }
                    case 1: {
                        this.tickService.resetStats();
                        sender.sendMessage("\u00a7aTickService statistics and health status have been reset.");
                        break;
                    }
                    default: {
                        sender.sendMessage("\u00a77Usage: \u00a7b/kinetic tickhealth <check|reset>");
                    }
                }
                return true;
            }
            case 7: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (this.tickService == null) {
                    sender.sendMessage("\u00a7eTickService not initialized.");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic tickcontrol <resetstats|restart>");
                    return true;
                }
                now = action = args[1].toLowerCase(Locale.ROOT);
                ex = -1;
                switch (now.hashCode()) {
                    case -1657954128: {
                        if (!now.equals("resetstats")) break;
                        ex = 0;
                        break;
                    }
                    case 1097506319: {
                        if (!now.equals("restart")) break;
                        ex = 1;
                    }
                }
                switch (ex) {
                    case 0: {
                        this.tickService.resetStats();
                        sender.sendMessage("\u00a7aTickService statistics have been reset.");
                        break;
                    }
                    case 1: {
                        this.tickService.restart();
                        sender.sendMessage("\u00a7aTickService has been restarted.");
                        break;
                    }
                    default: {
                        sender.sendMessage("\u00a77Usage: \u00a7b/kinetic tickcontrol <resetstats|restart>");
                    }
                }
                return true;
            }
            case 8: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                bs = this.budget.getStatistics();
                v0 = worldFilter = args.length >= 2 ? args[1] : null;
                if (worldFilter != null && !worldFilter.isEmpty()) {
                    world = Bukkit.getWorld((String)worldFilter);
                    if (world == null) {
                        sender.sendMessage("\u00a7cWorld not found: " + worldFilter);
                        return true;
                    }
                    sender.sendMessage("\u00a7eBudgetEngine Stats for World \u00a7b" + worldFilter + "\u00a7e:");
                    worldBudget = bs.getPerWorldBudgets().get(worldFilter);
                    worldUsage = bs.getPerWorldBudgetUsed().get(worldFilter);
                    if (worldBudget != null) {
                        sender.sendMessage("\u00a77Per-world budget: \u00a7b" + (worldUsage != null ? worldUsage : 0) + "\u00a77/\u00a7b" + worldBudget);
                    } else {
                        sender.sendMessage("\u00a77No per-world budget (using shared budget)");
                    }
                    sender.sendMessage("\u00a77World action counts:");
                    for (Map.Entry<K, V> entry : ((Map)bs.getPerWorldActionCounts().getOrDefault(worldFilter, new EnumMap<Action, V>(Action.class))).entrySet()) {
                        throttled = ((Map)bs.getPerWorldThrottledCounts().getOrDefault(worldFilter, new EnumMap<Action, V>(Action.class))).getOrDefault(entry.getKey(), 0L);
                        ratio = (Long)entry.getValue() > 0L ? (double)throttled / (double)((Long)entry.getValue()).longValue() : 0.0;
                        sender.sendMessage("\u00a77- \u00a7b" + String.valueOf(entry.getKey()) + "\u00a77 total=\u00a7b" + String.valueOf(entry.getValue()) + "\u00a77 throttled=\u00a7b" + throttled + String.format(Locale.US, "\u00a77 ratio=\u00a7b%.2f%%", new Object[]{ratio * 100.0}));
                    }
                } else {
                    sender.sendMessage("\u00a7eBudgetEngine\u00a77: trackedEntities=\u00a7b" + bs.getTrackedEntities() + "\u00a77, currentBudgetUsed=\u00a7b" + bs.getCurrentBudgetUsed() + "\u00a77/\u00a7b" + bs.getMaxBudgetPerTick());
                    sender.sendMessage("\u00a77Player exemptions: \u00a7bnames=" + bs.getPlayerExemptionsByName().size() + "\u00a77, permissions=" + bs.getPlayerExemptionsByPermission().size() + "\u00a77, patterns=" + bs.getPlayerExemptionsByPattern().size());
                    sender.sendMessage("\u00a77Action counts:");
                    for (Map.Entry<Object, Number> entry : bs.getActionCounts().entrySet()) {
                        sender.sendMessage("\u00a77- \u00a7b" + String.valueOf((Object)entry.getKey()) + "\u00a77 total=\u00a7b" + String.valueOf(entry.getValue()) + "\u00a77 throttled=\u00a7b" + String.valueOf(bs.getThrottledCounts().getOrDefault((Object)entry.getKey(), 0L)) + String.format(Locale.US, "\u00a77 ratio=\u00a7b%.2f%%", new Object[]{bs.getThrottleRatio((Action)entry.getKey()) * 100.0}));
                    }
                    if (!bs.getPerWorldBudgets().isEmpty()) {
                        sender.sendMessage("\u00a77Per-world budgets:");
                        for (Map.Entry<Object, Number> entry : bs.getPerWorldBudgets().entrySet()) {
                            usage = bs.getPerWorldBudgetUsed().getOrDefault(entry.getKey(), 0);
                            sender.sendMessage("\u00a77- \u00a7b" + (String)entry.getKey() + "\u00a77: \u00a7b" + usage + "\u00a77/\u00a7b" + String.valueOf(entry.getValue()));
                        }
                    }
                }
                return true;
            }
            case 9: {
                target = null;
                if (args.length >= 2) {
                    target = Bukkit.getPlayerExact((String)args[1]);
                }
                if (target == null && sender instanceof Player) {
                    target = p = (Player)sender;
                }
                if (target == null) {
                    sender.sendMessage("\u00a7cSpecify a player or run in-game.");
                    return true;
                }
                info = this.budget.getEntityInfo((Entity)target);
                if (info.isExempt()) {
                    sender.sendMessage("\u00a7eBudgetEntity\u00a77: target is exempt.");
                    return true;
                }
                sender.sendMessage(String.format(Locale.US, "\u00a7eBudgetEntity\u00a77: distNearest=\u00a7b%.2f\u00a77, currentPeriod(PATHFIND)=\u00a7b%d", new Object[]{info.getDistanceToNearestPlayer(), info.getCurrentPeriod()}));
                now = Bukkit.getCurrentTick();
                idx = 0;
                for (Action a : Action.values()) {
                    next = info.getNextAllowedTicks()[idx++];
                    rem = Math.max(0L, next - now);
                    sender.sendMessage("\u00a77- \u00a7b" + String.valueOf((Object)a) + "\u00a77 next=\u00a7b" + next + "\u00a77 (in \u00a7b" + rem + "\u00a77 ticks)");
                }
                return true;
            }
            case 10: {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("Only players can use probe without a target.");
                    return true;
                }
                p = (Player)sender;
                if (args.length >= 2) {
                    targetArg = args[1];
                    if (targetArg.equalsIgnoreCase("@nearest")) {
                        nearest = this.findNearestEntity(p);
                        if (nearest == null) {
                            sender.sendMessage("\u00a77No nearby entities found.");
                            return true;
                        }
                        this.probeLocation(sender, nearest.getLocation(), "entity:" + String.valueOf(nearest.getType()));
                        return true;
                    }
                    target = Bukkit.getPlayerExact((String)targetArg);
                    if (target != null) {
                        this.probeLocation(sender, target.getLocation(), "player:" + target.getName());
                        return true;
                    }
                    sender.sendMessage("\u00a7cTarget not found: " + targetArg);
                    return true;
                }
                this.probeLocation(sender, p.getLocation(), "self");
                return true;
            }
            case 11: {
                if (args.length < 2) {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic probeperiod <ACTION> [player]\n\u00a77Actions: " + String.join((CharSequence)", ", this.actionNames()));
                    return true;
                }
                try {
                    action = Action.valueOf(args[1].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException ex) {
                    sender.sendMessage("\u00a7cUnknown action. Valid: " + String.join((CharSequence)", ", this.actionNames()));
                    return true;
                }
                target = null;
                if (args.length >= 3) {
                    target = Bukkit.getPlayerExact((String)args[2]);
                }
                if (target == null && sender instanceof Player) {
                    target = p = (Player)sender;
                }
                if (target == null) {
                    sender.sendMessage("\u00a7cYou must specify a player when using from console.");
                    return true;
                }
                period = this.budget.computeAllowedPeriod((Entity)target, action);
                next = this.budget.getNextAllowed((Entity)target, action);
                sender.sendMessage("\u00a7a[budget]\u00a77 action=\u00a7b" + String.valueOf((Object)action) + "\u00a77 period=\u00a7b" + period + "\u00a77 ticks, nextAllowedTick=\u00a7b" + next);
                return true;
            }
            case 12: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                this.plugin.reloadConfig();
                try {
                    this.budget.reloadConfiguration(this.plugin.getConfig());
                    sender.sendMessage("\u00a7aBudgetEngine configuration reloaded successfully.");
                }
                catch (Exception e) {
                    sender.sendMessage("\u00a7cFailed to reload BudgetEngine config: " + e.getMessage());
                }
                try {
                    if (this.packetOptimizer != null && this.packetOptimizer.isAvailable()) {
                        this.packetOptimizer.stop();
                        if (this.plugin.getConfig().getBoolean("packets.enabled", false)) {
                            this.packetOptimizer.start();
                        }
                    }
                }
                catch (Throwable t) {
                    sender.sendMessage("\u00a7cFailed to reload packets: " + t.getMessage());
                }
                sender.sendMessage("\u00a7aConfig reloaded (including BudgetEngine settings).");
                return true;
            }
            case 13: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic set <path> <value>");
                    return true;
                }
                path = args[1];
                value = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                parsed = value;
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                    parsed = Boolean.valueOf(value);
                } else {
                    try {
                        parsed = Integer.valueOf(value);
                    }
                    catch (NumberFormatException n1) {
                        try {
                            parsed = Double.valueOf(value);
                        }
                        catch (NumberFormatException n2) {
                            parsed = value;
                        }
                    }
                }
                existing = this.plugin.getConfig().get(path);
                if (existing == null) {
                    sender.sendMessage("\u00a7eWarning: Unknown config path \u00a7b" + path + "\u00a7e. Creating it.");
                } else if (existing instanceof Boolean != false && parsed instanceof Boolean == false || existing instanceof Integer != false && parsed instanceof Integer == false || existing instanceof Double != false && parsed instanceof Double == false || existing instanceof String && !(parsed instanceof String)) {
                    sender.sendMessage("\u00a7cType mismatch. Existing type is \u00a7b" + existing.getClass().getSimpleName() + "\u00a7c, but provided value looks like \u00a7b" + parsed.getClass().getSimpleName() + "\u00a7c. No change made.");
                    return true;
                }
                this.plugin.getConfig().set(path, parsed);
                this.plugin.saveConfig();
                sender.sendMessage("\u00a7aSet \u00a7b" + path + " \u00a77= \u00a7b" + value);
                if (path.equalsIgnoreCase("packets.enabled") && this.packetOptimizer != null && this.packetOptimizer.isAvailable()) {
                    try {
                        this.packetOptimizer.stop();
                        if (Boolean.parseBoolean(value)) {
                            this.packetOptimizer.start();
                        }
                    }
                    catch (Throwable t) {
                        sender.sendMessage("\u00a7cFailed to apply packets change: " + t.getMessage());
                    }
                }
                return true;
            }
            case 14: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic worldbudget <world> [budget]");
                    return true;
                }
                worldName = args[1];
                world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    sender.sendMessage("\u00a7cWorld not found: " + worldName);
                    return true;
                }
                if (args.length >= 3) {
                    try {
                        newBudget = Integer.parseInt(args[2]);
                        if (newBudget < 0) {
                            sender.sendMessage("\u00a7cBudget must be non-negative");
                            return true;
                        }
                        this.budget.setPerWorldBudget(worldName, newBudget);
                        sender.sendMessage("\u00a7aPer-world budget for \u00a7b" + worldName + "\u00a7a set to \u00a7b" + newBudget);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage("\u00a7cInvalid budget value: " + args[2]);
                    }
                } else {
                    stats = this.budget.getStatistics();
                    currentBudget = stats.getPerWorldBudgets().get(worldName);
                    currentUsage = stats.getPerWorldBudgetUsed().get(worldName);
                    if (currentBudget != null) {
                        sender.sendMessage("\u00a7ePer-world budget for \u00a7b" + worldName + "\u00a7e: \u00a7b" + currentUsage + "\u00a7e/\u00a7b" + currentBudget);
                    } else {
                        sender.sendMessage("\u00a7eNo per-world budget set for \u00a7b" + worldName + "\u00a7e (using shared budget)");
                    }
                }
                return true;
            }
            case 15: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic playerexempt <add|remove|list|pattern> [player]");
                    return true;
                }
                world = action = args[1].toLowerCase(Locale.ROOT);
                stats = -1;
                switch (world.hashCode()) {
                    case 96417: {
                        if (!world.equals("add")) break;
                        stats = 0;
                        break;
                    }
                    case -934610812: {
                        if (!world.equals("remove")) break;
                        stats = 1;
                        break;
                    }
                    case 3322014: {
                        if (!world.equals("list")) break;
                        stats = 2;
                        break;
                    }
                    case -791090288: {
                        if (!world.equals("pattern")) break;
                        stats = 3;
                    }
                }
                switch (stats) {
                    case 0: {
                        if (args.length < 3) {
                            sender.sendMessage("\u00a77Usage: \u00a7b/kinetic playerexempt add <player>");
                            return true;
                        }
                        playerName = args[2];
                        this.budget.addPlayerExemption(playerName);
                        sender.sendMessage("\u00a7aAdded player exemption for \u00a7b" + playerName);
                        break;
                    }
                    case 1: {
                        if (args.length < 3) {
                            sender.sendMessage("\u00a77Usage: \u00a7b/kinetic playerexempt remove <player>");
                            return true;
                        }
                        playerName = args[2];
                        if (this.budget.removePlayerExemption(playerName)) {
                            sender.sendMessage("\u00a7aRemoved player exemption for \u00a7b" + playerName);
                            break;
                        }
                        sender.sendMessage("\u00a7cPlayer exemption not found for \u00a7b" + playerName);
                        break;
                    }
                    case 2: {
                        stats = this.budget.getStatistics();
                        sender.sendMessage("\u00a7ePlayer Exemptions:");
                        sender.sendMessage("\u00a77Name exemptions: \u00a7b" + String.valueOf(stats.getPlayerExemptionsByName()));
                        sender.sendMessage("\u00a77Permission exemptions: \u00a7b" + String.valueOf(stats.getPlayerExemptionsByPermission()));
                        sender.sendMessage("\u00a77Pattern exemptions: \u00a7b" + String.valueOf(stats.getPlayerExemptionsByPattern()));
                        break;
                    }
                    case 3: {
                        if (args.length < 4) {
                            sender.sendMessage("\u00a77Usage: \u00a7b/kinetic playerexempt pattern <add|remove> <regex>");
                            return true;
                        }
                        patternAction = args[2].toLowerCase(Locale.ROOT);
                        pattern = args[3];
                        if (patternAction.equals("add")) {
                            try {
                                this.budget.addPlayerExemptionPattern(pattern);
                                sender.sendMessage("\u00a7aAdded player exemption pattern: \u00a7b" + pattern);
                            }
                            catch (Exception e) {
                                sender.sendMessage("\u00a7cInvalid regex pattern: " + e.getMessage());
                            }
                            break;
                        }
                        if (patternAction.equals("remove")) {
                            if (this.budget.removePlayerExemptionPattern(pattern)) {
                                sender.sendMessage("\u00a7aRemoved player exemption pattern: \u00a7b" + pattern);
                                break;
                            }
                            sender.sendMessage("\u00a7cPattern not found: \u00a7b" + pattern);
                            break;
                        }
                        sender.sendMessage("\u00a77Usage: \u00a7b/kinetic playerexempt pattern <add|remove> <regex>");
                        break;
                    }
                    default: {
                        sender.sendMessage("\u00a77Usage: \u00a7b/kinetic playerexempt <add|remove|list|pattern> [player]");
                    }
                }
                return true;
            }
            case 16: {
                sender.sendMessage("\u00a7eKinetic\u00a77: Proximity cache active. CellSize=\u00a7b" + this.getConfigInt("proximity.cell-size", 32) + "\u00a77, NeighborRadiusCells=\u00a7b" + this.getConfigInt("proximity.neighbor-radius-cells", 2));
                tps = Bukkit.getServer().getTPS();
                tps1m = tps != null && tps.length > 1 ? tps[1] : 20.0;
                sender.sendMessage(String.format("\u00a77TPS(1m)=\u00a7b%.2f", new Object[]{tps1m}));
                sender.sendMessage("\u00a77Counters: pathfindCancelled=\u00a7b" + this.stats.get("pathfindCancelled") + "\u00a77, targetDenied=\u00a7b" + this.stats.get("targetDenied") + "\u00a77, piglinAngerGated=\u00a7b" + this.stats.get("piglinAngerGated") + "\u00a77, breedDeferred=\u00a7b" + this.stats.get("breedDeferred") + "\u00a77, transformDeferred=\u00a7b" + this.stats.get("transformDeferred") + "\u00a77, spawnsDenied=\u00a7b" + this.stats.get("spawnsDenied") + "\u00a77, itemMerged=\u00a7b" + this.stats.get("itemMerged") + "\u00a77, xpMerged=\u00a7b" + this.stats.get("xpMerged") + "\u00a77, blockPhysicsSmoothed=\u00a7b" + this.stats.get("blockPhysicsSmoothed") + "\u00a77, redstoneSmoothed=\u00a7b" + this.stats.get("redstoneSmoothed") + "\u00a77, pistonsLimited=\u00a7b" + this.stats.get("pistonsLimited") + "\u00a77, fluidsThrottled=\u00a7b" + this.stats.get("fluidsThrottled") + "\u00a77, leavesDeferred=\u00a7b" + this.stats.get("leavesDeferred") + "\u00a77, growthDeferred=\u00a7b" + this.stats.get("growthDeferred") + "\u00a77, hopperBatched=\u00a7b" + this.stats.get("hopperBatched") + "\u00a77, packetsSuppressed=\u00a7b" + this.stats.get("packetsSuppressed") + "\u00a77 [sounds=\u00a7b" + this.stats.get("packetsSuppressed.sounds") + "\u00a77, particles=\u00a7b" + this.stats.get("packetsSuppressed.particles") + "\u00a77, metadata=\u00a7b" + this.stats.get("packetsSuppressed.metadata") + "\u00a77, chunks=\u00a7b" + this.stats.get("packetsSuppressed.chunks") + "\u00a77, spawn=\u00a7b" + this.stats.get("packetsSuppressed.spawn") + "\u00a77]");
                pktEnabled = this.plugin.getConfig().getBoolean("packets.enabled", false);
                sender.sendMessage("\u00a77Packets module: \u00a7b" + (pktEnabled != false && this.packetOptimizer != null && this.packetOptimizer.isAvailable() != false ? "enabled" : "disabled") + "\u00a77 (ProtocolLib present=" + (this.packetOptimizer != null && this.packetOptimizer.isAvailable() != false) + ")");
                return true;
            }
            case 17: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                visEnabled = this.plugin.getConfig().getBoolean("tracker.visibility.enabled", false);
                visRadius = this.plugin.getConfig().getDouble("tracker.visibility.radius", 96.0);
                sender.sendMessage("\u00a7eTracker Visibility\u00a77: enabled=\u00a7b" + visEnabled + "\u00a77, radius=\u00a7b" + String.format(Locale.US, "%.1f", new Object[]{visRadius}));
                if (this.visibilityService != null) {
                    sender.sendMessage("\u00a77- playersTracked=\u00a7b" + this.visibilityService.getPlayersTrackedCount() + "\u00a77, hiddenSetSize=\u00a7b" + this.visibilityService.getTotalHiddenCount() + "\u00a77, showOps=\u00a7b" + this.visibilityService.getTotalShowOps() + "\u00a77, hideOps=\u00a7b" + this.visibilityService.getTotalHideOps());
                }
                hfEnabled = this.plugin.getConfig().getBoolean("dab.hard-freeze.enabled", false);
                hfDist = this.plugin.getConfig().getDouble("dab.hard-freeze.min-player-distance", 64.0);
                fovEnabled = this.plugin.getConfig().getBoolean("dab.hard-freeze.fov.enabled", true);
                requireLos = this.plugin.getConfig().getBoolean("dab.hard-freeze.fov.require-los", true);
                sender.sendMessage("\u00a7eHard Freeze\u00a77: enabled=\u00a7b" + hfEnabled + "\u00a77, minDist=\u00a7b" + String.format(Locale.US, "%.1f", new Object[]{hfDist}) + "\u00a77, FOV=\u00a7b" + fovEnabled + "\u00a77 (LOS=" + requireLos + ")");
                if (this.hardFreezeService != null) {
                    sender.sendMessage("\u00a77- aiFrozen=\u00a7b" + this.hardFreezeService.getAiFrozenCount() + "\u00a77, aiUnfrozen=\u00a7b" + this.hardFreezeService.getAiUnfrozenCount());
                }
                v1 = pktHideFar = this.plugin.getConfig().getBoolean("packets.enabled", false) != false && this.plugin.getConfig().getBoolean("packets.hide-far-entities.enabled", true) != false;
                if (pktHideFar && visEnabled) {
                    sender.sendMessage("\u00a7eGuard: \u00a7cBoth packets.hide-far-entities and tracker.visibility are enabled; may conflict (double-hiding). Consider disabling one.");
                }
                return true;
            }
            case 18: {
                if (!sender.hasPermission("kinetic.admin")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.admin");
                    return true;
                }
                if (this.packetOptimizer == null) {
                    sender.sendMessage("\u00a7ePacket optimizer not available.");
                    return true;
                }
                if (args.length < 2 || !args[1].equalsIgnoreCase("export")) ** GOTO lbl798
                limit = 50;
                if (args.length >= 3) {
                    try {
                        limit = Math.max(1, Integer.parseInt(args[2]));
                    }
                    catch (NumberFormatException visRadius) {
                        // empty catch block
                    }
                }
                entries = this.packetOptimizer.getTopChunkSuppressionEntries(limit);
                outFile = new File(this.plugin.getDataFolder(), "heatmap.json");
                outFile.getParentFile().mkdirs();
                try {
                    fw = new FileWriter(outFile, false);
                    try {
                        fw.write("[\n");
                        for (i = 0; i < entries.size(); ++i) {
                            e = entries.get(i);
                            fw.write(String.format(Locale.US, "  {\"world\":\"%s\",\"cx\":%d,\"cz\":%d,\"count\":%d}%s\n", new Object[]{e.world.replace("\"", "\\\""), e.cx, e.cz, e.count, i + 1 < entries.size() ? "," : ""}));
                        }
                        fw.write("]\n");
                    }
                    finally {
                        fw.close();
                    }
                }
                catch (IOException ioe) {
                    sender.sendMessage("\u00a7cFailed to write heatmap: " + ioe.getMessage());
                    return true;
                }
                sender.sendMessage("\u00a7aHeatmap exported to \u00a7b" + outFile.getAbsolutePath());
                return true;
lbl798:
                // 1 sources

                limit = 10;
                if (args.length >= 2) {
                    try {
                        limit = Math.max(1, Integer.parseInt(args[1]));
                    }
                    catch (NumberFormatException entries) {
                        // empty catch block
                    }
                }
                if ((top = this.packetOptimizer.getTopChunkSuppressions(limit)).isEmpty()) {
                    sender.sendMessage("\u00a77No chunk suppressions recorded.");
                } else {
                    sender.sendMessage("\u00a7eTop chunk suppressions:");
                    for (String line : top) {
                        sender.sendMessage("\u00a77- \u00a7b" + line);
                    }
                }
                return true;
            }
            case 19: {
                if (!sender.hasPermission("kinetic.packets")) {
                    sender.sendMessage("\u00a7cYou lack permission: kinetic.packets");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic packets <on|off>");
                    return true;
                }
                mode = args[1].toLowerCase(Locale.ROOT);
                if (mode.equals("on")) {
                    enable = true;
                } else if (mode.equals("off")) {
                    enable = false;
                } else {
                    sender.sendMessage("\u00a77Usage: \u00a7b/kinetic packets <on|off>");
                    return true;
                }
                this.plugin.getConfig().set("packets.enabled", (Object)enable);
                this.plugin.saveConfig();
                if (this.packetOptimizer != null && this.packetOptimizer.isAvailable()) {
                    try {
                        this.packetOptimizer.stop();
                        if (enable) {
                            this.packetOptimizer.start();
                        }
                        sender.sendMessage("\u00a7aPackets module " + (enable != false ? "enabled" : "disabled") + ".");
                    }
                    catch (Throwable t) {
                        sender.sendMessage("\u00a7cFailed to toggle packets: " + t.getMessage());
                    }
                } else {
                    sender.sendMessage("\u00a7eProtocolLib not present; packets module requires it.");
                }
                return true;
            }
        }
        sender.sendMessage("\u00a77Unknown subcommand. Try \u00a7b/kinetic help\u00a77");
        return true;
    }

    private int getConfigInt(String path, int def) {
        return this.plugin.getConfig().getInt(path, def);
    }

    private void probeLocation(CommandSender sender, Location at, String label) {
        OptionalDouble dist = this.proximity.nearestPlayerDistance(at);
        int neighbors = this.proximity.onlinePlayersInNeighborCells(at);
        if (dist.isPresent()) {
            sender.sendMessage("\u00a7a[probe]\u00a77 at \u00a7f" + label + "\u00a77 nearest-player=\u00a7b" + String.format(Locale.US, "%.2f", dist.getAsDouble()) + "\u00a77 blocks, neighbor-cells player count=\u00a7b" + neighbors);
        } else {
            sender.sendMessage("\u00a7a[probe]\u00a77 at \u00a7f" + label + "\u00a77 nearest-player=\u00a7bnone\u00a77, neighbor-cells player count=\u00a7b" + neighbors);
        }
    }

    @Nullable
    private Entity findNearestEntity(Player p) {
        double best = Double.POSITIVE_INFINITY;
        Entity bestE = null;
        for (Entity e : p.getNearbyEntities(32.0, 16.0, 32.0)) {
            double d = e.getLocation().distanceSquared(p.getLocation());
            if (!(d < best)) continue;
            best = d;
            bestE = e;
        }
        return bestE;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            List<String> base = List.of("help", "probe", "probeperiod", "status", "trackerinfo", "packets", "heatmap", "reload", "set", "workerstats", "workerhealth", "workercontrol", "tickstats", "tickhealth", "tickcontrol", "budgetstats", "budgetentity", "worldbudget", "playerexempt", "stress");
            return base.stream().filter(s -> s.startsWith(args[0].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("probe")) {
            ArrayList<String> res = new ArrayList<String>();
            res.add("@nearest");
            for (Player p : Bukkit.getOnlinePlayers()) {
                res.add(p.getName());
            }
            return res.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("budgetentity")) {
            ArrayList<String> res = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                res.add(p.getName());
            }
            return res.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("workerhealth")) {
            return List.of("check", "reset").stream().filter(s -> s.startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("workercontrol")) {
            return List.of("resetstats").stream().filter(s -> s.startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("tickhealth")) {
            return List.of("check", "reset").stream().filter(s -> s.startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("tickcontrol")) {
            return List.of("resetstats", "restart").stream().filter(s -> s.startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("stress")) {
            return List.of("ai", "particles", "sounds", "dab", "visdense", "path", "snapshot", "stop", "status").stream().filter(s -> s.startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("stress")) {
            String mode = args[1].toLowerCase(Locale.ROOT);
            if (mode.equals("ai")) {
                ArrayList<String> types = new ArrayList<String>();
                for (EntityType t : EntityType.values()) {
                    if (!t.isSpawnable() || !t.isAlive()) continue;
                    types.add(t.name().toLowerCase(Locale.ROOT));
                }
                return types.stream().filter(s -> s.startsWith(args[2].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
            if (mode.equals("dab") || mode.equals("visdense")) {
                ArrayList<String> types = new ArrayList<String>();
                for (EntityType t : EntityType.values()) {
                    if (!t.isSpawnable() || !t.isAlive()) continue;
                    types.add(t.name().toLowerCase(Locale.ROOT));
                }
                return types.stream().filter(s -> s.startsWith(args[2].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
            if (mode.equals("stop")) {
                return List.of("all", "ai", "particles", "sounds", "dab-bands", "vis-dense", "move").stream().filter(s -> s.startsWith(args[2].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
        } else {
            if (args.length == 2 && args[0].equalsIgnoreCase("heatmap")) {
                return List.of("export").stream().filter(s -> s.startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("heatmap") && args[1].equalsIgnoreCase("export")) {
                return List.of("10", "25", "50", "100").stream().filter(s -> s.startsWith(args[2].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("packets")) {
                return List.of("on", "off").stream().filter(s -> s.startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("set")) {
                return List.of("packets.enabled", "packets.hide-far-entities.max-distance", "packets.sound-throttle.max-per-tick", "packets.particle-throttle.max-per-cluster", "packets.chunk-streaming.max-per-tick", "packets.chunk-streaming.prioritize-player-heading", "packets.metadata-rate-limit.enabled", "packets.metadata-rate-limit.interval-ticks").stream().filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("probeperiod")) {
                return this.actionNames().stream().filter(s -> s.startsWith(args[1].toUpperCase(Locale.ROOT))).collect(Collectors.toList());
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("probeperiod")) {
                ArrayList<String> res = new ArrayList<String>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    res.add(p.getName());
                }
                return res.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[2].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("worldbudget")) {
                ArrayList<String> worlds = new ArrayList<String>();
                for (World world : Bukkit.getWorlds()) {
                    worlds.add(world.getName());
                }
                return worlds.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("worldbudget")) {
                return List.of("10", "25", "50", "100", "200").stream().filter(s -> s.startsWith(args[2])).collect(Collectors.toList());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("playerexempt")) {
                return List.of("add", "remove", "list", "pattern").stream().filter(s -> s.startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("playerexempt")) {
                String action = args[1].toLowerCase(Locale.ROOT);
                if (action.equals("add") || action.equals("remove")) {
                    ArrayList<String> players = new ArrayList<String>();
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        players.add(p.getName());
                    }
                    return players.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[2].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
                }
                if (action.equals("pattern")) {
                    return List.of("add", "remove").stream().filter(s -> s.startsWith(args[2].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
                }
            } else if (args.length == 4 && args[0].equalsIgnoreCase("playerexempt") && args[1].equalsIgnoreCase("pattern")) {
                String patternAction = args[2].toLowerCase(Locale.ROOT);
                if (patternAction.equals("add")) {
                    return List.of("admin.*", "mod_.+", ".*_test", "vip\\\\d+").stream().filter(s -> s.startsWith(args[3])).collect(Collectors.toList());
                }
                if (patternAction.equals("remove")) {
                    return List.of("admin.*", "mod_.+").stream().filter(s -> s.startsWith(args[3])).collect(Collectors.toList());
                }
            } else if (args.length == 2 && args[0].equalsIgnoreCase("budgetstats")) {
                ArrayList<String> worlds = new ArrayList<String>();
                for (World world : Bukkit.getWorlds()) {
                    worlds.add(world.getName());
                }
                return worlds.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(args[1].toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
        }
        return List.of();
    }

    private List<String> actionNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Action a : Action.values()) {
            list.add(a.name());
        }
        return list;
    }
}

