/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.engine;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.texboobcat.pufferLike.proximity.ProximityService;
import org.texboobcat.pufferLike.util.Exemptions;

public class HardFreezeService {
    private final Plugin plugin;
    private final ProximityService proximity;
    private final Exemptions exemptions;
    private final FileConfiguration cfg;
    private final Deque<Iterator<Entity>> worldEntityIters = new ArrayDeque<Iterator<Entity>>();
    private boolean enabled;
    private double minFreezeDistance;
    private int maxEntitiesPerTick;
    private boolean fovEnabled;
    private double fovMaxDistance;
    private double fovCosHalfAngle;
    private boolean fovRequireLos;
    private boolean wakeOnDamageEnabled;
    private long wakeDurationMs;
    private final Map<UUID, Long> wakeUntilMs = new HashMap<UUID, Long>();
    private final Set<String> alwaysActiveTypes = new HashSet<String>();
    private long aiFrozen = 0L;
    private long aiUnfrozen = 0L;

    public HardFreezeService(Plugin plugin, ProximityService proximity, Exemptions exemptions, FileConfiguration cfg) {
        this.plugin = plugin;
        this.proximity = proximity;
        this.exemptions = exemptions;
        this.cfg = cfg;
        this.reload();
    }

    public void reload() {
        this.enabled = this.cfg.getBoolean("dab.hard-freeze.enabled", false);
        this.minFreezeDistance = this.cfg.getDouble("dab.hard-freeze.min-player-distance", 64.0);
        this.maxEntitiesPerTick = Math.max(50, this.cfg.getInt("dab.hard-freeze.max-entities-per-tick", 400));
        this.fovEnabled = this.cfg.getBoolean("dab.hard-freeze.fov.enabled", true);
        this.fovMaxDistance = Math.max(8.0, this.cfg.getDouble("dab.hard-freeze.fov.max-distance", 96.0));
        double fovDegrees = Math.max(10.0, Math.min(180.0, this.cfg.getDouble("dab.hard-freeze.fov.fov-degrees", 110.0)));
        this.fovCosHalfAngle = Math.cos(Math.toRadians(fovDegrees / 2.0));
        this.fovRequireLos = this.cfg.getBoolean("dab.hard-freeze.fov.require-los", true);
        this.wakeOnDamageEnabled = this.cfg.getBoolean("dab.hard-freeze.wake-on-damage.enabled", true);
        long ticks = Math.max(1L, this.cfg.getLong("dab.hard-freeze.wake-on-damage.duration-ticks", 80L));
        this.wakeDurationMs = ticks * 50L;
        this.alwaysActiveTypes.clear();
        for (String s : this.cfg.getStringList("dab.hard-freeze.always-active-types")) {
            this.alwaysActiveTypes.add(s.toUpperCase(Locale.ROOT));
        }
    }

    public void start() {
        this.resetWorldIterators();
        long period = Math.max(1L, this.cfg.getLong("dab.hard-freeze.recheck-period-ticks", 20L));
        Bukkit.getScheduler().runTaskTimer(this.plugin, this::tick, 40L, period);
        Bukkit.getPluginManager().registerEvents((Listener)new WakeListener(), this.plugin);
    }

    public void stop() {
    }

    private void resetWorldIterators() {
        this.worldEntityIters.clear();
        for (World w : Bukkit.getWorlds()) {
            this.worldEntityIters.add(w.getEntities().iterator());
        }
    }

    private void tick() {
        if (!this.enabled) {
            return;
        }
        int processed = 0;
        while (processed < this.maxEntitiesPerTick) {
            Mob mob;
            Iterator<Entity> it;
            if (this.worldEntityIters.isEmpty()) {
                this.resetWorldIterators();
                if (this.worldEntityIters.isEmpty()) {
                    return;
                }
            }
            if ((it = this.worldEntityIters.peekFirst()) == null) {
                return;
            }
            if (!it.hasNext()) {
                this.worldEntityIters.pollFirst();
                continue;
            }
            Entity e = it.next();
            if (!(e instanceof Mob) || !(mob = (Mob)e).isValid()) continue;
            if (!this.exemptions.isExempt((Entity)mob)) {
                double dist = this.proximity.nearestPlayerDistance((Entity)mob).orElse(Double.POSITIVE_INFINITY);
                if (this.alwaysActiveTypes.contains(mob.getType().name())) {
                    this.ensureAi(mob);
                    ++processed;
                    continue;
                }
                long nowMs = System.currentTimeMillis();
                Long until = this.wakeUntilMs.get(mob.getUniqueId());
                boolean temporarilyAwake = until != null && until > nowMs;
                boolean seenByPlayer = this.fovEnabled && this.isInAnyPlayerFov(mob);
                boolean shouldFreeze = dist > this.minFreezeDistance && !temporarilyAwake && !seenByPlayer;
                try {
                    if (shouldFreeze) {
                        if (mob.hasAI()) {
                            mob.setAI(false);
                            ++this.aiFrozen;
                        }
                    } else if (!mob.hasAI()) {
                        mob.setAI(true);
                        ++this.aiUnfrozen;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++processed;
        }
    }

    private void ensureAi(Mob mob) {
        try {
            if (!mob.hasAI()) {
                mob.setAI(true);
                ++this.aiUnfrozen;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isInAnyPlayerFov(Mob mob) {
        Location mobLoc = mob.getLocation();
        for (Player p : mob.getWorld().getNearbyPlayers(mobLoc, this.fovMaxDistance)) {
            Vector toMob;
            Vector view;
            double dot;
            if (!p.isOnline() || !((dot = (view = p.getEyeLocation().getDirection()).dot(toMob = mob.getEyeLocation().toVector().subtract(p.getEyeLocation().toVector()).normalize())) >= this.fovCosHalfAngle) || this.fovRequireLos && !p.hasLineOfSight((Entity)mob)) continue;
            return true;
        }
        return false;
    }

    public long getAiFrozenCount() {
        return this.aiFrozen;
    }

    public long getAiUnfrozenCount() {
        return this.aiUnfrozen;
    }

    private class WakeListener
    implements Listener {
        private WakeListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onDamage(EntityDamageByEntityEvent event) {
            if (!HardFreezeService.this.wakeOnDamageEnabled) {
                return;
            }
            Entity entity = event.getEntity();
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                this.wake(mob);
            }
            if ((entity = event.getDamager()) instanceof Monster) {
                Monster monster = (Monster)entity;
                this.wake((Mob)monster);
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onTarget(EntityTargetEvent event) {
            if (!HardFreezeService.this.wakeOnDamageEnabled) {
                return;
            }
            Entity entity = event.getEntity();
            if (entity instanceof Monster) {
                Monster monster = (Monster)entity;
                this.wake((Mob)monster);
            }
        }

        private void wake(Mob mob) {
            long until = System.currentTimeMillis() + HardFreezeService.this.wakeDurationMs;
            HardFreezeService.this.wakeUntilMs.put(mob.getUniqueId(), until);
            HardFreezeService.this.ensureAi(mob);
        }
    }
}

