/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.hologram;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class HologramService {
    private final Plugin plugin;
    private final Map<UUID, ArmorStand> stands = new ConcurrentHashMap<UUID, ArmorStand>();
    private BukkitTask pruneTask;
    private boolean itemsEnabled;
    private boolean xpEnabled;
    private boolean mobsEnabled;
    private double itemsOffset;
    private double xpOffset;
    private double mobsOffset;
    private String itemsFormat;
    private String xpFormat;
    private String mobsFormat;
    private String itemsStyle;
    private String xpStyle;
    private String mobsStyle;
    private Map<String, String> perMaterialFormats = new ConcurrentHashMap<String, String>();
    private Map<String, String> perEntityTypeFormats = new ConcurrentHashMap<String, String>();

    public HologramService(Plugin plugin, FileConfiguration cfg) {
        this.plugin = plugin;
        this.refreshConfig(cfg);
        this.startPruneTask();
    }

    public void refreshConfig(FileConfiguration cfg) {
        String fmt;
        this.itemsEnabled = cfg.getBoolean("merging.items.hologram.enabled", true);
        this.itemsOffset = cfg.getDouble("merging.items.hologram.offset", 0.75);
        this.itemsFormat = cfg.getString("merging.items.hologram.format", "x{amount}");
        this.itemsStyle = cfg.getString("merging.items.hologram.format-style", "plain");
        this.perMaterialFormats.clear();
        if (cfg.isConfigurationSection("merging.items.hologram.per-material")) {
            for (String key : cfg.getConfigurationSection("merging.items.hologram.per-material").getKeys(false)) {
                fmt = cfg.getString("merging.items.hologram.per-material." + key, null);
                if (fmt == null) continue;
                this.perMaterialFormats.put(key.toUpperCase(), fmt);
            }
        }
        this.xpEnabled = cfg.getBoolean("merging.xp.hologram.enabled", true);
        this.xpOffset = cfg.getDouble("merging.xp.hologram.offset", 0.75);
        this.xpFormat = cfg.getString("merging.xp.hologram.format", "{amount} xp");
        this.xpStyle = cfg.getString("merging.xp.hologram.format-style", "plain");
        this.mobsEnabled = cfg.getBoolean("merging.entities.hologram.enabled", true);
        this.mobsOffset = cfg.getDouble("merging.entities.hologram.offset", 0.75);
        this.mobsFormat = cfg.getString("merging.entities.hologram.format", "x{amount}");
        this.mobsStyle = cfg.getString("merging.entities.hologram.format-style", "plain");
        this.perEntityTypeFormats.clear();
        if (cfg.isConfigurationSection("merging.entities.hologram.per-type")) {
            for (String key : cfg.getConfigurationSection("merging.entities.hologram.per-type").getKeys(false)) {
                fmt = cfg.getString("merging.entities.hologram.per-type." + key, null);
                if (fmt == null) continue;
                this.perEntityTypeFormats.put(key.toUpperCase(), fmt);
            }
        }
    }

    public void clearAll() {
        for (ArmorStand as : this.stands.values()) {
            try {
                as.remove();
            }
            catch (Throwable throwable) {}
        }
        this.stands.clear();
    }

    public void shutdown() {
        if (this.pruneTask != null) {
            try {
                this.pruneTask.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pruneTask = null;
        }
        this.clearAll();
    }

    public void hide(Entity owner) {
        if (owner == null) {
            return;
        }
        ArmorStand as = this.stands.remove(owner.getUniqueId());
        if (as != null && !as.isDead()) {
            Bukkit.getScheduler().runTask(this.plugin, () -> ((ArmorStand)as).remove());
        }
    }

    public void showItem(Item item, int amount) {
        if (!this.itemsEnabled) {
            return;
        }
        if (amount <= 1) {
            this.hide((Entity)item);
            return;
        }
        String text = this.buildItemText(item.getItemStack(), amount);
        this.showOrUpdate((Entity)item, text, this.itemsOffset);
    }

    public void showXp(ExperienceOrb orb, int amount) {
        if (!this.xpEnabled) {
            return;
        }
        if (amount <= 1) {
            this.hide((Entity)orb);
            return;
        }
        String text = this.replaceCommon(this.xpFormat, amount, this.xpStyle).replace("{type}", "XP");
        this.showOrUpdate((Entity)orb, text, this.xpOffset);
    }

    public void showMob(LivingEntity le, int count) {
        if (!this.mobsEnabled) {
            return;
        }
        if (count <= 1) {
            this.hide((Entity)le);
            return;
        }
        String base = this.perEntityTypeFormats.getOrDefault(le.getType().name(), this.mobsFormat);
        String text = this.replaceCommon(base, count, this.mobsStyle).replace("{type}", this.prettyEnum(le.getType().name()));
        this.showOrUpdate((Entity)le, text, this.mobsOffset);
    }

    private void showOrUpdate(Entity owner, String text, double yOffset) {
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            ArmorStand as = this.stands.get(owner.getUniqueId());
            if (as == null || as.isDead() || !as.isValid()) {
                Location at = owner.getLocation().clone().add(0.0, Math.max(0.0, yOffset), 0.0);
                as = (ArmorStand)owner.getWorld().spawn(at, ArmorStand.class, s -> {
                    s.setMarker(true);
                    s.setInvisible(true);
                    s.setSmall(true);
                    s.setGravity(false);
                    s.setCustomNameVisible(true);
                });
                try {
                    owner.addPassenger((Entity)as);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.stands.put(owner.getUniqueId(), as);
            }
            try {
                as.setCustomName(text);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public void hideForPlayer(Player p, Entity owner) {
        if (p == null || owner == null) {
            return;
        }
        ArmorStand as = this.stands.get(owner.getUniqueId());
        if (as != null) {
            try {
                p.hideEntity(this.plugin, (Entity)as);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void showForPlayer(Player p, Entity owner) {
        if (p == null || owner == null) {
            return;
        }
        ArmorStand as = this.stands.get(owner.getUniqueId());
        if (as != null) {
            try {
                p.showEntity(this.plugin, (Entity)as);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String buildItemText(ItemStack stack, int amount) {
        String prettyMat;
        String materialKey = stack.getType().name();
        String fmt = this.perMaterialFormats.getOrDefault(materialKey, this.itemsFormat);
        String name = prettyMat = this.prettyEnum(materialKey);
        ItemMeta meta = stack.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            try {
                name = meta.getDisplayName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.replaceCommon(fmt, amount, this.itemsStyle).replace("{material}", prettyMat).replace("{name}", name);
    }

    private String replaceCommon(String fmt, int amount, String style) {
        return fmt.replace("{amount}", this.formatAmount(amount, style));
    }

    private String formatAmount(int amount, String style) {
        switch (style == null ? "plain" : style.toLowerCase()) {
            case "thousands": {
                NumberFormat nf = NumberFormat.getInstance(Locale.US);
                nf.setGroupingUsed(true);
                return nf.format(amount);
            }
            case "compact": {
                return this.compact(amount);
            }
        }
        return String.valueOf(amount);
    }

    private String compact(long n) {
        double v = n;
        String suffix = "";
        if (n >= 1000000000L) {
            v = (double)n / 1.0E9;
            suffix = "B";
        } else if (n >= 1000000L) {
            v = (double)n / 1000000.0;
            suffix = "M";
        } else if (n >= 1000L) {
            v = (double)n / 1000.0;
            suffix = "k";
        }
        if (suffix.isEmpty()) {
            return String.valueOf(n);
        }
        DecimalFormat df = new DecimalFormat("#.#");
        return df.format(v) + suffix;
    }

    private String prettyEnum(String name) {
        StringBuilder sb = new StringBuilder();
        for (String part : name.split("_")) {
            if (part.isEmpty()) continue;
            sb.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() > 1) {
                sb.append(part.substring(1).toLowerCase());
            }
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    private void startPruneTask() {
        this.pruneTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            for (Map.Entry<UUID, ArmorStand> e : this.stands.entrySet()) {
                ArmorStand as = e.getValue();
                if (as == null) {
                    this.stands.remove(e.getKey());
                    continue;
                }
                Entity vehicle = as.getVehicle();
                boolean orphan = as.isDead() || !as.isValid() || vehicle == null || vehicle.isDead() || !vehicle.isValid();
                if (!orphan) continue;
                try {
                    as.remove();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.stands.remove(e.getKey());
            }
        }, 200L, 200L);
    }
}

