/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.hoppers;

import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Hopper;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.InventoryHolder;
import org.texboobcat.pufferLike.engine.TickService;
import org.texboobcat.pufferLike.performance.SharedBudgetService;
import org.texboobcat.pufferLike.telemetry.StatsService;

public class HopperCoordinatorListener
implements Listener {
    private final FileConfiguration cfg;
    private final TickService ticks;
    private final SharedBudgetService budget;
    private final StatsService stats;
    private final Map<Location, Long> lastMoveTick = new WeakHashMap<Location, Long>();

    public HopperCoordinatorListener(FileConfiguration cfg, TickService ticks, SharedBudgetService budget, StatsService stats) {
        this.cfg = cfg;
        this.ticks = ticks;
        this.budget = budget;
        this.stats = stats;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryMove(InventoryMoveItemEvent e) {
        if (!this.cfg.getBoolean("hoppers.enabled", true)) {
            return;
        }
        long now = this.ticks.currentTick();
        int window = Math.max(0, this.cfg.getInt("hoppers.batch-window-ticks", 4));
        InventoryHolder srcHolder = e.getSource().getHolder();
        Location hopperLoc = this.holderToHopperLocation(srcHolder);
        if (hopperLoc != null && window > 0) {
            Long last = this.lastMoveTick.get(hopperLoc);
            if (last != null && now - last < (long)window) {
                e.setCancelled(true);
                this.stats.increment("hopperBatched");
                return;
            }
            this.lastMoveTick.put(hopperLoc, now);
        }
        if (!this.budget.tryConsume("HOPPERS", 1)) {
            e.setCancelled(true);
            this.stats.increment("hopperBatched");
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHopperPickup(InventoryPickupItemEvent e) {
        int window;
        if (!this.cfg.getBoolean("hoppers.enabled", true)) {
            return;
        }
        if (!this.budget.tryConsume("HOPPERS", 1)) {
            e.setCancelled(true);
            this.stats.increment("hopperBatched");
            return;
        }
        double radius = Math.max(0.1, this.cfg.getDouble("hoppers.pickup-scan-radius", 1.0));
        InventoryHolder invHolder = e.getInventory().getHolder();
        if (invHolder instanceof Hopper) {
            double distSq;
            Location hLoc;
            Hopper hop = (Hopper)invHolder;
            Location location = hLoc = hop.getBlock() != null ? hop.getBlock().getLocation().add(0.5, 0.5, 0.5) : null;
            if (hLoc != null && (distSq = hLoc.distanceSquared(e.getItem().getLocation())) > radius * radius) {
                e.setCancelled(true);
                this.stats.increment("hopperBatched");
                return;
            }
        }
        if ((window = Math.max(0, this.cfg.getInt("hoppers.batch-window-ticks", 4))) <= 0) {
            return;
        }
        InventoryHolder holder = e.getInventory().getHolder();
        if (!(holder instanceof Hopper)) {
            return;
        }
        Hopper h = (Hopper)holder;
        Block block = h.getBlock();
        if (block == null) {
            return;
        }
        Location loc = block.getLocation();
        long now = this.ticks.currentTick();
        Long last = this.lastMoveTick.get(loc);
        if (last != null && now - last < (long)window) {
            e.setCancelled(true);
            this.stats.increment("hopperBatched");
            return;
        }
        this.lastMoveTick.put(loc, now);
    }

    private Location holderToHopperLocation(InventoryHolder holder) {
        if (holder instanceof Hopper) {
            Hopper h = (Hopper)holder;
            Block block = ((Hopper)holder).getBlock();
            return block != null ? block.getLocation() : null;
        }
        return null;
    }
}

