/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.integration;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardHook {
    private final Plugin plugin;
    private final boolean available;
    private final Set<String> exemptPacketRegions = new HashSet<String>();

    public WorldGuardHook(Plugin plugin, FileConfiguration cfg) {
        this.plugin = plugin;
        this.available = plugin.getServer().getPluginManager().getPlugin("WorldGuard") != null;
        List names = cfg.getStringList("regions.worldguard.exempt-packets");
        if (names != null) {
            this.exemptPacketRegions.addAll(names);
        }
        if (this.available) {
            plugin.getLogger().info("WorldGuard detected; enabling soft region exemptions (" + this.exemptPacketRegions.size() + " regions configured).");
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isPacketsExempt(Player player) {
        if (!this.available || this.exemptPacketRegions.isEmpty() || player == null || !player.isOnline()) {
            return false;
        }
        return this.isLocationInAnyRegion(player.getLocation(), this.exemptPacketRegions);
    }

    public boolean isPacketsExempt(Location loc) {
        if (!this.available || this.exemptPacketRegions.isEmpty() || loc == null) {
            return false;
        }
        return this.isLocationInAnyRegion(loc, this.exemptPacketRegions);
    }

    private boolean isLocationInAnyRegion(Location loc, Set<String> regionNames) {
        try {
            World world = loc.getWorld();
            if (world == null) {
                return false;
            }
            Class<?> bukkitAdapter = Class.forName("com.sk89q.worldedit.bukkit.BukkitAdapter");
            Object adaptedWorld = bukkitAdapter.getMethod("adapt", World.class).invoke(null, world);
            Object adaptedLoc = bukkitAdapter.getMethod("adapt", Location.class).invoke(null, loc);
            Method toBlockPoint = adaptedLoc.getClass().getMethod("toBlockPoint", new Class[0]);
            Object blockVector3 = toBlockPoint.invoke(adaptedLoc, new Object[0]);
            Class<?> wgClass = Class.forName("com.sk89q.worldguard.WorldGuard");
            Object wgInstance = wgClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Object platform = wgClass.getMethod("getPlatform", new Class[0]).invoke(wgInstance, new Object[0]);
            Object regionContainer = platform.getClass().getMethod("getRegionContainer", new Class[0]).invoke(platform, new Object[0]);
            Object regionManager = regionContainer.getClass().getMethod("get", adaptedWorld.getClass()).invoke(regionContainer, adaptedWorld);
            if (regionManager == null) {
                return false;
            }
            Object applicable = regionManager.getClass().getMethod("getApplicableRegions", Class.forName("com.sk89q.worldedit.math.BlockVector3")).invoke(regionManager, blockVector3);
            Iterable regions = (Iterable)applicable.getClass().getMethod("getRegions", new Class[0]).invoke(applicable, new Object[0]);
            for (Object region : regions) {
                String id = (String)region.getClass().getMethod("getId", new Class[0]).invoke(region, new Object[0]);
                if (id == null || !regionNames.contains(id)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

