/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.merging;

import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.pufferLike.hologram.HologramService;
import org.texboobcat.pufferLike.telemetry.StatsService;

public class EntityStackerListener
implements Listener {
    private final Plugin plugin;
    private final FileConfiguration cfg;
    private final StatsService stats;
    private final NamespacedKey stackKey;
    private final HologramService holograms;

    public EntityStackerListener(Plugin plugin, FileConfiguration cfg, StatsService stats, HologramService holograms) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.stats = stats;
        this.stackKey = new NamespacedKey(plugin, "puffer_stack");
        this.holograms = holograms;
    }

    private boolean enabled() {
        return this.cfg.getBoolean("merging.entities.enabled", false);
    }

    private double radius() {
        return this.cfg.getDouble("merging.entities.radius", 8.0);
    }

    private int defaultMaxStack() {
        return Math.max(1, this.cfg.getInt("merging.entities.max-stack-size", 32));
    }

    private boolean showName() {
        return this.cfg.getBoolean("merging.entities.show-name", true);
    }

    private boolean isAllowedType(EntityType type) {
        List whitelist = this.cfg.getStringList("merging.entities.whitelist-types");
        if (whitelist != null && !whitelist.isEmpty()) {
            return whitelist.contains(type.name());
        }
        List blacklist = this.cfg.getStringList("merging.entities.blacklist-types");
        if (blacklist != null && !blacklist.isEmpty()) {
            return !blacklist.contains(type.name());
        }
        return true;
    }

    private int maxStackFor(EntityType type) {
        int def = this.defaultMaxStack();
        String path = "merging.entities.per-type." + type.name() + ".max-stack-size";
        return Math.max(1, this.cfg.getInt(path, def));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent e) {
        if (!this.enabled()) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob spawned = (Mob)livingEntity;
        if (!this.isAllowedType(spawned.getType())) {
            return;
        }
        if (spawned.getCustomName() != null && this.cfg.getBoolean("merging.entities.skip-named", true)) {
            return;
        }
        List<LivingEntity> nearby = spawned.getLocation().getNearbyLivingEntities(this.radius()).stream().filter(le -> le.getType() == spawned.getType() && le.isValid() && le != spawned).toList();
        LivingEntity best = null;
        int bestStack = 0;
        for (LivingEntity le2 : nearby) {
            int s = this.getStack(le2);
            if (s >= this.maxStackFor(spawned.getType()) || best != null && s <= bestStack) continue;
            best = le2;
            bestStack = s;
        }
        if (best != null) {
            this.setStack(best, bestStack + 1);
            this.updateName(best);
            spawned.remove();
            this.stats.increment("entityMerged");
        } else {
            this.setStack((LivingEntity)spawned, Math.min(this.getStack((LivingEntity)spawned), this.maxStackFor(spawned.getType())));
            this.updateName((LivingEntity)spawned);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLethalDamage(EntityDamageEvent e) {
        if (!this.enabled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        if (e.getEntity() instanceof Player) {
            return;
        }
        int stack = this.getStack(le);
        if (stack <= 1) {
            return;
        }
        double health = le.getHealth();
        double finalDamage = e.getFinalDamage();
        if (finalDamage >= health) {
            this.setStack(le, stack - 1);
            this.updateName(le);
            le.setHealth(Math.min(le.getMaxHealth(), Math.max(0.5, le.getMaxHealth())));
            e.setCancelled(true);
            this.stats.increment("entityUnstacked");
        }
    }

    private int getStack(LivingEntity le) {
        PersistentDataContainer pdc = le.getPersistentDataContainer();
        Integer n = (Integer)pdc.get(this.stackKey, PersistentDataType.INTEGER);
        if (n == null || n < 1) {
            n = 1;
        }
        return n;
    }

    private void setStack(LivingEntity le, int n) {
        PersistentDataContainer pdc = le.getPersistentDataContainer();
        int cap = this.maxStackFor(le.getType());
        pdc.set(this.stackKey, PersistentDataType.INTEGER, (Object)Math.max(1, Math.min(n, cap)));
    }

    private void updateName(LivingEntity le) {
        int n = this.getStack(le);
        if (this.showName()) {
            Object base = le.getType().name().toLowerCase().replace('_', ' ');
            base = Character.toUpperCase(((String)base).charAt(0)) + ((String)base).substring(1);
            String name = n > 1 ? (String)base + " x" + n : null;
            le.setCustomName(name);
            le.setCustomNameVisible(n > 1);
        }
        try {
            this.holograms.showMob(le, n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

