/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.merging;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.texboobcat.pufferLike.hologram.HologramService;
import org.texboobcat.pufferLike.telemetry.StatsService;

public class MergingListener
implements Listener {
    private final Plugin plugin;
    private final FileConfiguration cfg;
    private final StatsService stats;
    private final HologramService holograms;

    public MergingListener(Plugin plugin, FileConfiguration cfg, StatsService stats, HologramService holograms) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.stats = stats;
        this.holograms = holograms;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemDespawn(ItemDespawnEvent e) {
        try {
            this.holograms.hide((Entity)e.getEntity());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemPickup(EntityPickupItemEvent e) {
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            Item item = e.getItem();
            if (item == null || item.isDead()) {
                return;
            }
            ItemStack st = item.getItemStack();
            if (st == null) {
                try {
                    this.holograms.hide((Entity)item);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            int amt = st.getAmount();
            if (amt <= 1) {
                try {
                    this.holograms.hide((Entity)item);
                }
                catch (Throwable throwable) {}
            } else {
                try {
                    this.holograms.showItem(item, amt);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemSpawn(ItemSpawnEvent e) {
        if (!this.cfg.getBoolean("merging.items.enabled", true)) {
            return;
        }
        double radius = Math.max(0.5, this.cfg.getDouble("merging.items.radius", 2.5));
        boolean respectMeta = this.cfg.getBoolean("merging.items.respect-metadata", true);
        boolean allowOversize = this.cfg.getBoolean("merging.items.allow-oversize", false);
        int maxEntityStack = Math.max(1, this.cfg.getInt("merging.items.max-entity-stack", 512));
        boolean asyncDefer = this.cfg.getBoolean("merging.items.async-scan", true);
        Item spawned = e.getEntity();
        ItemStack stack = spawned.getItemStack();
        if (stack == null || stack.getAmount() <= 0) {
            return;
        }
        Runnable work = () -> this.mergeNearby(spawned, radius, respectMeta, allowOversize, maxEntityStack);
        if (asyncDefer) {
            Bukkit.getScheduler().runTaskLater(this.plugin, work, 1L);
        } else {
            work.run();
        }
    }

    private void mergeNearby(Item spawned, double radius, boolean respectMeta, boolean allowOversize, int maxEntityStack) {
        if (spawned == null || spawned.isDead()) {
            return;
        }
        ItemStack stack = spawned.getItemStack();
        if (stack == null || stack.getAmount() <= 0) {
            return;
        }
        BoundingBox box = BoundingBox.of((Location)spawned.getLocation(), (double)radius, (double)radius, (double)radius);
        List neighbors = spawned.getWorld().getNearbyEntities(box).stream().filter(ent -> ent instanceof Item).map(ent -> (Item)ent).collect(Collectors.toList());
        for (Item other : neighbors) {
            if (other == spawned || other.isDead() || !this.canMerge(stack, other.getItemStack(), respectMeta)) continue;
            int itemMax = other.getItemStack().getMaxStackSize();
            int max = allowOversize ? Math.max(itemMax, maxEntityStack) : itemMax;
            int space = max - other.getItemStack().getAmount();
            if (space <= 0) continue;
            int move = Math.min(space, stack.getAmount());
            other.getItemStack().setAmount(other.getItemStack().getAmount() + move);
            stack.setAmount(stack.getAmount() - move);
            this.stats.increment("itemMerged");
            try {
                this.holograms.showItem(other, other.getItemStack().getAmount());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (stack.getAmount() > 0) continue;
            try {
                this.holograms.hide((Entity)spawned);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            spawned.remove();
            break;
        }
        if (!spawned.isDead()) {
            try {
                this.holograms.showItem(spawned, stack.getAmount());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean canMerge(ItemStack a, ItemStack b, boolean respectMeta) {
        if (a == null || b == null) {
            return false;
        }
        if (!a.isSimilar(b)) {
            if (!respectMeta) {
                return a.getType() == b.getType();
            }
            return false;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onXpSpawn(EntitySpawnEvent e) {
        if (!this.cfg.getBoolean("merging.xp.enabled", true)) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof ExperienceOrb)) {
            return;
        }
        ExperienceOrb spawned = (ExperienceOrb)entity;
        double radius = Math.max(0.5, this.cfg.getDouble("merging.xp.radius", 3.0));
        int maxOrb = Math.max(1, this.cfg.getInt("merging.xp.max-orb-size", 11));
        Location loc = spawned.getLocation();
        BoundingBox box = BoundingBox.of((Location)loc, (double)radius, (double)radius, (double)radius);
        List neighbors = spawned.getWorld().getNearbyEntities(box).stream().filter(ent -> ent instanceof ExperienceOrb).map(ent -> (ExperienceOrb)ent).collect(Collectors.toList());
        for (ExperienceOrb other : neighbors) {
            int space;
            if (other == spawned || other.isDead() || (space = Math.max(0, maxOrb - other.getExperience())) <= 0) continue;
            int move = Math.min(space, spawned.getExperience());
            other.setExperience(other.getExperience() + move);
            spawned.setExperience(spawned.getExperience() - move);
            this.stats.increment("xpMerged");
            if (spawned.getExperience() <= 0) {
                try {
                    this.holograms.hide((Entity)spawned);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                spawned.remove();
                break;
            }
            try {
                this.holograms.showXp(other, other.getExperience());
            }
            catch (Throwable throwable) {}
        }
        if (!spawned.isDead()) {
            try {
                this.holograms.showXp(spawned, spawned.getExperience());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

