/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.texboobcat.pufferLike.integration.WorldGuardHook;
import org.texboobcat.pufferLike.players.IdleTracker;
import org.texboobcat.pufferLike.proximity.ProximityService;
import org.texboobcat.pufferLike.telemetry.StatsService;

public class PacketOptimizer {
    private final Plugin plugin;
    private final FileConfiguration cfg;
    private final StatsService stats;
    private final ProximityService proximity;
    private final IdleTracker idleTracker;
    private final WorldGuardHook wgHook;
    private ProtocolManager protocolManager;
    private boolean started = false;
    private final Map<Player, Integer> soundsThisTick = new WeakHashMap<Player, Integer>();
    private final Map<Player, Map<String, Integer>> soundBucketsThisTick = new WeakHashMap<Player, Map<String, Integer>>();
    private final Map<Player, Integer> particlesThisTick = new WeakHashMap<Player, Integer>();
    private final Map<Player, Map<String, Integer>> particleBucketsThisTick = new WeakHashMap<Player, Map<String, Integer>>();
    private final Map<Player, Integer> chunksThisTick = new WeakHashMap<Player, Integer>();
    private final Map<Player, Map<Integer, Long>> metadataCooldown = new WeakHashMap<Player, Map<Integer, Long>>();
    private long lastTickMark = -1L;
    private final ConcurrentHashMap<String, Integer> chunkSuppressHeat = new ConcurrentHashMap();

    public PacketOptimizer(Plugin plugin, FileConfiguration cfg, StatsService stats, ProximityService proximity, IdleTracker idleTracker, WorldGuardHook wgHook) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.stats = stats;
        this.proximity = proximity;
        this.idleTracker = idleTracker;
        this.wgHook = wgHook;
    }

    public boolean isAvailable() {
        return Bukkit.getPluginManager().getPlugin("ProtocolLib") != null;
    }

    public void start() {
        if (this.started) {
            return;
        }
        if (!this.cfg.getBoolean("packets.enabled", false)) {
            return;
        }
        if (!this.isAvailable()) {
            this.plugin.getLogger().warning("ProtocolLib not found; packets module disabled.");
            return;
        }
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.registerEntityVisibilityCulling();
        this.registerSpawnCulling();
        this.registerSoundThrottle();
        this.registerParticleThrottle();
        this.registerMetadataRateLimit();
        this.registerChunkStreamingPacing();
        this.registerIdleCompression();
        this.started = true;
        this.plugin.getLogger().info("PacketOptimizer started (ProtocolLib detected).");
    }

    public void stop() {
        if (!this.started || this.protocolManager == null) {
            return;
        }
        try {
            this.protocolManager.removePacketListeners(this.plugin);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.started = false;
    }

    private void registerEntityVisibilityCulling() {
        if (!this.cfg.getBoolean("packets.hide-far-entities.enabled", true)) {
            return;
        }
        final double maxDist = this.cfg.getDouble("packets.hide-far-entities.max-distance", 96.0);
        final boolean exemptPlayers = this.cfg.getBoolean("packets.hide-far-entities.exempt-players", true);
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter(this.plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.ENTITY_METADATA, PacketType.Play.Server.ENTITY_EQUIPMENT, PacketType.Play.Server.ENTITY_VELOCITY, PacketType.Play.Server.REL_ENTITY_MOVE, PacketType.Play.Server.REL_ENTITY_MOVE_LOOK, PacketType.Play.Server.ENTITY_LOOK}){

            public void onPacketSending(PacketEvent event) {
                double limitSq;
                Entity maybePlayer;
                Player viewer = event.getPlayer();
                if (viewer == null || !viewer.isOnline()) {
                    return;
                }
                if (PacketOptimizer.this.wgHook != null && PacketOptimizer.this.wgHook.isPacketsExempt(viewer)) {
                    return;
                }
                if (exemptPlayers && (maybePlayer = (Entity)event.getPacket().getEntityModifier(viewer.getWorld()).readSafely(0)) instanceof Player) {
                    return;
                }
                Entity entity = (Entity)event.getPacket().getEntityModifier(viewer.getWorld()).readSafely(0);
                if (entity == null || entity.getWorld() != viewer.getWorld()) {
                    return;
                }
                if (PacketOptimizer.this.wgHook != null && PacketOptimizer.this.wgHook.isPacketsExempt(entity.getLocation())) {
                    return;
                }
                double distSq = viewer.getLocation().distanceSquared(entity.getLocation());
                if (distSq > (limitSq = maxDist * maxDist)) {
                    event.setCancelled(true);
                    PacketOptimizer.this.stats.increment("packetsSuppressed");
                }
            }
        });
    }

    private void registerSoundThrottle() {
        if (!this.cfg.getBoolean("packets.sound-throttle.enabled", true)) {
            return;
        }
        final int maxPerTick = Math.max(1, this.cfg.getInt("packets.sound-throttle.max-per-tick", 5));
        final boolean idleEnabled = this.cfg.getBoolean("packets.player-idle-compression.enabled", false);
        final long idleThreshSec = Math.max(1, this.cfg.getInt("packets.player-idle-compression.idle-threshold-seconds", 60));
        final double idleSoundScale = Math.max(0.05, Math.min(1.0, this.cfg.getDouble("packets.player-idle-compression.sound-scale", 0.5)));
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter(this.plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.NAMED_SOUND_EFFECT}){

            public void onPacketSending(PacketEvent event) {
                Player p = event.getPlayer();
                if (p == null || !p.isOnline()) {
                    return;
                }
                if (PacketOptimizer.this.wgHook != null && PacketOptimizer.this.wgHook.isPacketsExempt(p)) {
                    return;
                }
                long nowTick = p.getWorld().getFullTime();
                if (nowTick != PacketOptimizer.this.lastTickMark) {
                    PacketOptimizer.this.lastTickMark = nowTick;
                    PacketOptimizer.this.soundsThisTick.clear();
                    PacketOptimizer.this.soundBucketsThisTick.clear();
                    PacketOptimizer.this.particlesThisTick.clear();
                    PacketOptimizer.this.particleBucketsThisTick.clear();
                    PacketOptimizer.this.chunksThisTick.clear();
                }
                int used = PacketOptimizer.this.soundsThisTick.getOrDefault(p, 0);
                int effectiveMax = maxPerTick;
                if (idleEnabled && PacketOptimizer.this.idleTracker != null && PacketOptimizer.this.idleTracker.isIdle(p, nowTick, idleThreshSec)) {
                    effectiveMax = Math.max(1, (int)Math.floor((double)maxPerTick * idleSoundScale));
                }
                if (used >= effectiveMax) {
                    event.setCancelled(true);
                    PacketOptimizer.this.stats.increment("packetsSuppressed");
                    PacketOptimizer.this.stats.increment("packetsSuppressed.sounds");
                    return;
                }
                PacketOptimizer.this.soundsThisTick.put(p, used + 1);
                if (PacketOptimizer.this.cfg.getBoolean("packets.sound-throttle.de-duplicate.enabled", true)) {
                    double bucket = Math.max(1.0, PacketOptimizer.this.cfg.getDouble("packets.sound-throttle.de-duplicate.bucket-radius", 8.0));
                    int maxPerBucket = Math.max(1, PacketOptimizer.this.cfg.getInt("packets.sound-throttle.de-duplicate.max-per-bucket", 2));
                    double sx = 0.0;
                    double sy = 0.0;
                    double sz = 0.0;
                    boolean have = false;
                    try {
                        Double dx = (Double)event.getPacket().getDoubles().readSafely(0);
                        Double dy = (Double)event.getPacket().getDoubles().readSafely(1);
                        Double dz = (Double)event.getPacket().getDoubles().readSafely(2);
                        if (dx != null && dy != null && dz != null) {
                            sx = dx;
                            sy = dy;
                            sz = dz;
                            have = true;
                        }
                    }
                    catch (Throwable dx) {
                        // empty catch block
                    }
                    if (!have) {
                        try {
                            Integer ix = (Integer)event.getPacket().getIntegers().readSafely(0);
                            Integer iy = (Integer)event.getPacket().getIntegers().readSafely(1);
                            Integer iz = (Integer)event.getPacket().getIntegers().readSafely(2);
                            if (ix != null && iy != null && iz != null) {
                                sx = ix.intValue();
                                sy = iy.intValue();
                                sz = iz.intValue();
                                have = true;
                            }
                        }
                        catch (Throwable ix) {
                            // empty catch block
                        }
                    }
                    if (have) {
                        int bx = (int)Math.floor(sx / bucket);
                        int by = (int)Math.floor(sy / bucket);
                        int bz = (int)Math.floor(sz / bucket);
                        String key = bx + "@" + by + "@" + bz;
                        Map map = PacketOptimizer.this.soundBucketsThisTick.computeIfAbsent(p, k -> new HashMap());
                        int c = map.getOrDefault(key, 0);
                        if (c >= maxPerBucket) {
                            event.setCancelled(true);
                            PacketOptimizer.this.stats.increment("packetsSuppressed");
                            PacketOptimizer.this.stats.increment("packetsSuppressed.sounds");
                            return;
                        }
                        map.put(key, c + 1);
                    }
                }
            }
        });
    }

    private void registerParticleThrottle() {
        if (!this.cfg.getBoolean("packets.particle-throttle.enabled", true)) {
            return;
        }
        final int maxCluster = Math.max(1, this.cfg.getInt("packets.particle-throttle.max-per-cluster", 20));
        double collapseRadius = Math.max(1.0, this.cfg.getDouble("packets.particle-throttle.collapse-radius", 16.0));
        final double bucket = Math.max(1.0, collapseRadius);
        final boolean idleEnabled = this.cfg.getBoolean("packets.player-idle-compression.enabled", false);
        final long idleThreshSec = Math.max(1, this.cfg.getInt("packets.player-idle-compression.idle-threshold-seconds", 60));
        final double idleParticleScale = Math.max(0.05, Math.min(1.0, this.cfg.getDouble("packets.player-idle-compression.particle-scale", 0.5)));
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter(this.plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.WORLD_PARTICLES}){

            public void onPacketSending(PacketEvent event) {
                Player p = event.getPlayer();
                if (p == null || !p.isOnline()) {
                    return;
                }
                if (PacketOptimizer.this.wgHook != null && PacketOptimizer.this.wgHook.isPacketsExempt(p)) {
                    return;
                }
                long nowTick = p.getWorld().getFullTime();
                if (nowTick != PacketOptimizer.this.lastTickMark) {
                    PacketOptimizer.this.lastTickMark = nowTick;
                    PacketOptimizer.this.soundsThisTick.clear();
                    PacketOptimizer.this.particlesThisTick.clear();
                    PacketOptimizer.this.particleBucketsThisTick.clear();
                    PacketOptimizer.this.chunksThisTick.clear();
                }
                String typeName = "";
                try {
                    EnumWrappers.Particle particle = (EnumWrappers.Particle)event.getPacket().getParticles().readSafely(0);
                    typeName = particle != null ? particle.name() : "unknown";
                }
                catch (Throwable particle) {
                    // empty catch block
                }
                double px = 0.0;
                double py = 0.0;
                double pz = 0.0;
                try {
                    px = ((Float)event.getPacket().getFloat().read(0)).floatValue();
                    py = ((Float)event.getPacket().getFloat().read(1)).floatValue();
                    pz = ((Float)event.getPacket().getFloat().read(2)).floatValue();
                }
                catch (Throwable ignored) {
                    try {
                        px = (Double)event.getPacket().getDoubles().readSafely(0);
                        py = (Double)event.getPacket().getDoubles().readSafely(1);
                        pz = (Double)event.getPacket().getDoubles().readSafely(2);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                int bx = (int)Math.floor(px / bucket);
                int by = (int)Math.floor(py / bucket);
                int bz = (int)Math.floor(pz / bucket);
                String key = typeName + "@" + bx + "@" + by + "@" + bz;
                Map map = PacketOptimizer.this.particleBucketsThisTick.computeIfAbsent(p, k -> new HashMap());
                int count = map.getOrDefault(key, 0);
                int effectiveMax = maxCluster;
                if (idleEnabled && PacketOptimizer.this.idleTracker != null && PacketOptimizer.this.idleTracker.isIdle(p, nowTick, idleThreshSec)) {
                    effectiveMax = Math.max(1, (int)Math.floor((double)maxCluster * idleParticleScale));
                }
                if (count >= effectiveMax) {
                    event.setCancelled(true);
                    PacketOptimizer.this.stats.increment("packetsSuppressed");
                    PacketOptimizer.this.stats.increment("packetsSuppressed.particles");
                    return;
                }
                map.put(key, count + 1);
            }
        });
    }

    private void registerMetadataRateLimit() {
        if (!this.cfg.getBoolean("packets.metadata-rate-limit.enabled", false)) {
            return;
        }
        final long interval = Math.max(1, this.cfg.getInt("packets.metadata-rate-limit.interval-ticks", 5));
        final HashSet whitelistIdx = new HashSet(this.cfg.getIntegerList("packets.metadata-rate-limit.whitelist-indexes"));
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter(this.plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.ENTITY_METADATA}){

            public void onPacketSending(PacketEvent event) {
                Player p = event.getPlayer();
                if (p == null || !p.isOnline()) {
                    return;
                }
                Entity entity = (Entity)event.getPacket().getEntityModifier(p.getWorld()).readSafely(0);
                if (entity == null) {
                    return;
                }
                if (PacketOptimizer.this.wgHook != null && (PacketOptimizer.this.wgHook.isPacketsExempt(p) || PacketOptimizer.this.wgHook.isPacketsExempt(entity.getLocation()))) {
                    return;
                }
                long nowTick = p.getWorld().getFullTime();
                try {
                    List list = (List)event.getPacket().getWatchableCollectionModifier().read(0);
                    if (list != null) {
                        for (WrappedWatchableObject w : list) {
                            if (!whitelistIdx.contains(w.getIndex())) continue;
                            return;
                        }
                    }
                }
                catch (Throwable list) {
                    // empty catch block
                }
                Map perEntity = PacketOptimizer.this.metadataCooldown.computeIfAbsent(p, k -> new HashMap());
                int id = entity.getEntityId();
                long last = perEntity.getOrDefault(id, Long.MIN_VALUE);
                if (nowTick - last < interval) {
                    event.setCancelled(true);
                    PacketOptimizer.this.stats.increment("packetsSuppressed");
                    PacketOptimizer.this.stats.increment("packetsSuppressed.metadata");
                    return;
                }
                perEntity.put(id, nowTick);
            }
        });
    }

    private void registerChunkStreamingPacing() {
        if (!this.cfg.getBoolean("packets.chunk-streaming.enabled", true)) {
            return;
        }
        final int maxPerTick = Math.max(1, this.cfg.getInt("packets.chunk-streaming.max-per-tick", 2));
        final int warmupTicks = Math.max(0, this.cfg.getInt("packets.chunk-streaming.warmup-ticks", 200));
        final boolean prioritizeHeading = this.cfg.getBoolean("packets.chunk-streaming.prioritize-player-heading", true);
        final boolean tpsGuardEnabled = this.cfg.getBoolean("packets.chunk-streaming.tps-guard.enabled", true);
        final double tpsGuardThreshold = this.cfg.getDouble("packets.chunk-streaming.tps-guard.threshold", 18.5);
        final boolean rampEnabled = this.cfg.getBoolean("packets.chunk-streaming.ramp.enabled", true);
        final int rampBase = Math.max(1, this.cfg.getInt("packets.chunk-streaming.ramp.base", Math.min(4, maxPerTick)));
        final int rampMax = Math.max(rampBase, this.cfg.getInt("packets.chunk-streaming.ramp.max", maxPerTick));
        final int rampStep = Math.max(1, this.cfg.getInt("packets.chunk-streaming.ramp.step", 1));
        final int rampPeriod = Math.max(1, this.cfg.getInt("packets.chunk-streaming.ramp.period-ticks", 40));
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter(this.plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.MAP_CHUNK}){

            public void onPacketSending(PacketEvent event) {
                int allowance;
                Player p = event.getPlayer();
                if (p == null || !p.isOnline()) {
                    return;
                }
                if (PacketOptimizer.this.wgHook != null && PacketOptimizer.this.wgHook.isPacketsExempt(p)) {
                    return;
                }
                long nowTick = p.getWorld().getFullTime();
                if (p.getTicksLived() < warmupTicks) {
                    return;
                }
                if (tpsGuardEnabled) {
                    try {
                        double[] tps = Bukkit.getServer().getTPS();
                        if (tps != null && tps.length > 0 && tps[0] >= tpsGuardThreshold) {
                            return;
                        }
                    }
                    catch (Throwable tps) {
                        // empty catch block
                    }
                }
                if (nowTick != PacketOptimizer.this.lastTickMark) {
                    PacketOptimizer.this.lastTickMark = nowTick;
                    PacketOptimizer.this.soundsThisTick.clear();
                    PacketOptimizer.this.particlesThisTick.clear();
                    PacketOptimizer.this.particleBucketsThisTick.clear();
                    PacketOptimizer.this.chunksThisTick.clear();
                }
                int used = PacketOptimizer.this.chunksThisTick.getOrDefault(p, 0);
                if (rampEnabled) {
                    int ticksAfterWarmup = Math.max(0, p.getTicksLived() - warmupTicks);
                    int steps = ticksAfterWarmup / rampPeriod;
                    allowance = Math.min(rampMax, rampBase + steps * rampStep);
                } else {
                    allowance = maxPerTick;
                }
                if (prioritizeHeading) {
                    try {
                        Integer cx = (Integer)event.getPacket().getIntegers().readSafely(0);
                        Integer cz = (Integer)event.getPacket().getIntegers().readSafely(1);
                        if (cx != null && cz != null) {
                            Vector dir;
                            double centerX = (double)(cx << 4) + 8.0;
                            double centerZ = (double)(cz << 4) + 8.0;
                            Location eye = p.getEyeLocation();
                            Vector to = new Vector(centerX - eye.getX(), 0.0, centerZ - eye.getZ()).normalize();
                            double dot = to.dot(dir = eye.getDirection().setY(0).normalize());
                            if (dot > 0.7) {
                                allowance = maxPerTick + 1;
                            }
                        }
                    }
                    catch (Throwable cx) {
                        // empty catch block
                    }
                }
                if (used >= allowance) {
                    try {
                        Integer cx = (Integer)event.getPacket().getIntegers().readSafely(0);
                        Integer cz = (Integer)event.getPacket().getIntegers().readSafely(1);
                        if (cx != null && cz != null) {
                            String key = p.getWorld().getName() + "@" + cx + "@" + cz;
                            PacketOptimizer.this.chunkSuppressHeat.merge(key, 1, Integer::sum);
                        }
                    }
                    catch (Throwable throwable) {}
                } else {
                    PacketOptimizer.this.chunksThisTick.put(p, used + 1);
                }
            }
        });
    }

    private void registerSpawnCulling() {
        if (!this.cfg.getBoolean("packets.hide-far-entities.enabled", true)) {
            return;
        }
        final double maxDist = this.cfg.getDouble("packets.hide-far-entities.max-distance", 96.0);
        boolean exemptPlayers = this.cfg.getBoolean("packets.hide-far-entities.exempt-players", true);
        this.protocolManager.addPacketListener((PacketListener)new PacketAdapter(this.plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.SPAWN_ENTITY}){

            public void onPacketSending(PacketEvent event) {
                Player viewer = event.getPlayer();
                if (viewer == null || !viewer.isOnline()) {
                    return;
                }
                if (PacketOptimizer.this.wgHook != null && PacketOptimizer.this.wgHook.isPacketsExempt(viewer)) {
                    return;
                }
                Entity entity = (Entity)event.getPacket().getEntityModifier(viewer.getWorld()).readSafely(0);
                if (entity != null) {
                    double limitSq;
                    if (PacketOptimizer.this.wgHook != null && PacketOptimizer.this.wgHook.isPacketsExempt(entity.getLocation())) {
                        return;
                    }
                    double distSq = viewer.getLocation().distanceSquared(entity.getLocation());
                    if (distSq > (limitSq = maxDist * maxDist)) {
                        event.setCancelled(true);
                        PacketOptimizer.this.stats.increment("packetsSuppressed");
                    }
                } else {
                    try {
                        Integer x = (Integer)event.getPacket().getIntegers().readSafely(0);
                        Integer y = (Integer)event.getPacket().getIntegers().readSafely(1);
                        Integer z = (Integer)event.getPacket().getIntegers().readSafely(2);
                        if (x != null && y != null && z != null) {
                            double limitSq;
                            Location eloc = new Location(viewer.getWorld(), (double)x.intValue(), (double)y.intValue(), (double)z.intValue());
                            if (PacketOptimizer.this.wgHook != null && PacketOptimizer.this.wgHook.isPacketsExempt(eloc)) {
                                return;
                            }
                            double distSq = viewer.getLocation().distanceSquared(eloc);
                            if (distSq > (limitSq = maxDist * maxDist)) {
                                event.setCancelled(true);
                                PacketOptimizer.this.stats.increment("packetsSuppressed");
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public List<String> getTopChunkSuppressions(int limit) {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.chunkSuppressHeat.entrySet());
        list.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
        int n = Math.min(limit, list.size());
        ArrayList<String> out = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            out.add((String)e.getKey() + " = " + String.valueOf(e.getValue()));
        }
        return out;
    }

    public List<ChunkSuppression> getTopChunkSuppressionEntries(int limit) {
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.chunkSuppressHeat.entrySet());
        list.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
        int n = Math.min(limit, list.size());
        ArrayList<ChunkSuppression> out = new ArrayList<ChunkSuppression>(n);
        for (int i = 0; i < n; ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            String key = (String)e.getKey();
            String[] parts = key.split("@");
            if (parts.length != 3) continue;
            try {
                String world = parts[0];
                int cx = Integer.parseInt(parts[1]);
                int cz = Integer.parseInt(parts[2]);
                out.add(new ChunkSuppression(world, cx, cz, (Integer)e.getValue()));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return out;
    }

    private void registerIdleCompression() {
        if (!this.cfg.getBoolean("packets.player-idle-compression.enabled", false)) {
            return;
        }
        this.plugin.getLogger().info("Player idle compression enabled (stub). No packets are altered yet.");
    }

    public static final class ChunkSuppression {
        public final String world;
        public final int cx;
        public final int cz;
        public final int count;

        public ChunkSuppression(String world, int cx, int cz, int count) {
            this.world = world;
            this.cx = cx;
            this.cz = cz;
            this.count = count;
        }
    }
}

