/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.performance;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SharedBudgetService {
    private final Plugin plugin;
    private final FileConfiguration cfg;
    private final Map<String, Integer> weights = new HashMap<String, Integer>();
    private final Map<String, Integer> remaining = new HashMap<String, Integer>();
    private int totalBudget;

    public SharedBudgetService(Plugin plugin, FileConfiguration cfg) {
        this.plugin = plugin;
        this.cfg = cfg;
        this.reload();
        new BukkitRunnable(){

            public void run() {
                SharedBudgetService.this.resetBudgets();
            }
        }.runTaskTimer(plugin, 1L, 1L);
    }

    public synchronized void reload() {
        this.totalBudget = Math.max(0, this.cfg.getInt("performance.tick-budget-per-tick", 0));
        this.weights.clear();
        this.weights.put("AI", Math.max(0, this.cfg.getInt("performance.priorities.AI", 40)));
        this.weights.put("HOPPERS", Math.max(0, this.cfg.getInt("performance.priorities.HOPPERS", 30)));
        this.weights.put("PHYSICS", Math.max(0, this.cfg.getInt("performance.priorities.PHYSICS", 30)));
        this.resetBudgets();
    }

    private synchronized void resetBudgets() {
        int totalWeight = this.weights.values().stream().mapToInt(i -> i).sum();
        this.remaining.clear();
        if (this.totalBudget <= 0 || totalWeight <= 0) {
            return;
        }
        for (Map.Entry<String, Integer> e : this.weights.entrySet()) {
            int allowance = (int)Math.floor((double)this.totalBudget * (double)e.getValue().intValue() / (double)totalWeight);
            this.remaining.put(e.getKey(), allowance);
        }
    }

    public synchronized boolean tryConsume(String category, int units) {
        if (this.totalBudget <= 0) {
            return true;
        }
        int left = this.remaining.getOrDefault(category, 0);
        if (left < units) {
            return false;
        }
        this.remaining.put(category, left - units);
        return true;
    }

    public synchronized int remaining(String category) {
        return this.remaining.getOrDefault(category, 0);
    }
}

