/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.pufferLike.players;

import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class IdleTracker
implements Listener {
    private final Plugin plugin;
    private final Map<Player, Long> lastActiveTick = new WeakHashMap<Player, Long>();

    public IdleTracker(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent e) {
        this.markActive(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onQuit(PlayerQuitEvent e) {
        this.lastActiveTick.remove(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent e) {
        boolean moved;
        if (e.getFrom() == null || e.getTo() == null) {
            return;
        }
        if (e.getFrom().getWorld() != e.getTo().getWorld()) {
            this.markActive(e.getPlayer());
            return;
        }
        boolean bl = moved = e.getFrom().distanceSquared(e.getTo()) > 1.0E-4 || (double)Math.abs(e.getFrom().getYaw() - e.getTo().getYaw()) > 0.1 || (double)Math.abs(e.getFrom().getPitch() - e.getTo().getPitch()) > 0.1;
        if (moved) {
            this.markActive(e.getPlayer());
        }
    }

    public void markActive(Player p) {
        if (p == null || !p.isOnline()) {
            return;
        }
        this.lastActiveTick.put(p, p.getWorld().getFullTime());
    }

    public boolean isIdle(Player p, long nowTick, long thresholdSeconds) {
        if (p == null || !p.isOnline()) {
            return false;
        }
        Long last = this.lastActiveTick.get(p);
        if (last == null) {
            return false;
        }
        long thresholdTicks = Math.max(1L, thresholdSeconds) * 20L;
        return nowTick - last >= thresholdTicks;
    }
}

